/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

public class HarmonicCalculator {
    protected int indexL;
    protected int indexM;
    int maxL = 100;
    double[] coeff = new double[101];
    int nTheta = 1000;
    double[] thetaTab = new double[this.nTheta + 1];

    public int getL() {
        return this.indexL;
    }

    public int getM() {
        return this.indexM;
    }

    public void setLM(int n, int n2) {
        this.indexL = Math.min(Math.abs(n), this.maxL);
        this.indexM = Math.min(this.indexL, Math.max(-this.indexL, n2));
        this.initCoeff();
    }

    double yLM(double d, double d2) {
        double d3 = this.amplitude(d, d2);
        if (this.indexM > 0) {
            d3 *= Math.cos((double)this.indexM * d2);
        } else if (this.indexM < 0) {
            d3 *= Math.sin((double)(-this.indexM) * d2);
        }
        return d3;
    }

    double amplitude(double d, double d2) {
        int n = (int)Math.floor(d / Math.PI * (double)this.nTheta + 0.5);
        if ((n %= this.nTheta + 1) < 0) {
            n += this.nTheta;
        }
        return this.thetaTab[n];
    }

    double phase(double d) {
        return (double)this.indexM * d;
    }

    double computeYLM(double d, double d2) {
        int n = Math.abs(this.indexM);
        double d3 = this.truePLM(Math.cos(d), Math.sin(d));
        if (this.indexM > 0) {
            d3 *= Math.cos((double)n * d2);
        } else if (this.indexM < 0) {
            d3 *= Math.sin((double)n * d2);
        }
        return d3;
    }

    void fillTables() {
        for (int i = 0; i <= this.nTheta; ++i) {
            double d = (double)i * Math.PI / (double)this.nTheta;
            this.thetaTab[i] = this.truePLM(Math.cos(d), Math.sin(d));
        }
    }

    public double truePLM(double d, double d2) {
        int n = Math.abs(this.indexM);
        double d3 = this.plm(d);
        for (int i = 0; i < n; ++i) {
            d3 *= d2;
        }
        return d3;
    }

    double plm(double d) {
        int n = Math.abs(this.indexM);
        double d2 = 0.0;
        double d3 = (this.indexL - n) % 2 == 0 ? 1.0 : d;
        double d4 = d * d;
        int n2 = (this.indexL - n) % 2;
        while (n2 <= this.indexL - n) {
            d2 += this.coeff[n2] * d3;
            n2 += 2;
            d3 *= d4;
        }
        return d2;
    }

    void initCoeff() {
        int n;
        double d;
        int n2;
        this.indexL = Math.min(this.indexL, this.maxL);
        this.indexM = Math.min(this.indexM, this.indexL);
        int n3 = Math.abs(this.indexM);
        double d2 = (double)this.indexL * (double)(this.indexL + 1);
        this.coeff[0] = 1.0;
        for (n2 = this.indexL; n2 > n3; --n2) {
            d = Math.sqrt(d2 - (double)(n2 * (n2 - 1)));
            n = (this.indexL - n2) % 2;
            if (n == 1) {
                this.coeff[0] = 0.0;
            }
            for (int i = n; i <= this.indexL - n2; i += 2) {
                if (i > 0) {
                    int n4 = i - 1;
                    this.coeff[n4] = this.coeff[n4] + (double)i * this.coeff[i] / d;
                }
                this.coeff[i + 1] = (double)(-(i + 2 * n2)) * this.coeff[i] / d;
            }
        }
        n2 = 200;
        d = 0.0;
        for (n = -n2; n <= n2; ++n) {
            double d3 = (double)n / (double)n2;
            d = Math.max(d, Math.abs(this.truePLM(d3, Math.sqrt(1.0 - d3 * d3))));
        }
        n = 0;
        while (n <= this.indexL - n3) {
            int n5 = n++;
            this.coeff[n5] = this.coeff[n5] / d;
        }
        this.fillTables();
    }
}

