/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.acq.DataSrcSupport;

public class HarmonicOscillator
extends DataSrcSupport {
    double theta;
    int thetaMax = 100;
    int dx = 1;
    int MaxNiveaux = 12;
    double EMax;
    int iWeight = 0;
    double maxScaleWeight = 0.5;
    boolean imageInvalid = true;
    protected double xMean = 0.0;
    protected double eMean = 2.5;
    protected boolean coherentMode = false;
    protected double xMax;
    public double[] weight = new double[this.MaxNiveaux];
    public double[][] phi = new double[this.MaxNiveaux][this.NPoints];
    public double[] x = new double[this.NPoints];
    public double[] proba = new double[this.NPoints];
    protected int NNiveaux;
    protected int NPoints = 200;

    public double getMeanPosition() {
        return this.xMean;
    }

    public double getMeanEnergy() {
        return this.eMean;
    }

    public void setMeanEnergy(double d) {
        this.eMean = d;
        this.setCoherentMode(true);
        this.informObservers();
    }

    public void setCoherentMode(boolean bl) {
        this.coherentMode = bl;
    }

    public double getXMax() {
        return this.xMax;
    }

    public int getNNiveaux() {
        return this.NNiveaux;
    }

    public int getNPoints() {
        return this.NPoints;
    }

    public void initNNiveaux(int n) {
        this.NNiveaux = n;
        this.EMax = this.NNiveaux;
        this.xMax = this.xFromPotential(this.EMax) + 1.0;
        this.BuildPhi();
    }

    public void BuildPhi() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.NPoints; ++n2) {
            this.phi[0][n2] = 1.0;
            this.proba[n2] = 1.0;
            this.x[n2] = -this.xMax + (double)2 * this.xMax * (double)n2 / (double)(this.NPoints - 1);
            this.phi[1][n2] = (double)2 * this.x[n2];
            for (n = 2; n < this.NNiveaux; ++n) {
                this.phi[n][n2] = (double)2 * this.x[n2] * this.phi[n - 1][n2] - (double)(2 * (n - 1)) * this.phi[n - 2][n2];
            }
        }
        double d = 1.0;
        for (n = 0; n < this.MaxNiveaux; ++n) {
            if (n > 0) {
                d *= (double)(2 * n);
            }
            for (n2 = 0; n2 < this.NPoints; ++n2) {
                double[] dArray = this.phi[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] * (Math.exp(-this.x[n2] * this.x[n2] / (double)2) / Math.sqrt(d) / (double)2);
            }
        }
    }

    public double getPotential(double d) {
        return d * d / (double)2;
    }

    public double xFromPotential(double d) {
        return Math.sqrt((double)2 * d);
    }

    public void computeWeight() {
        double d;
        this.maxScaleWeight = 0.5;
        double d2 = Math.sqrt(this.eMean - 0.5);
        this.weight[0] = d = Math.exp(-d2 * d2);
        if (this.weight[0] > this.maxScaleWeight) {
            this.maxScaleWeight = 1.0;
        }
        double d3 = 1.0;
        double d4 = 1.0;
        for (int i = 1; i < this.NNiveaux; ++i) {
            d3 = d3 * d2 * d2;
            this.weight[i] = d * d3 / (d4 *= (double)i);
            if (!(this.weight[i] > this.maxScaleWeight)) continue;
            this.maxScaleWeight = 1.0;
        }
    }

    public void normalizeWeight() {
        int n;
        double d = 0.0;
        this.maxScaleWeight = 0.5;
        for (n = 0; n < this.NNiveaux; ++n) {
            d += this.weight[n];
        }
        if (d > 0.0) {
            for (n = 0; n < this.NNiveaux; ++n) {
                int n2 = n;
                this.weight[n2] = this.weight[n2] / d;
                if (!(this.weight[n] > this.maxScaleWeight)) continue;
                this.maxScaleWeight = 1.0;
            }
        } else {
            this.weight[0] = 1.0;
        }
    }

    public void computeProba() {
        if (this.coherentMode) {
            this.computeProbaCoherentState();
        } else {
            this.computeProbaAnyState();
        }
    }

    void computeProbaAnyState() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.NNiveaux; ++n) {
            d3 += this.weight[n];
            d4 += ((double)n + 0.5) * this.weight[n];
        }
        if (d3 == 0.0) {
            this.weight[0] = 1.0;
            d3 = 1.0;
            this.eMean = 0.5;
        } else {
            this.eMean = d4 / d3;
        }
        for (n = 0; n < this.NPoints; ++n) {
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i = 0; i < this.NNiveaux; ++i) {
                d5 += Math.sqrt(this.weight[i]) * this.phi[i][n] * Math.cos((double)i * this.theta / (double)this.thetaMax * (double)2 * Math.PI);
                d6 += Math.sqrt(this.weight[i]) * this.phi[i][n] * Math.sin((double)i * this.theta / (double)this.thetaMax * (double)2 * Math.PI);
            }
            this.proba[n] = (d5 * d5 + d6 * d6) * (double)3 / d3;
            d += this.proba[n];
            d2 += this.x[n] * this.proba[n];
        }
        this.xMean = d2 / d;
        this.informObservers();
    }

    void computeProbaCoherentState() {
        this.xMean = Math.sqrt(this.eMean - 0.5) * Math.sqrt(2.0) * Math.cos(Math.PI * 2 * this.theta / (double)this.thetaMax);
        for (int i = 0; i < this.NPoints; ++i) {
            this.proba[i] = Math.exp(-(this.x[i] - this.xMean) * (this.x[i] - this.xMean));
            if (!(this.proba[i] < 1.0E-6)) continue;
            this.proba[i] = 0.0;
        }
    }

    public HarmonicOscillator() {
        this.initNNiveaux(this.MaxNiveaux);
        for (int i = 0; i < this.NNiveaux; ++i) {
            this.weight[i] = 0.0;
        }
        this.weight[9] = 0.25;
        this.weight[8] = 0.25;
        this.weight[7] = 0.25;
        this.weight[6] = 0.25;
        this.computeProba();
    }

    public void update() {
        this.theta = this.getTime() * (double)30 % (double)this.thetaMax;
        this.computeProba();
    }
}

