/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import phy.acq.Simulator;
import phy.control.HotHLine;
import phy.graphe.BufferedPanel;
import phy.quanta.HarmonicOscillator;
import phy.util.DoublePoint;
import phy.util.MathTools;

public class HarmonicViewerPotential
extends BufferedPanel {
    protected HarmonicOscillator oscillator;
    protected Simulator simulator;
    protected int nLevelsShown = 1000;
    protected boolean thickLine = false;

    public void setNLevelsShown(int n) {
        this.nLevelsShown = n;
    }

    public int getNLevelsShown() {
        return this.nLevelsShown;
    }

    public void setThickLine(boolean bl) {
        this.thickLine = bl;
    }

    public boolean isThickLine() {
        return this.thickLine;
    }

    public void build() {
        this.graphics.setWindow(-this.oscillator.getXMax(), -0.1, this.oscillator.getXMax(), this.oscillator.getNNiveaux() + 1);
    }

    public HarmonicViewerPotential(Simulator simulator) {
        this.simulator = simulator;
        this.oscillator = this.oscillator = (HarmonicOscillator)simulator.getDataSrc();
        this.graphics.setHMargin(20);
        this.graphics.setVMargin(20);
        this.setMouseActive(true);
    }

    public void paintCore() {
        int n;
        this.graphics.setClipping(true);
        this.graphics.setColor(Color.white);
        this.graphics.drawArrow(new DoublePoint(-this.oscillator.getXMax(), 0.0), new DoublePoint(this.oscillator.getXMax(), 0.0), 7);
        this.graphics.drawTeX("x", new DoublePoint(this.oscillator.getXMax(), 0.0 - this.graphics.getVPixel()), 5);
        this.graphics.setColor(Color.green);
        for (n = 0; n < this.getWidth() - 1; n += 2) {
            double d = this.graphics.xUser(n);
            double d2 = this.graphics.xUser(n + 2);
            if (this.isThickLine()) {
                this.graphics.drawLineThick(d, this.oscillator.getPotential(d), d2, this.oscillator.getPotential(d2));
                continue;
            }
            this.graphics.drawLine(d, this.oscillator.getPotential(d), d2, this.oscillator.getPotential(d2));
        }
        for (n = 0; n < this.oscillator.getNNiveaux() && n < this.getNLevelsShown(); ++n) {
            this.graphics.setColor(Color.gray);
            this.graphics.drawLine(-this.oscillator.getXMax(), (double)n + 0.5, this.oscillator.getXMax(), (double)n + 0.5);
            this.graphics.setColor(Color.white);
            this.graphics.drawString(String.valueOf("n = ").concat(String.valueOf(n)), new DoublePoint(this.oscillator.getXMax(), (double)n + 0.5 + (double)2 * this.graphics.getVPixel()), 2);
            if (this.isFlagSet("EVEN")) {
                if (n % 2 == 0) {
                    this.graphics.setColor(Color.yellow.brighter());
                } else {
                    this.graphics.setColor(Color.yellow.darker().darker().darker());
                }
            } else if (this.isFlagSet("ODD")) {
                if (n % 2 != 0) {
                    this.graphics.setColor(Color.yellow.brighter());
                } else {
                    this.graphics.setColor(Color.yellow.darker().darker().darker());
                }
            } else {
                this.graphics.setColor(Color.yellow);
            }
            for (int i = 1; i < this.oscillator.getNPoints(); ++i) {
                if (this.isThickLine()) {
                    this.graphics.drawLineThick(this.oscillator.x[i - 1], (double)n + 0.5 + this.oscillator.phi[n][i - 1], this.oscillator.x[i], (double)n + 0.5 + this.oscillator.phi[n][i]);
                    continue;
                }
                this.graphics.drawLine(this.oscillator.x[i - 1], (double)n + 0.5 + this.oscillator.phi[n][i - 1], this.oscillator.x[i], (double)n + 0.5 + this.oscillator.phi[n][i]);
            }
        }
        this.graphics.setClipping(false);
        this.graphics.setColor(Color.white);
        double d = Math.sqrt((double)2 * this.oscillator.getMeanEnergy());
        if (this.oscillator.getMeanEnergy() > 0.0) {
            this.graphics.drawHorizontalLineThick(-d, d, this.oscillator.getMeanEnergy(), 3, 7);
        }
        if (this.isFlagSet("AVERAGE_POSITION")) {
            this.graphics.setColor(Color.blue);
            this.graphics.fillDisk(new DoublePoint(this.oscillator.getMeanPosition(), this.oscillator.getPotential(this.oscillator.getMeanPosition())), new Integer(10));
        }
        this.initHotSpots();
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        this.getHotSpotVector().addElement(new HotHLine(this.graphics.xScreen(-this.oscillator.xFromPotential(this.oscillator.getMeanEnergy())), this.graphics.xScreen(this.oscillator.xFromPotential(this.oscillator.getMeanEnergy())), this.graphics.yScreen(this.oscillator.getMeanEnergy())));
    }

    public void hotSpotHasMoved(int n) {
        double d = MathTools.minMax(this.graphics.yUser(this.getCurrentHotSpot().getY()), 0.5, (double)this.oscillator.getNNiveaux() - 0.5);
        this.oscillator.setMeanEnergy(d);
        this.oscillator.computeWeight();
        this.oscillator.computeProba();
        this.oscillator.informObservers();
        this.simulator.informObservers();
    }
}

