/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.control.NavigationPanel;
import phy.function.Factorized2DFunction;
import phy.graphe.QuantumViewer2D;
import phy.quanta.FunctionViewer;
import phy.quanta.HarmonicOscillator1D;
import phy.quanta.ParticleInABox;
import phy.quanta.ParticleInABoxQuantumLimit;
import phy.quanta.QuantaApplet;
import phy.quanta.QuantumState;

public class HarmonicWavePacket2D
extends QuantaApplet
implements ActionListener {
    QuantumState oscillatorX;
    QuantumState oscillatorY;
    QuantumViewer2D viewer2D;
    FunctionViewer viewerX;
    FunctionViewer viewerY;

    public void init() {
        super.init();
        this.initSimulator();
        this.getSimulator().getTimer().addActionListener(this);
        this.getSimulator().setTMax(Double.MAX_VALUE);
        this.getSimulator().pause();
        this.setToolBar(new NavigationPanel());
        this.initPlayButton();
        this.getToolBar().add(this.getPlayButton());
        switch (Integer.valueOf(this.mode)) {
            case 0: {
                this.oscillatorX = new HarmonicOscillator1D();
                this.oscillatorY = new HarmonicOscillator1D();
                this.viewer2D = new QuantumViewer2D(new Factorized2DFunction(this.oscillatorX, this.oscillatorY));
                break;
            }
            case 1: {
                this.oscillatorX = new ParticleInABox();
                this.oscillatorY = new ParticleInABox();
                this.viewer2D = new QuantumViewer2D(new Factorized2DFunction(this.oscillatorX, this.oscillatorY));
                this.viewer2D.getFunction().setMode(2);
                this.viewer2D.setBoundDrawn(true);
                break;
            }
            default: {
                this.oscillatorX = new ParticleInABoxQuantumLimit();
                this.oscillatorY = new ParticleInABoxQuantumLimit();
                this.viewer2D = new QuantumViewer2D(new Factorized2DFunction(this.oscillatorX, this.oscillatorY));
                this.viewer2D.getFunction().setMode(2);
                this.viewer2D.setBoundDrawn(true);
            }
        }
        this.viewer2D.setMouseActive(false);
        this.oscillatorY.setPhaseShift(1.5707963267948966);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 2));
        this.viewerX = new FunctionViewer(this.oscillatorX);
        this.viewerY = new FunctionViewer(this.oscillatorY);
        this.viewerY.setRotated(true);
        this.viewerX.getXScaler().setBounds(-2.0, 2.0);
        this.viewerX.getYScaler().setBounds(2.0, 0.05);
        this.viewerY.getXScaler().setBounds(-2.0, 2.0);
        this.viewerY.getYScaler().setBounds(0.0, 2.0);
        this.viewer2D.getXScaler().setBounds(-2.0, 2.0);
        this.viewer2D.getYScaler().setBounds(-2.0, 2.0);
        panel.add(this.viewerY);
        panel.add(this.viewer2D);
        panel.add(new Panel());
        panel.add(this.viewerX);
        this.setLayout(new BorderLayout());
        this.add("Center", panel);
        this.add("South", this.toolBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME") && this.getSimulator().isRunning()) {
            this.oscillatorX.setTime(this.getSimulator().getTime());
            this.oscillatorY.setTime(this.getSimulator().getTime());
            this.viewer2D.refresh();
            this.viewerX.refresh();
            this.viewerY.refresh();
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

