/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import phy.control.NavigationPanel;
import phy.control.PhySeparator;
import phy.quanta.HermitePolynomials;
import phy.quanta.QuantaApplet;
import phy.quanta.TailorFunctionWindow;
import phy.quanta.WeightTuner;
import phy.util.CrackedString;
import phy.util.PhysicApplet;

public abstract class HermiteDecomposition
extends QuantaApplet
implements ActionListener,
ItemListener {
    Thread runner = null;
    int sleepTime = 50;
    String message = null;
    boolean running = false;
    protected TailorFunctionWindow functionWindow;
    public HermitePolynomials hermitePolynomials = new HermitePolynomials();
    public WeightTuner tuner;
    String mode = "normal";
    protected Checkbox checkboxAuto;
    protected Choice choiceShape;
    protected Choice choiceBasisSize;
    Button buttonGo;
    Button buttonFit;
    Button buttonClear;

    public TailorFunctionWindow getFunctionWindow() {
        return this.functionWindow;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public void setCheckboxAutoState(boolean bl) {
        this.checkboxAuto.setState(bl);
    }

    public Choice getChoiceShape() {
        return this.choiceShape;
    }

    public Choice getChoiceBasisSize() {
        return this.choiceBasisSize;
    }

    void getParameters() {
        this.mode = this.getParameter("mode", this.mode);
    }

    public void init() {
        super.init();
        this.setBackground(Color.black);
        this.getParameters();
        this.setToolBar(new NavigationPanel());
        this.getToolBar().add(new Label(PhysicApplet.getWord("BasisSize"), 2));
        this.choiceBasisSize = new Choice();
        this.getToolBar().add(this.choiceBasisSize);
        for (int i = 1; i <= 10; ++i) {
            this.choiceBasisSize.add(String.valueOf("").concat(String.valueOf(i)));
        }
        this.choiceBasisSize.add("20");
        this.choiceBasisSize.add("30");
        this.choiceBasisSize.add("40");
        this.choiceBasisSize.add("50");
        this.choiceBasisSize.add("100");
        this.choiceBasisSize.add("200");
        this.choiceBasisSize.addItemListener(this);
        this.getToolBar().add(new PhySeparator());
        this.buttonClear = new Button(PhysicApplet.getWord("Clear"));
        this.getToolBar().add(this.buttonClear);
        this.buttonClear.addActionListener(this);
        this.getToolBar().add(new PhySeparator());
        if (this.mode.equals("fit")) {
            this.getToolBar().add(new Label(PhysicApplet.getWord("Shape"), 2));
            this.choiceShape = new Choice();
            this.getToolBar().add(this.choiceShape);
            this.getToolBar().add(new PhySeparator());
            this.choiceShape.add("Rectangle");
            this.choiceShape.add("Triangle");
            this.choiceShape.add(PhysicApplet.getWord("Gaussian"));
            this.choiceShape.select(1);
            this.choiceShape.addItemListener(this);
            this.checkboxAuto = new Checkbox("Auto");
            this.getToolBar().add(this.checkboxAuto);
            this.checkboxAuto.setState(true);
            this.checkboxAuto.addItemListener(this);
            this.getToolBar().add(new PhySeparator());
            this.buttonFit = new Button(PhysicApplet.getWord("Adjust"));
            this.getToolBar().add(this.buttonFit);
            this.buttonFit.addActionListener(this);
        }
        this.functionWindow = new TailorFunctionWindow(this, this.mode);
        this.functionWindow.setName("Function");
        this.tuner = new WeightTuner(this);
        this.tuner.setName("Tuner");
        this.tuner.setMouseActive(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonGo) {
            this.functionWindow.computeHermiteSum(this.tuner, this.hermitePolynomials);
            this.functionWindow.refresh();
        } else if (actionEvent.getSource() == this.buttonFit) {
            this.doFit();
        } else if (actionEvent.getSource() == this.buttonClear || actionEvent.getActionCommand().equals("CANCEL")) {
            this.doClear();
        } else if (actionEvent.getActionCommand().startsWith("SHAPE ")) {
            this.choiceShape.select(CrackedString.getInt(actionEvent.getActionCommand(), 1));
            this.updateShape();
        } else if (actionEvent.getActionCommand().startsWith("SHOW_SHAPE ")) {
            if (CrackedString.getField(actionEvent.getActionCommand(), 1).equals("ON")) {
                this.choiceShape.setBackground(Color.yellow);
            } else {
                this.choiceShape.setBackground(Color.white);
            }
        } else if (actionEvent.getActionCommand().startsWith("BASIS ")) {
            this.choiceBasisSize.select(CrackedString.getField(actionEvent.getActionCommand(), 1));
            this.updateBasisSize();
        } else if (actionEvent.getActionCommand().startsWith("SHOW_BASIS ")) {
            if (CrackedString.getField(actionEvent.getActionCommand(), 1).equals("ON")) {
                this.choiceBasisSize.setBackground(Color.yellow);
            } else {
                this.choiceBasisSize.setBackground(Color.white);
            }
        } else if (actionEvent.getActionCommand().startsWith("SHOW_FIT ")) {
            if (CrackedString.getField(actionEvent.getActionCommand(), 1).equals("ON")) {
                this.functionWindow.setColor1(Color.blue);
                this.functionWindow.repaint();
            } else {
                this.functionWindow.setColor1(null);
                this.functionWindow.repaint();
            }
        } else if (actionEvent.getActionCommand().startsWith("COEFF ")) {
            CrackedString crackedString = new CrackedString(actionEvent.getActionCommand());
            int n = crackedString.getInt(1);
            double d = crackedString.getDouble(2);
            this.tuner.setWeight(n, d);
            this.functionWindow.computeHermiteSum(this.tuner, this.hermitePolynomials);
            this.tuner.repaint();
            this.functionWindow.refresh();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void doFit() {
        for (int i = 0; i < this.tuner.getNPoints(); ++i) {
            this.tuner.setWeight(i, this.hermitePolynomials.scalarProduct(i, this.functionWindow.dataSet.zData[1]));
        }
        this.tuner.repaint();
        this.functionWindow.computeHermiteSum(this.tuner, this.hermitePolynomials);
        this.functionWindow.refresh();
    }

    void doClear() {
        for (int i = 0; i < this.tuner.getNPoints(); ++i) {
            this.tuner.setWeight(i, 0.0);
        }
        this.tuner.repaint();
        this.functionWindow.computeHermiteSum(this.tuner, this.hermitePolynomials);
        this.functionWindow.refresh();
    }

    void doFitIfNeeded() {
        if (this.checkboxAuto == null) {
            this.repaint();
        } else if (this.checkboxAuto.getState()) {
            this.doFit();
        }
    }

    protected void updateShape() {
        this.functionWindow.setFunctionType(this.choiceShape.getSelectedIndex());
        this.functionWindow.computeDataSet();
        this.functionWindow.refresh();
        this.doFitIfNeeded();
    }

    protected void updateBasisSize() {
        this.tuner.setNPoints(Integer.valueOf(this.choiceBasisSize.getSelectedItem()));
        this.doFitIfNeeded();
        this.tuner.repaint();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choiceShape) {
            this.updateShape();
        } else if (itemEvent.getSource() == this.choiceBasisSize) {
            this.updateBasisSize();
        } else if (itemEvent.getSource() == this.checkboxAuto) {
            this.doFitIfNeeded();
        }
    }
}

