/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

class HermitePolynomials {
    int nCurves;
    int nPoints;
    int maxNPoints = 300;
    int maxNCurves = 20;
    int nCalculated = 0;
    double[][] phi;
    double[] x;
    double x1 = -10.0;
    double x2 = 10.0;
    double deltaX = 1.0;

    HermitePolynomials() {
        this.setSize(200, 200);
    }

    void setSize(int n, int n2) {
        if (n2 == this.nPoints) {
            if (n > this.maxNCurves) {
                this.maxNCurves = n;
                double[][] dArray = new double[this.maxNCurves][this.maxNPoints];
                for (int i = 0; i < this.nCalculated; ++i) {
                    System.arraycopy(this.phi[i], 0, dArray[i], 0, n2);
                }
                this.phi = dArray;
                this.nCurves = n;
            } else {
                this.nCurves = n;
            }
        } else {
            this.nCalculated = 0;
            if (n2 > this.maxNPoints || n > this.maxNCurves) {
                if (n2 > this.maxNPoints) {
                    this.maxNPoints = n2;
                }
                if (n > this.maxNCurves) {
                    this.maxNCurves = n;
                }
                this.phi = new double[this.maxNCurves][this.maxNPoints];
                this.x = new double[this.maxNPoints];
            }
        }
        this.nCurves = n;
        this.nPoints = n2;
        this.computePolynomials();
    }

    void computePolynomials() {
        if (this.nCurves > this.nCalculated) {
            int n;
            if (this.nCalculated <= 2) {
                this.deltaX = (this.x2 - this.x1) / (double)(this.nPoints - 1);
                for (n = 0; n < this.nPoints; ++n) {
                    this.x[n] = this.x1 + (double)n * this.deltaX;
                    this.phi[0][n] = 1.0;
                    this.phi[1][n] = (double)2 * this.x[n];
                }
            }
            for (n = 0; n < this.nPoints; ++n) {
                for (int i = Math.max(2, this.nCalculated); i < this.nCurves; ++i) {
                    this.phi[i][n] = (double)2 * this.x[n] * this.phi[i - 1][n] - (double)(2 * (i - 1)) * this.phi[i - 2][n];
                }
            }
            double d = Math.sqrt(Math.PI);
            for (int i = 0; i < this.nCurves; ++i) {
                if (i > 0) {
                    d *= (double)(2 * i);
                }
                if (i < this.nCalculated) continue;
                for (int j = 0; j < this.nPoints; ++j) {
                    double[] dArray = this.phi[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] * (Math.exp(-this.x[j] * this.x[j] / (double)2) / Math.sqrt(d));
                }
            }
            this.nCalculated = this.nCurves;
        }
    }

    double scalarProduct(int n, double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.nPoints; ++i) {
            d += dArray[i] * this.phi[n][i];
        }
        return d * this.deltaX;
    }
}

