/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import phy.graphe.BufferedPanel;
import phy.quanta.ControlPanel;
import phy.quanta.EchoControlPanel;
import phy.quanta.Larmor;
import phy.quanta.SpinControlPanel;
import phy.util.MathTools;

public class LarmorWindow
extends BufferedPanel {
    int mode;
    int xpos;
    int xold;
    float theta;
    float phi;
    float theta0;
    float phi0;
    float phiAnchor;
    float thetaAnchor;
    float psi;
    float psi0;
    float cospsi;
    float sinpsi;
    float xsi;
    float xsi0;
    float cosxsi;
    float sinxsi;
    int x0;
    int y0;
    int r;
    float[][] tip;
    int iTip = 0;
    int maxPoints = 200;
    int nPoints = 0;
    float dt = 0.033333335f;
    float w0 = (float)Math.PI * 2;
    float w1 = this.w0 / (float)20;
    float w = this.w0;
    float thetaB1 = 0.0f;
    float phiB1 = 0.0f;
    float thetaB10;
    float phiB10;
    float rabi;
    float bpr;
    float bpi;
    float bmr;
    float bmi;
    float t = 0.0f;
    float tAbs = 0.0f;
    float debug = 0.0f;
    Larmor parent;
    float[] Theta;
    float[] Phi;
    float[] Theta0;
    float[] Phi0;
    int NI = 10;
    int echoMode = 0;
    double norme = 1.0;

    LarmorWindow(Larmor larmor, int n) {
        this.setMouseActive(true);
        this.mode = n;
        this.parent = larmor;
        this.theta = 0.62831855f;
        this.theta0 = 0.62831855f;
        this.phi = 0.0f;
        this.phi0 = 0.0f;
        this.Theta = new float[this.NI];
        this.Phi = new float[this.NI];
        this.Theta0 = new float[this.NI];
        this.Phi0 = new float[this.NI];
        this.xsi = 0.7853982f;
        this.psi = 0.2f;
        this.UpdateSin();
        this.tip = new float[3][this.maxPoints];
        this.setFlag("FIELD");
    }

    public void init() {
        this.Reset();
        switch (this.mode) {
            case 0: {
                this.ShowSpinCoordinates();
                break;
            }
            case 2: {
                this.ShowRMNParameters();
            }
        }
    }

    public int getR() {
        return this.getHeight() / 4;
    }

    void UpdateSin() {
        this.sinpsi = (float)Math.sin((double)this.psi * Math.PI);
        this.cospsi = (float)Math.cos((double)this.psi * 3.14);
        this.sinxsi = (float)Math.sin(this.xsi);
        this.cosxsi = (float)Math.cos(this.xsi);
    }

    public boolean isShiftDown() {
        return this.isShiftDown() && this.mode == 1;
    }

    public void mousePressed() {
        super.mousePressed();
        this.psi0 = this.psi;
        this.xsi0 = this.xsi;
        this.thetaAnchor = this.theta;
        this.phiAnchor = this.phi;
        this.thetaB10 = this.thetaB1;
        this.phiB10 = this.phiB1;
    }

    public void mouseDragged() {
        super.mouseDragged();
        if (this.isControlDown()) {
            this.theta = (float)((double)this.thetaAnchor + (double)(this.getYMouse() - this.getYMousePressed()) / 100.0 * 3.14159);
            if (this.theta < 0.0f) {
                this.theta = 0.0f;
            } else if ((double)this.theta > 3.14159) {
                this.theta = 3.14159f;
            }
            if (this.parent != null && !this.parent.getSimulator().isRunning()) {
                this.phi = (float)((double)this.phiAnchor + (double)(this.getXMouse() - this.getXMousePressed()) / 100.0 * Math.PI);
            }
            this.SetTimeZero();
            this.InitTip();
            if (this.mode == 0) {
                this.ShowSpinCoordinates();
            }
        } else if (this.shiftDown) {
            this.thetaB1 = (float)((double)this.thetaB10 + (double)(this.getYMouse() - this.getYMousePressed()) / 100.0);
            this.phiB1 = (float)((double)this.phiB10 + (double)(this.getXMouse() - this.getXMousePressed()) / 100.0);
            if (this.thetaB1 < 0.0f) {
                this.thetaB1 = 0.0f;
            } else if ((double)this.thetaB1 > Math.PI) {
                this.thetaB1 = (float)Math.PI;
            }
            this.initB1();
        } else {
            this.psi = (float)((double)this.psi0 + (double)(this.getYMouse() - this.getYMousePressed()) / 100.0);
            if (this.psi < 0.0f) {
                this.psi = 0.0f;
            } else if ((double)this.psi > 0.5) {
                this.psi = 0.5f;
            }
            this.xsi = (float)((double)this.xsi0 + (double)(this.getXMouse() - this.getXMousePressed()) / 100.0);
            this.UpdateSin();
        }
        this.repaint();
    }

    protected void initB1() {
        this.w0 = (float)(Math.PI * 2 * Math.cos(this.thetaB1));
        this.w1 = (float)(Math.PI * 2 * Math.sin(this.thetaB1));
        this.SetTimeZero();
        this.InitTip();
    }

    void InitTip() {
        this.nPoints = 1;
        this.tip[0][0] = (float)(Math.cos(this.phi) * Math.sin(this.theta));
        this.tip[1][0] = (float)(Math.sin(this.phi) * Math.sin(this.theta));
        this.tip[2][0] = (float)Math.cos(this.theta);
        this.iTip = 1;
    }

    float sqr(float f) {
        return f * f;
    }

    void SetTimeZero() {
        this.t = 0.0f;
        if (this.mode >= 3) {
            for (int i = 0; i < this.NI; ++i) {
                this.Phi0[i] = this.Phi[i] - this.w * this.tAbs;
                this.Theta0[i] = this.Theta[i];
            }
        } else {
            this.phi0 = this.phi - this.w * this.tAbs;
            this.theta0 = this.theta;
        }
    }

    void Reset() {
        this.tAbs = 0.0f;
        switch (this.mode) {
            case 0: {
                this.w = 0.0f;
                this.w1 = 0.0f;
                break;
            }
            case 1: {
                this.w0 = (float)(Math.PI * 2 * Math.cos(this.thetaB1));
                this.w1 = (float)(Math.PI * 2 * Math.sin(this.thetaB1));
                this.InitTip();
                this.w = 0.0f;
                this.w1 = 0.0f;
                break;
            }
            case 2: {
                this.theta = (float)Math.PI;
                this.theta0 = (float)Math.PI;
                break;
            }
            case 3: 
            case 4: {
                this.theta = (float)Math.PI;
                this.theta0 = (float)Math.PI;
                for (int i = 0; i < this.NI; ++i) {
                    this.Theta[i] = this.Theta0[i] = this.theta0;
                    this.Phi0[i] = 0.0f;
                    this.Phi[i] = 0.0f;
                }
                break;
            }
        }
        this.SetTimeZero();
    }

    void Compute(float f, int n) {
        if (this.w1 != 0.0f) {
            float f2 = (float)Math.sqrt(this.sqr(f - this.w) + this.sqr(this.w1));
            float f3 = (float)Math.cos(f2 * this.t / (float)2);
            float f4 = (float)Math.sin(f2 * this.t / (float)2);
            int n2 = n;
            this.Phi0[n2] = this.Phi0[n2] - this.phiB1;
            float f5 = (float)(Math.cos(this.Theta0[n] / (float)2) * Math.cos(this.Phi0[n] / (float)2));
            float f6 = (float)(-Math.cos(this.Theta0[n] / (float)2) * Math.sin(this.Phi0[n] / (float)2));
            float f7 = (float)(Math.sin(this.Theta0[n] / (float)2) * Math.cos(this.Phi0[n] / (float)2));
            float f8 = (float)(Math.sin(this.Theta0[n] / (float)2) * Math.sin(this.Phi0[n] / (float)2));
            int n3 = n;
            this.Phi0[n3] = this.Phi0[n3] + this.phiB1;
            float f9 = f5 * f3 + (f6 * (f - this.w) + f8 * this.w1) / f2 * f4;
            float f10 = f6 * f3 - (f5 * (f - this.w) + f7 * this.w1) / f2 * f4;
            float f11 = f7 * f3 + (-f8 * (f - this.w) + f6 * this.w1) / f2 * f4;
            float f12 = f8 * f3 - (-f7 * (f - this.w) + f5 * this.w1) / f2 * f4;
            float f13 = f9 * f11 + f10 * f12;
            float f14 = f9 * f12 - f10 * f11;
            this.Phi[n] = (double)(this.sqr(f13) + this.sqr(f14)) > 1.0E-6 ? (float)Math.atan2(f14, f13) : 0.0f;
            this.Theta[n] = (float)2 * (float)Math.atan2(Math.sqrt(this.sqr(f11) + this.sqr(f12)), Math.sqrt(this.sqr(f9) + this.sqr(f10)));
            int n4 = n;
            this.Phi[n4] = this.Phi[n4] + (this.w * this.tAbs + this.phiB1);
        } else {
            this.Phi[n] = this.Phi0[n] + this.w * (this.tAbs - this.t) + f * this.t;
            this.Theta[n] = this.Theta0[n];
        }
    }

    void Run() {
        if (this.mode >= 3) {
            EchoControlPanel echoControlPanel = (EchoControlPanel)this.parent.getControlPanel();
            switch (this.echoMode) {
                case 0: {
                    this.w1 = this.w0 / (float)2;
                    echoControlPanel.label.setText("Impulsion pi/2");
                    ++this.echoMode;
                    break;
                }
                case 1: {
                    if (!((double)(this.w1 * this.tAbs) > 1.5707963267948966)) break;
                    echoControlPanel.label.setText("D\u00e9croissance de l'aimantation");
                    this.w1 = 0.0f;
                    this.SetTimeZero();
                    ++this.echoMode;
                    break;
                }
                case 2: {
                    if (this.mode == 3) {
                        if (!((double)(this.w0 * this.tAbs) > 26.703537555513243)) break;
                        this.w1 = this.w0 / (float)2;
                        this.SetTimeZero();
                        echoControlPanel.label.setText("Impulsion pi");
                        ++this.echoMode;
                        break;
                    }
                    if (!((double)(this.w0 * this.tAbs) > 37.69911184307752)) break;
                    this.echoMode = 0;
                    this.Reset();
                    this.parent.setRunning(false);
                    this.parent.stop();
                    echoControlPanel.UpdateStartStopButton();
                    echoControlPanel.repaint();
                    break;
                }
                case 3: {
                    if (!((double)(this.w1 * this.t) > Math.PI)) break;
                    this.w1 = 0.0f;
                    this.SetTimeZero();
                    echoControlPanel.label.setText("");
                    ++this.echoMode;
                    break;
                }
                case 4: {
                    if (!((double)(this.w0 * this.tAbs) > 56.548667764616276)) break;
                    echoControlPanel.label.setText("Echo");
                    ++this.echoMode;
                    break;
                }
                case 5: {
                    if (!((double)(this.w0 * this.tAbs) > 59.690260418206066)) break;
                    echoControlPanel.label.setText("D\u00e9croissance de l'aimantation");
                    ++this.echoMode;
                    break;
                }
                case 6: {
                    if (!((double)(this.w0 * this.tAbs) > 94.24777960769379)) break;
                    echoControlPanel.label.setText("");
                    this.echoMode = 0;
                    this.Reset();
                    this.repaint();
                    if (this.parent.autoMode == 0) {
                        this.parent.setRunning(false);
                        this.parent.stop();
                    }
                    echoControlPanel.UpdateStartStopButton();
                    echoControlPanel.repaint();
                    return;
                }
            }
        }
        if (this.mode == 4) {
            this.tAbs += this.dt / (float)3;
            this.t += this.dt / (float)3;
        } else {
            this.tAbs += this.dt;
            this.t += this.dt;
        }
        this.phi = this.phi0;
        if (this.mode >= 3) {
            for (int i = 0; i < this.NI; ++i) {
                this.Compute(this.w0 * (1.0f + (float)(i - this.NI / 2) / 53.1548f), i);
            }
        } else {
            this.Phi0[0] = this.phi0;
            this.Theta0[0] = this.theta0;
            this.Compute(this.w0, 0);
            this.phi = this.Phi[0];
            this.theta = this.Theta[0];
            this.tip[0][this.iTip] = (float)(Math.cos(this.phi) * Math.sin(this.theta));
            this.tip[1][this.iTip] = (float)(Math.sin(this.phi) * Math.sin(this.theta));
            this.tip[2][this.iTip] = (float)Math.cos(this.theta);
            if (this.nPoints < this.maxPoints) {
                ++this.nPoints;
            }
            if (this.iTip < this.nPoints - 1) {
                ++this.iTip;
            } else {
                this.tip[0][0] = this.tip[0][this.nPoints - 1];
                this.tip[1][0] = this.tip[1][this.nPoints - 1];
                this.tip[2][0] = this.tip[2][this.nPoints - 1];
                this.iTip = 1;
            }
        }
    }

    Point P2D(float f, float f2, float f3) {
        return new Point((int)((float)this.getR() * (-f * this.cosxsi + f2 * this.sinxsi)) + this.getXCenter(), -((int)((float)this.getR() * ((-f * this.sinxsi - f2 * this.cosxsi) * this.sinpsi + f3 * this.cospsi))) + this.getYCenter());
    }

    void DrawTipLoop(Graphics graphics) {
        if (this.nPoints > 1) {
            Point point = this.P2D(this.tip[0][0], this.tip[1][0], this.tip[2][0]);
            for (int i = 1; i < this.nPoints; ++i) {
                Point point2 = this.P2D(this.tip[0][i], this.tip[1][i], this.tip[2][i]);
                if (i != this.iTip) {
                    this.graphics.getGraphics().drawLine(point.x, point.y, point2.x, point2.y);
                }
                point = point2;
            }
        }
    }

    void DrawArrow(Graphics graphics, Point point, Point point2) {
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        float f = point2.x - point.x;
        float f2 = point2.y - point.y;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if (f3 > (float)10) {
            Point point3 = new Point(point2.x, point2.y);
            Point point4 = new Point(point2.x, point2.y);
            int n = 15;
            if (this.getSize().width < 250) {
                n = 10;
            }
            float f4 = (float)Math.cos(0.39269908169872414);
            float f5 = (float)Math.sin(0.39269908169872414);
            point3.x = (int)((float)point3.x + (float)n * (-f4 * f + f5 * f2) / f3);
            point3.y = (int)((float)point3.y + (float)n * (-f5 * f - f4 * f2) / f3);
            point4.x = (int)((float)point4.x + (float)n * (-f4 * f - f5 * f2) / f3);
            point4.y = (int)((float)point4.y + (float)n * (f5 * f - f4 * f2) / f3);
            int[] nArray = new int[]{point2.x, point3.x, point4.x};
            int[] nArray2 = new int[]{point2.y, point3.y, point4.y};
            graphics.fillPolygon(nArray, nArray2, 3);
        }
    }

    public void paintCore() {
        Point point;
        Point point2;
        this.graphics.setFont(new Font("Times", 0, 18));
        this.graphics.setColor(this.getForeground());
        this.graphics.getGraphics().drawOval(this.getXCenter() - this.getR(), this.getYCenter() - this.getR(), 2 * this.getR(), 2 * this.getR());
        this.graphics.getGraphics().drawOval(this.getXCenter() - this.getR(), this.getYCenter() - (int)((float)this.getR() * this.sinpsi), 2 * this.getR(), (int)((float)(2 * this.getR()) * this.sinpsi));
        Point point3 = new Point(this.getXCenter(), this.getYCenter());
        this.graphics.setColor(Color.green);
        if (this.mode == 1 && this.isFlagSet("FIELD")) {
            point2 = this.P2D((float)((double)2 * Math.sin(this.thetaB1) * Math.cos(this.phiB1)), (float)((double)2 * Math.sin(this.thetaB1) * Math.sin(this.phiB1)), (float)((double)2 * Math.cos(this.thetaB1)));
            this.graphics.drawArrowThick(point3, point2);
            if (this.shiftDown) {
                point = this.P2D((float)((double)2 * Math.sin(this.thetaB1) * Math.cos(this.phiB1)), (float)((double)2 * Math.sin(this.thetaB1) * Math.sin(this.phiB1)), 0.0f);
                this.graphics.getGraphics().drawLine(point3.x, point3.y, point.x, point.y);
                this.graphics.getGraphics().drawLine(point.x, point.y, point2.x, point2.y);
            }
        } else if (this.mode == 2) {
            point2 = this.P2D(0.0f, 0.0f, 2.0f);
            this.DrawArrow(this.graphics.getGraphics(), point3, point2);
            this.graphics.getGraphics().drawString("Bo (/5)", point2.x + 8, point2.y + 8);
            point2 = this.P2D((float)Math.cos(this.w * this.tAbs) * this.w1 / this.w0 * (float)2 * (float)5, (float)Math.sin(this.w * this.tAbs) * this.w1 / this.w0 * (float)2 * (float)5, 0.0f);
            this.DrawArrow(this.graphics.getGraphics(), point3, point2);
        } else if (this.mode >= 3) {
            point2 = this.P2D(0.0f, 0.0f, 2.0f);
            this.DrawArrow(this.graphics.getGraphics(), point3, point2);
            this.graphics.getGraphics().drawString("Bo", point2.x + 8, point2.y + 8);
            point2 = this.P2D((float)Math.cos(this.w * this.tAbs) * this.w1 / this.w0 * (float)2, (float)Math.sin(this.w * this.tAbs) * this.w1 / this.w0 * (float)2, 0.0f);
            this.DrawArrow(this.graphics.getGraphics(), point3, point2);
        }
        point2 = this.P2D(0.0f, 0.0f, 1.0f);
        point = this.P2D(0.0f, 0.0f, 1.7f);
        this.graphics.setColor(Color.blue);
        this.graphics.getGraphics().drawLine(point3.x, point3.y, point2.x, point2.y);
        this.graphics.setColor(this.getForeground());
        this.DrawArrow(this.graphics.getGraphics(), point2, point);
        this.graphics.getGraphics().drawString("z", point.x + 7, point.y + 7);
        point2 = this.P2D(1.0f, 0.0f, 0.0f);
        point = this.P2D(2.0f, 0.0f, 0.0f);
        this.graphics.setColor(Color.blue);
        this.graphics.getGraphics().drawLine(point3.x, point3.y, point2.x, point2.y);
        this.graphics.setColor(this.getForeground());
        this.DrawArrow(this.graphics.getGraphics(), point2, point);
        this.graphics.getGraphics().drawString("x", point.x - 10, point.y + 7);
        point2 = this.P2D(0.0f, 1.0f, 0.0f);
        point = this.P2D(0.0f, 2.0f, 0.0f);
        this.graphics.setColor(Color.blue);
        this.graphics.getGraphics().drawLine(point3.x, point3.y, point2.x, point2.y);
        this.graphics.setColor(this.getForeground());
        this.DrawArrow(this.graphics.getGraphics(), point2, point);
        this.graphics.getGraphics().drawString("y", point.x + 7, point.y + 7);
        if (this.mode >= 3) {
            this.graphics.setColor(Color.blue);
            for (int i = 0; i < this.NI; ++i) {
                if (i > this.NI / 2) {
                    this.graphics.setColor(Color.red);
                }
                float f = (float)(Math.cos(this.Phi[i]) * Math.sin(this.Theta[i]) * this.norme);
                float f2 = (float)(Math.sin(this.Phi[i]) * Math.sin(this.Theta[i]) * this.norme);
                float f3 = (float)(Math.cos(this.Theta[i]) * this.norme);
                point2 = this.P2D(f, f2, f3);
                this.DrawArrow(this.graphics.getGraphics(), point3, point2);
            }
        } else {
            this.graphics.setColor(Color.yellow);
            float f = (float)(Math.cos(this.phi) * Math.sin(this.theta) * this.norme);
            float f4 = (float)(Math.sin(this.phi) * Math.sin(this.theta) * this.norme);
            float f5 = (float)(Math.cos(this.theta) * this.norme);
            this.DrawArrow(this.graphics.getGraphics(), point3, this.P2D(f, f4, f5));
            this.DrawTipLoop(this.graphics.getGraphics());
        }
        this.graphics.setFont(this.getDefaultFont());
    }

    void ShowRMNParameters() {
        ControlPanel controlPanel = (ControlPanel)this.parent.getControlPanel();
        if (this.parent != null && this.parent.controlPanel != null) {
            controlPanel.param1.setText(String.valueOf(this.w1 / this.w0));
            controlPanel.param2.setText(String.valueOf(this.w / this.w0));
        }
    }

    void UpdateB1(ControlPanel controlPanel) {
        float f = (float)Float.valueOf(controlPanel.param1.getText()).doubleValue();
        float f2 = (float)Float.valueOf(controlPanel.param2.getText()).doubleValue();
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > (float)2 * this.w0) {
            f2 = (float)2 * this.w0;
        }
        this.w1 = this.w0 * f;
        this.w = this.w0 * f2;
        this.ShowRMNParameters();
        this.SetTimeZero();
        this.InitTip();
    }

    String PsiString() {
        String string = "(";
        double d = Math.cos(this.theta / (float)2) * Math.cos(this.phi / (float)2);
        double d2 = -Math.cos(this.theta / (float)2) * Math.sin(this.phi / (float)2);
        double d3 = Math.sin(this.theta / (float)2) * Math.cos(this.phi / (float)2);
        double d4 = Math.sin(this.theta / (float)2) * Math.sin(this.phi / (float)2);
        string = d > 0.0 ? String.valueOf(string).concat(String.valueOf("+ ")) : String.valueOf(string).concat(String.valueOf("-  "));
        string = String.valueOf(string).concat(String.valueOf(MathTools.formatte(Math.abs(d), 3)));
        string = d2 > 0.0 ? String.valueOf(string).concat(String.valueOf(" + ")) : String.valueOf(string).concat(String.valueOf(" -  "));
        string = String.valueOf(string).concat(String.valueOf(MathTools.formatte(Math.abs(d2), 3)));
        string = String.valueOf(string).concat(String.valueOf(" i) |+> + ("));
        string = d3 > 0.0 ? String.valueOf(string).concat(String.valueOf("+ ")) : String.valueOf(string).concat(String.valueOf("-  "));
        string = String.valueOf(string).concat(String.valueOf(MathTools.formatte(Math.abs(d3), 3)));
        string = d4 > 0.0 ? String.valueOf(string).concat(String.valueOf(" + ")) : String.valueOf(string).concat(String.valueOf(" -  "));
        string = String.valueOf(string).concat(String.valueOf(MathTools.formatte(Math.abs(d4), 3)));
        string = String.valueOf(string).concat(String.valueOf(" i) |->                    "));
        return string;
    }

    void ShowSpinCoordinates() {
        if (this.parent != null && this.parent.getControlPanel() instanceof SpinControlPanel) {
            SpinControlPanel spinControlPanel = (SpinControlPanel)this.parent.getControlPanel();
            spinControlPanel.label.setText(this.PsiString());
            spinControlPanel.param1.setText(String.valueOf(Math.round((double)this.theta / Math.PI * (double)180)));
            spinControlPanel.param2.setText(String.valueOf(Math.round((double)this.phi / Math.PI * (double)180)));
        }
    }

    void UpdateSpin(SpinControlPanel spinControlPanel) {
        this.theta = (float)(Math.PI * Float.valueOf(spinControlPanel.param1.getText()).doubleValue() / (double)180);
        this.phi = (float)(Math.PI * Float.valueOf(spinControlPanel.param2.getText()).doubleValue() / (double)180);
        this.repaint();
        this.ShowSpinCoordinates();
    }

    public void setState(double d, double d2, double d3, double d4) {
        this.norme = Math.sqrt(MathTools.sqr(d) + MathTools.sqr(d2) + MathTools.sqr(d3) + MathTools.sqr(d4));
        this.phi = (float)Math.atan2(d * d4 - d3 * d2, d * d3 + d2 * d4);
        double d5 = d * Math.cos(this.phi / (float)2) - d2 * Math.sin(this.phi / (float)2);
        double d6 = d * Math.sin(this.phi / (float)2) + d2 * Math.cos(this.phi / (float)2);
        double d7 = d3 * Math.cos(this.phi / (float)2) - d4 * Math.sin(-this.phi / (float)2);
        double d8 = d3 * Math.sin(-this.phi / (float)2) + d4 * Math.cos(this.phi / (float)2);
        this.theta = MathTools.sqr(d5) + MathTools.sqr(d7) > MathTools.sqr(d6) + MathTools.sqr(d8) ? (float)((double)2 * Math.atan2(d7, d5)) : (float)((double)2 * Math.atan2(d8, d6));
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("MSG_ALPHA")) {
            this.theta = 0.62831855f;
            this.thetaB1 = 0.0f;
            this.phiB1 = 0.0f;
            this.initB1();
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

