/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.InputStream;
import phy.control.NavigationPanel;
import phy.control.PhySeparator;
import phy.dynaplot.PlotDataSet;
import phy.quanta.MarcheWindow;
import phy.quanta.QuantaApplet;
import phy.util.CrackedString;
import phy.util.FileToolkit;
import phy.util.PhysicApplet;

public class Marche
extends QuantaApplet
implements ActionListener,
ItemListener {
    String message = null;
    boolean firstTime = true;
    boolean showStep;
    Label label;
    MarcheWindow plotWindow;
    Choice choicePot;
    Choice choiceStepHeight;
    Choice choiceBarWidth;
    boolean realTime = true;
    int sleepTime = 100;
    double step = 1.0;
    PlotDataSet[] dataMarche = new PlotDataSet[]{null, null, null, null, null, null};
    PlotDataSet dataSet = null;
    String fileName;
    protected boolean immediateLoad = false;
    protected int currentDataSet = 3;
    int counter = 0;

    public void setImmediateLoad(boolean bl) {
        this.immediateLoad = bl;
    }

    public boolean isImmediateLoad() {
        return this.immediateLoad;
    }

    public void setCurrentDataSet(int n) {
        this.currentDataSet = n;
    }

    public int getCurrentDataSet() {
        return this.currentDataSet;
    }

    void getParameters() {
        this.fileName = "marche1.adf";
        this.realTime = this.getParameter("realTime", true);
        this.sleepTime = this.getParameter("speed", this.sleepTime);
        this.step = this.getParameter("step", this.step);
    }

    public void init() {
        super.init();
        this.getParameters();
        this.initSimulator();
        this.getSimulator().setTMax(Double.MAX_VALUE);
        this.getSimulator().getTimer().addActionListener(this);
        this.getSimulator().pause();
        this.setLayout(new BorderLayout());
        this.choicePot = new Choice();
        this.choicePot.addItem(PhysicApplet.getWord("Step"));
        this.choicePot.addItem(PhysicApplet.getWord("Barrier"));
        this.choicePot.addItemListener(this);
        this.choiceStepHeight = new Choice();
        this.choiceStepHeight.addItem("150");
        this.choiceStepHeight.addItem("175");
        this.choiceStepHeight.addItem("200");
        this.choiceStepHeight.addItem("225");
        this.choiceStepHeight.select("225");
        this.choiceStepHeight.addItemListener(this);
        this.choiceBarWidth = new Choice();
        this.choiceBarWidth.addItem("5");
        this.choiceBarWidth.addItem("10");
        this.choiceBarWidth.select("10");
        this.choiceBarWidth.addItemListener(this);
        this.initPlayButton();
        this.setToolBar(new NavigationPanel());
        this.getToolBar().add(this.getPlayButton());
        this.getToolBar().add(new PhySeparator());
        this.getToolBar().add(new Label(PhysicApplet.getWord("Potential"), 2));
        this.getToolBar().add(this.choicePot);
        this.getToolBar().add(new PhySeparator());
        this.label = new Label(String.valueOf(PhysicApplet.getWord("Height")).concat(String.valueOf(" [meV]")), 2);
        this.getToolBar().add(this.label);
        this.getToolBar().add(this.choiceStepHeight);
        this.getToolBar().add(new PhySeparator());
        this.showStep = true;
        this.plotWindow = new MarcheWindow();
        this.plotWindow.xLabel = String.valueOf(PhysicApplet.getWord("Position")).concat(String.valueOf(" [nm]"));
        this.plotWindow.yLabel = PhysicApplet.getWord("ProbaPre");
        this.plotWindow.title = PhysicApplet.getWord("PropaWP");
        this.add("South", this.getToolBar());
        this.add("Center", this.plotWindow);
        this.plotWindow.realTime = this.realTime;
        this.plotWindow.step = this.step;
        this.plotWindow.sleepTime = this.sleepTime;
        this.plotWindow.setStyle(1);
        this.plotWindow.endTime = 1000;
    }

    public void start() {
        if (this.firstTime) {
            this.firstTime = false;
            this.setDataSet(3);
        }
        super.start();
    }

    public void setDataSetCore(int n) {
        if (this.dataMarche[n] == null) {
            if (n < 4) {
                this.LoadDataSet(String.valueOf(String.valueOf("marche").concat(String.valueOf(n + 1))).concat(String.valueOf(".adf")));
            } else {
                this.LoadDataSet(String.valueOf(String.valueOf("bar").concat(String.valueOf(6 - n))).concat(String.valueOf(".adf")));
            }
            this.dataMarche[n] = this.dataSet;
        }
    }

    public void setDataSet(int n) {
        this.setDataSetCore(n);
        this.dataSet = this.dataMarche[n];
        this.setCurrentDataSet(n);
        switch (n) {
            case 0: {
                this.plotWindow.param = 150.0;
                break;
            }
            case 1: {
                this.plotWindow.param = 175.0;
                break;
            }
            case 2: {
                this.plotWindow.param = 200.0;
                break;
            }
            case 3: {
                this.plotWindow.param = 225.0;
                break;
            }
            case 4: {
                this.plotWindow.param = -5.0;
                break;
            }
            case 5: {
                this.plotWindow.param = -10.0;
            }
        }
        this.plotWindow.setDataSet(this.dataSet);
        if (this.dataSet != null && this.dataSet.dataReady) {
            this.getSimulator().reset();
            this.plotWindow.rewind();
            this.plotWindow.refresh();
        }
    }

    public void rewindPlot() {
        this.getSimulator().reset();
        if (this.dataSet != null && this.dataSet.dataReady) {
            this.plotWindow.rewind();
            this.plotWindow.refresh();
        }
    }

    void LoadDataSet(String string) {
        InputStream inputStream = FileToolkit.getInputStream(string);
        try {
            this.dataSet = new PlotDataSet(inputStream);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(String.valueOf(String.valueOf("While creating plot ").concat(String.valueOf(string))).concat(String.valueOf(" , PlotDataSet throws "))).concat(String.valueOf(exception)));
        }
        if (this.isImmediateLoad()) {
            this.dataSet.LoadFile(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME")) {
            if (!this.isImmediateLoad() && this.dataSet != null && !this.dataSet.dataReady) {
                if (!this.dataSet.isLoadInProgress()) {
                    this.dataSet.LoadFile(false);
                } else {
                    this.dataSet.ReadDataFileCore();
                    if (this.dataSet.dataReady) {
                        this.plotWindow.updateDataSet();
                        this.getSimulator().reset();
                    } else {
                        this.plotWindow.repaint();
                    }
                }
            }
            if (this.dataSet.dataReady) {
                this.plotWindow.setAnimationIndex(this.getSimulator().getTime() / 0.1);
                this.plotWindow.repaint();
            }
            if (this.getSimulator().getTime() > (double)11) {
                this.getSimulator().reset();
            }
            return;
        }
        if (this.plotWindow.loadInProgress) {
            return;
        }
        if (actionEvent.getActionCommand().startsWith("HEIGHT ")) {
            int n = CrackedString.getInt(actionEvent.getActionCommand(), 1);
            if (this.getCurrentDataSet() != n) {
                this.choiceStepHeight.select(n);
                this.setDataSet(n);
            }
        } else if (actionEvent.getActionCommand().startsWith("WIDTH ")) {
            int n = CrackedString.getInt(actionEvent.getActionCommand(), 1);
            if (this.getCurrentDataSet() != n + 4) {
                this.choiceBarWidth.select(n);
                this.setDataSet(n + 4);
            }
        } else if (actionEvent.getActionCommand().startsWith("POTENTIAL ")) {
            int n = CrackedString.getInt(actionEvent.getActionCommand(), 1);
            if (this.getCurrentDataSet() / 4 != n) {
                this.choicePot.select(n);
                this.itemStateChanged(new ItemEvent(this.choicePot, 0, null, 0));
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choicePot) {
            if (this.choicePot.getSelectedIndex() == 0 && !this.showStep) {
                this.showStep = true;
                this.getToolBar().remove(this.choiceBarWidth);
                this.getToolBar().setVisible(false);
                this.label.setText(String.valueOf(PhysicApplet.getWord("Height")).concat(String.valueOf(" [meV]")));
                this.getToolBar().add(this.choiceStepHeight);
                this.getToolBar().doLayout();
                this.getToolBar().setVisible(true);
                this.setDataSet(this.choiceStepHeight.getSelectedIndex());
            } else if (this.choicePot.getSelectedIndex() == 1 && this.showStep) {
                this.showStep = false;
                this.getToolBar().remove(this.choiceStepHeight);
                this.getToolBar().setVisible(false);
                this.label.setText(String.valueOf(PhysicApplet.getWord("Width")).concat(String.valueOf(" [nm]")));
                this.getToolBar().add(this.choiceBarWidth);
                this.getToolBar().doLayout();
                this.getToolBar().setVisible(true);
                this.setDataSet(this.choiceBarWidth.getSelectedIndex() + 4);
            }
        } else if (itemEvent.getSource() == this.choiceStepHeight) {
            this.setDataSet(this.choiceStepHeight.getSelectedIndex());
        } else if (itemEvent.getSource() == this.choiceBarWidth) {
            this.setDataSet(this.choiceBarWidth.getSelectedIndex() + 4);
        }
    }
}

