/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.Color;
import phy.quanta.MolecularViewer;
import phy.quanta.Molecule;
import phy.quanta.QuantaApplet;

public class ModeleMoleculaire
extends QuantaApplet {
    String mdname = null;
    String message = null;
    MolecularViewer molecularViewer;
    long lastTime;
    Molecule molecule;
    int mode = 0;
    String name;

    public void init() {
        super.init();
        this.setBackground(Color.black);
        this.mode = this.getParameter("mode", 0);
        if (this.mode == 1) {
            this.setRunning(true);
        }
        this.name = this.getParameter("name", "NH3");
        this.molecule = new Molecule();
        this.molecule.setCenteredCube(true);
        if (this.name.equals("NH3")) {
            this.molecule.addVert("N", 0.0f, 0.0f, 0.0f);
            this.molecule.addVert("H", -1.0f, 1.0f, 1.0f);
            this.molecule.addVert("H", 1.0f, -1.0f, 1.0f);
            this.molecule.addVert("H", 1.0f, 1.0f, -1.0f);
        } else if (this.name.equals("CH4")) {
            this.molecule.addVert("C", 0.0f, 0.0f, 0.0f);
            this.molecule.addVert("H", -1.0f, 1.0f, 1.0f);
            this.molecule.addVert("H", 1.0f, -1.0f, 1.0f);
            this.molecule.addVert("H", 1.0f, 1.0f, -1.0f);
            this.molecule.addVert("H", -1.0f, -1.0f, -1.0f);
        } else if (this.name.equals("C6H6")) {
            this.molecule.addVert("C", 0.0f, 1.0f, 0.0f);
            this.molecule.addVert("C", 0.0f, 0.5f, 0.866f);
            this.molecule.addVert("C", 0.0f, -0.5f, 0.866f);
            this.molecule.addVert("C", 0.0f, -1.0f, 0.0f);
            this.molecule.addVert("C", 0.0f, -0.5f, -0.866f);
            this.molecule.addVert("C", 0.0f, 0.5f, -0.866f);
        } else {
            this.molecule.addVert("H", 0.0f, 0.0f, 0.0f);
        }
        this.molecularViewer = new MolecularViewer(this.molecule);
        this.molecularViewer.yRot(20.0);
        this.molecularViewer.xRot(20.0);
        this.setLayout(new BorderLayout());
        this.add("Center", this.molecularViewer);
    }

    public void run() {
        this.lastTime = System.currentTimeMillis();
        while (true) {
            if (!this.molecularViewer.isMouseDown()) {
                long l = System.currentTimeMillis();
                double d = Math.cos((double)l / 4000.0 * Math.PI);
                double d2 = 360.0 * (double)(l - this.lastTime) / 12000.0;
                this.lastTime = l;
                d *= d;
                this.molecularViewer.yRot(d2);
                this.molecularViewer.repaint();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

