/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Cursor;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.quanta.Matrix3D;
import phy.quanta.Molecule;

class MolecularViewer
extends Panel
implements ActionListener {
    Molecule md;
    boolean painted = true;
    float xfac;
    int prevx;
    int prevy;
    float xtheta;
    float ytheta;
    float scalefudge = 1.0f;
    Matrix3D amat = new Matrix3D();
    Matrix3D tmat = new Matrix3D();
    Image backBuffer;
    Graphics backGC;
    boolean flagMouseDown = false;
    int panelWidth = -1;
    int panelHeight = -1;

    MolecularViewer(Molecule molecule) {
        this.setCursor(new Cursor(12));
        this.md = molecule;
        this.md.addActionListener(this);
        this.initBB();
    }

    void initBuffer() {
        float f;
        float f2;
        float f3 = (this.md.xmax - this.md.xmin) * 2.0f;
        float f4 = (this.md.ymax - this.md.ymin) * 2.0f;
        float f5 = (this.md.zmax - this.md.zmin) * 2.0f;
        if (f4 > f3) {
            f3 = f4;
        }
        if (f5 > f3) {
            f3 = f5;
        }
        this.xfac = 0.7f * ((f2 = (float)this.getSize().width / f3) < (f = (float)this.getSize().height / f3) ? f2 : f) * this.scalefudge;
        this.backBuffer = this.createImage(this.getSize().width, this.getSize().height);
        this.backGC = this.backBuffer.getGraphics();
        this.panelWidth = this.getSize().width;
        this.panelHeight = this.getSize().height;
    }

    void initBB() {
        this.md.findBB();
    }

    boolean isMouseDown() {
        return this.flagMouseDown;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.prevx = n;
        this.prevy = n2;
        this.flagMouseDown = true;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.prevx = n;
        this.prevy = n2;
        this.flagMouseDown = false;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.tmat.unit();
        float f = (float)(this.prevy - n2) * (360.0f / (float)this.getSize().width);
        float f2 = (float)(n - this.prevx) * (360.0f / (float)this.getSize().height);
        this.tmat.xrot(f);
        this.tmat.yrot(f2);
        this.amat.mult(this.tmat);
        if (this.painted) {
            this.painted = false;
            this.repaint();
        }
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    public void update(Graphics graphics) {
        if (this.backBuffer == null) {
            graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.panelWidth != this.getSize().width || this.panelHeight != this.getSize().height) {
            this.initBuffer();
        }
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.translate(-(this.md.xmin + this.md.xmax) / (float)2, -(this.md.ymin + this.md.ymax) / (float)2, -(this.md.zmin + this.md.zmax) / (float)2);
            this.md.mat.mult(this.amat);
            this.md.mat.scale(this.xfac, -this.xfac, 1000.0f);
            this.md.mat.translate(this.getSize().width / 2, this.getSize().height / 2, 500.0f);
            this.md.transformed = false;
            if (this.backBuffer != null) {
                this.backGC.setColor(this.getBackground());
                this.backGC.fillRect(0, 0, this.getSize().width, this.getSize().height);
                this.md.paint(this.backGC, this.xfac);
                graphics.drawImage(this.backBuffer, 0, 0, this);
            } else {
                this.md.paint(graphics, this.xfac);
            }
            this.setPainted();
        }
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }

    private synchronized void waitPainted() {
        while (!this.painted) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.painted = false;
    }

    void xRot(double d) {
        this.amat.xrot(d);
    }

    void yRot(double d) {
        this.amat.yrot(d);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("REFRESH")) {
            this.repaint();
        }
    }
}

