/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import phy.quanta.Atom;
import phy.quanta.Matrix3D;
import phy.util.ActionEventSupport;

class Molecule
extends ActionEventSupport
implements PropertyChangeListener {
    float[] vert;
    float[] brightness;
    Atom[] atoms;
    int[] tvert;
    int[] ZsortMap;
    int nvert;
    int maxvert;
    int[][] bounds;
    public static final String NH3 = "NH3";
    public static final String CH4 = "CH4";
    public static final String C6H6 = "C6H6";
    public static final String H2 = "H2";
    boolean centeredCube = false;
    protected double q = 1.0;
    static Hashtable atomTable = new Hashtable();
    static Atom defaultAtom;
    boolean transformed;
    Matrix3D mat = new Matrix3D();
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float zmin;
    float zmax;
    protected String name;

    public void setCenteredCube(boolean bl) {
        this.centeredCube = bl;
    }

    public double getQ() {
        return this.q;
    }

    public void setQ(double d) {
        this.q = d;
        this.buildMolecule();
        this.fireRefreshEvent();
    }

    public Molecule(String string) {
        this();
        this.name = string;
        this.buildMolecule();
    }

    public void buildMolecule() {
        if (this.name == null) {
            return;
        }
        this.nvert = 0;
        if (this.name.equals(NH3)) {
            this.addVert("N", 0.0f, 0.0f, 0.0f);
            float f = (float)((this.getQ() - (double)4) / (double)3);
            float f2 = (float)((this.getQ() + (double)2) / (double)3);
            this.addVert("H", f, f2, f2);
            this.addVert("H", f2, f, f2);
            this.addVert("H", f2, f2, f);
        } else if (this.name.equals(CH4)) {
            this.addVert("C", 0.0f, 0.0f, 0.0f);
            this.addVert("H", -1.0f, 1.0f, 1.0f);
            this.addVert("H", 1.0f, -1.0f, 1.0f);
            this.addVert("H", 1.0f, 1.0f, -1.0f);
            this.addVert("H", -1.0f, -1.0f, -1.0f);
        } else if (this.name.equals(H2)) {
            this.addVert("H", (float)this.getQ(), 0.0f, 0.0f);
            this.addVert("H", -((float)this.getQ()), 0.0f, 0.0f);
        } else if (this.name.equals(C6H6)) {
            this.addVert("C", 0.0f, 1.0f, 0.0f);
            this.addVert("C", 0.0f, 0.5f, 0.866f);
            this.addVert("C", 0.0f, -0.5f, 0.866f);
            this.addVert("C", 0.0f, -1.0f, 0.0f);
            this.addVert("C", 0.0f, -0.5f, -0.866f);
            this.addVert("C", 0.0f, 0.5f, -0.866f);
        } else {
            this.addVert("H", 0.0f, 0.0f, 0.0f);
        }
    }

    Molecule() {
        this.mat.xrot(20.0);
        this.mat.yrot(30.0);
    }

    public void hRotate(double d) {
        this.mat.xrot(d);
    }

    public void vRotate(double d) {
        this.mat.yrot(d);
    }

    /*
     * Unable to fully structure code
     */
    Molecule(InputStream var1_1) throws Exception {
        this();
        var2_2 = new StreamTokenizer(new BufferedInputStream(var1_1, 4000));
        var2_2.eolIsSignificant(true);
        var2_2.commentChar(35);
        var3_3 = false;
        block4: while (true) {
            switch (var2_2.nextToken()) {
                case -1: {
                    break block4;
                }
                default: {
                    continue block4;
                }
                case -3: {
                    var4_4 = var2_2.sval;
                    var5_5 = 0.0;
                    var7_6 = 0.0;
                    var9_7 = 0.0;
                    if (var2_2.nextToken() == -2) {
                        var5_5 = var2_2.nval;
                        if (var2_2.nextToken() == -2) {
                            var7_6 = var2_2.nval;
                            if (var2_2.nextToken() == -2) {
                                var9_7 = var2_2.nval;
                            }
                        }
                    }
                    this.addVert(var4_4, (float)var5_5, (float)var7_6, (float)var9_7);
                    while (true) {
                        if (var2_2.ttype != 10 && var2_2.ttype != -1) ** break;
                        continue block4;
                        var2_2.nextToken();
                    }
                }
            }
            break;
        }
        var1_1.close();
        if (var2_2.ttype != -1) {
            throw new Exception(var2_2.toString());
        }
    }

    void setAtomPos(int n, float f, float f2, float f3) {
        int n2 = 3 * n;
        this.vert[n2] = f;
        this.vert[n2 + 1] = f2;
        this.vert[n2 + 2] = f3;
    }

    void setAtomBrightness(int n, float f) {
        this.brightness[n] = f;
    }

    int nAtoms() {
        return this.nvert;
    }

    int addVert(String string, float f, float f2, float f3) {
        Object object;
        int n = this.nvert;
        if (n >= this.maxvert) {
            if (this.vert == null) {
                this.maxvert = 100;
                this.vert = new float[this.maxvert * 3];
                this.atoms = new Atom[this.maxvert];
                this.brightness = new float[this.maxvert];
            } else {
                this.maxvert *= 2;
                object = new float[this.maxvert * 3];
                System.arraycopy(this.vert, 0, object, 0, this.vert.length);
                this.vert = (float[])object;
                Atom[] atomArray = new Atom[this.maxvert];
                System.arraycopy(this.atoms, 0, atomArray, 0, this.atoms.length);
                this.atoms = atomArray;
                float[] fArray = new float[this.maxvert];
                System.arraycopy(this.brightness, 0, fArray, 0, this.brightness.length);
            }
        }
        if ((object = (Atom)atomTable.get(string.toLowerCase())) == null) {
            object = defaultAtom;
        }
        this.atoms[n] = object;
        this.brightness[n] = 1.0f;
        this.vert[n *= 3] = f;
        this.vert[n + 1] = f2;
        this.vert[n + 2] = f3;
        this.ZsortMap = null;
        return this.nvert++;
    }

    void removeVert(int n) {
        if (n < 0 || n >= this.nvert) {
            return;
        }
        for (int i = n; i < this.nvert - 1; ++i) {
            this.atoms[i] = this.atoms[i + 1];
            this.brightness[i] = this.brightness[i + 1];
            for (int j = 0; j < 3; ++j) {
                this.vert[3 * i + j] = this.vert[3 * (i + 1) + j];
            }
        }
        --this.nvert;
        this.ZsortMap = null;
    }

    void transform() {
        if (this.transformed || this.nvert <= 0) {
            return;
        }
        if (this.tvert == null || this.tvert.length < this.nvert * 3) {
            this.tvert = new int[this.nvert * 3];
        }
        this.mat.transform(this.vert, this.tvert, this.nvert);
        this.transformed = true;
    }

    void paint(Graphics graphics, float f) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.vert == null || this.nvert <= 0) {
            return;
        }
        this.transform();
        int[] nArray = this.tvert;
        int[] nArray2 = this.ZsortMap;
        if (nArray2 == null) {
            this.ZsortMap = nArray2 = new int[this.nvert];
            n4 = this.nvert;
            while (--n4 >= 0) {
                nArray2[n4] = n4 * 3;
            }
        }
        n4 = this.nvert - 1;
        while (--n4 >= 0) {
            n3 = 0;
            for (int i = 0; i <= n4; ++i) {
                n2 = nArray2[i];
                n = nArray2[i + 1];
                if (nArray[n2 + 2] <= nArray[n + 2]) continue;
                nArray2[i + 1] = n2;
                nArray2[i] = n;
                n3 = 1;
            }
            if (n3 != 0) continue;
            break;
        }
        n4 = 0;
        n3 = this.nvert;
        Atom[] atomArray = this.atoms;
        if (n3 <= 0 || this.nvert <= 0) {
            return;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray2[n2];
            this.atoms[n / 3].paint(graphics, nArray[n], nArray[n + 1], f * 2.0f * this.brightness[n / 3], this.brightness[n / 3]);
        }
    }

    void findBB() {
        float f;
        float f2;
        float f3;
        if (this.nvert <= 0) {
            return;
        }
        float[] fArray = this.vert;
        float f4 = f3 = fArray[0];
        float f5 = f2 = fArray[1];
        float f6 = f = fArray[2];
        int n = this.nvert * 3;
        while ((n -= 3) > 0) {
            float f7;
            float f8;
            float f9 = fArray[n];
            if (f9 < f3) {
                f3 = f9;
            }
            if (f9 > f4) {
                f4 = f9;
            }
            if ((f8 = fArray[n + 1]) < f2) {
                f2 = f8;
            }
            if (f8 > f5) {
                f5 = f8;
            }
            if ((f7 = fArray[n + 2]) < f) {
                f = f7;
            }
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        if (this.centeredCube) {
            float f10 = Math.max(Math.abs(f4), Math.abs(f3));
            f10 = Math.max(f10, Math.abs(f2));
            f10 = Math.max(f10, Math.abs(f5));
            f10 = Math.max(f10, Math.abs(f));
            this.ymax = this.zmax = (f10 = Math.max(f10, Math.abs(f6)));
            this.xmax = this.zmax;
            this.ymin = this.zmin = -f10;
            this.xmin = this.zmin;
        } else {
            this.xmax = f4;
            this.xmin = f3;
            this.ymax = f5;
            this.ymin = f2;
            this.zmax = f6;
            this.zmin = f;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("Q")) {
            this.setQ((Double)propertyChangeEvent.getNewValue());
        }
    }

    static {
        atomTable.put("c", new Atom("c", 0, 255, 0));
        atomTable.put("h", new Atom("h", 255, 255, 255));
        atomTable.put("n", new Atom("n", 0, 0, 255));
        atomTable.put("o", new Atom("o", 255, 0, 0));
        atomTable.put("p", new Atom("p", 255, 0, 255));
        atomTable.put("s", new Atom("s", 255, 255, 0));
        defaultAtom = new Atom("d", 255, 100, 200);
    }
}

