/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.function.Function;
import phy.util.DoubleVector;
import phy.util.MathTools;

public class MultiPuitsStructure {
    double xMin = -1.0;
    double xMax = 1.0;
    int nSteps = 5;
    int maxSteps = 100;
    double[] x = new double[this.maxSteps];
    double[] y = new double[this.maxSteps];
    double energy;
    protected double[] a = new double[this.maxSteps];
    protected double[] b = new double[this.maxSteps];
    double[] energyLevel;
    int nLevels;
    int maxLevels = 20;
    boolean sym = false;
    protected Function potentialFunction;
    protected boolean keepDivergence = false;

    MultiPuitsStructure() {
        this.x[0] = -0.5;
        this.y[0] = 3.0;
        this.x[1] = 0.0;
        this.y[1] = 2.0;
        this.x[2] = 0.5;
        this.y[2] = 1.0;
        this.x[3] = 0.7;
        this.y[3] = 0.0;
        this.x[4] = 1.5;
        this.y[4] = 3.0;
        this.energyLevel = new double[this.maxLevels];
    }

    public void setA(int n, double d) {
        this.a[n] = d;
    }

    public double getA(int n) {
        return this.a[n];
    }

    public void setB(int n, double d) {
        this.b[n] = d;
    }

    public double getB(int n) {
        return this.b[n];
    }

    public void setPotential(double[] dArray, double[] dArray2) {
        this.nSteps = dArray.length;
        for (int i = 0; i < this.nSteps; ++i) {
            this.x[i] = dArray[i];
            this.y[i] = dArray2[i];
        }
    }

    public void setPotential(Function function) {
        this.potentialFunction = function;
    }

    public Function getPotentialFunction() {
        return this.potentialFunction;
    }

    public void initPotential() {
        double d;
        double d2;
        int n;
        if (this.getPotentialFunction() == null) {
            return;
        }
        double d3 = this.xMin;
        double d4 = this.getPotentialFunction().getValue(this.xMin);
        DoubleVector doubleVector = new DoubleVector();
        for (n = 0; n <= 100; ++n) {
            d2 = this.xMin + (double)n / 100.0 * (this.xMax - this.xMin);
            d = this.getPotentialFunction().getValue(d2);
            if (!(d2 - d3 > (this.xMax - this.xMin) / (double)20 && Math.abs(d - d4) > 0.02) && !(Math.abs(d - d4) > 0.1)) continue;
            doubleVector.addElement(d2);
            d3 = d2;
            d4 = d;
        }
        this.nSteps = doubleVector.size() + 1;
        this.x = new double[this.nSteps];
        this.y = new double[this.nSteps];
        this.y[0] = this.getPotentialFunction().getValue(this.xMin);
        this.x[this.nSteps - 1] = this.xMax + 1.0;
        d3 = this.xMin;
        d4 = this.getPotentialFunction().getValue(this.xMin);
        for (n = 0; n < doubleVector.size(); ++n) {
            this.x[n] = doubleVector.getDouble(n);
            this.y[n + 1] = this.getPotentialFunction().getValue(this.x[n]);
            for (d2 = d3; d2 < doubleVector.getDouble(n); d2 += (this.xMax - this.xMin) / (double)500) {
                d = this.getPotentialFunction().getValue(d2);
                if (!(Math.abs(d - this.y[n + 1]) < Math.abs(d - d4))) continue;
                this.x[n] = d2;
                break;
            }
            d3 = doubleVector.getDouble(n);
            d4 = this.y[n + 1];
        }
    }

    int nPoints() {
        return 2 * this.nSteps - 1;
    }

    double getX(int n) {
        return this.x[n / 2];
    }

    double getY(int n) {
        return this.y[(n + 1) / 2];
    }

    double maxPotential() {
        return Math.min(this.y[0], this.y[this.nSteps - 1]);
    }

    double minPotential() {
        double d = this.maxPotential();
        for (int i = 0; i < this.nSteps; ++i) {
            d = Math.min(d, this.y[i]);
        }
        return d;
    }

    public void setSym(boolean bl) {
        this.sym = bl;
        if (this.sym) {
            for (int i = 0; i < this.nPoints() / 2 - 1; ++i) {
                int n = this.nPoints() - i - 2;
                this.x[n / 2] = -this.x[i / 2];
                this.y[(n + 1) / 2] = this.y[(i + 1) / 2];
            }
        }
    }

    public boolean isSym() {
        return this.sym;
    }

    public void setEnergy(double d) {
        this.energy = d;
    }

    public double getEnergy() {
        return this.energy;
    }

    double getEnergy(int n) {
        return this.energyLevel[n];
    }

    double xMinEnergy() {
        return this.xMinEnergy(this.energy);
    }

    double xMaxEnergy() {
        return this.xMaxEnergy(this.energy);
    }

    double xMinEnergy(double d) {
        double d2 = this.xMin - 1.0;
        if (d <= this.y[0]) {
            for (int i = 1; i < this.nSteps; ++i) {
                if (!(d > this.y[i])) continue;
                d2 = this.x[i - 1];
                break;
            }
        }
        if (d2 < this.xMin) {
            return this.xMin;
        }
        if (this.getPotentialFunction() != null) {
            double d3 = (this.xMax - this.xMin) / (double)1000;
            while (d > this.getPotentialFunction().getValue(d2) && d2 > this.xMin) {
                d2 -= d3;
            }
            while (d < this.getPotentialFunction().getValue(d2) && d2 < this.xMax) {
                d2 += d3;
            }
        }
        return d2;
    }

    double xMaxEnergy(double d) {
        double d2 = this.xMax + 1.0;
        for (int i = this.nSteps - 1; i >= 0; --i) {
            if (!(d > this.y[i])) continue;
            d2 = Math.min(this.xMax, this.x[i]);
            break;
        }
        if (d2 > this.xMax) {
            return this.xMax;
        }
        if (this.getPotentialFunction() != null) {
            double d3 = (this.xMax - this.xMin) / (double)1000;
            while (d > this.getPotentialFunction().getValue(d2) && d2 < this.xMax) {
                d2 += d3;
            }
            while (d < this.getPotentialFunction().getValue(d2) && d2 > this.xMin) {
                d2 -= d3;
            }
        }
        return d2;
    }

    void setPoint(int n, double d, double d2) {
        if (n >= 0 && n < this.nPoints()) {
            if (n / 2 > 0) {
                d = Math.max(this.x[n / 2 - 1], d);
            }
            if (n / 2 < this.nPoints() / 2 - 1) {
                d = Math.min(this.x[n / 2 + 1], d);
            }
            this.x[n / 2] = d;
            this.y[(n + 1) / 2] = d2;
            if (this.sym && this.nPoints() > 3) {
                int n2 = this.nPoints() - n - 2;
                this.x[n2 / 2] = -this.x[n / 2];
                this.y[(n2 + 1) / 2] = d2;
            }
        }
    }

    boolean isEvanescent(int n) {
        return this.energy < this.y[n];
    }

    double waveVector(int n) {
        if (this.energy > this.y[n]) {
            return Math.sqrt(this.energy - this.y[n]) * (double)10;
        }
        return -Math.sqrt(this.y[n] - this.energy) * (double)10;
    }

    double psi(int n, double d) {
        double d2 = this.waveVector(n);
        if (d2 > 0.0) {
            return this.a[n] * Math.sin(d2 * d + this.b[n]);
        }
        if (d2 < 0.0) {
            return this.a[n] * Math.exp(Math.abs(d2) * d) + this.b[n] * Math.exp(-Math.abs(d2) * d);
        }
        return this.a[n] * d + this.b[n];
    }

    double psiPrime(int n, double d) {
        double d2 = this.waveVector(n);
        if (d2 > 0.0) {
            return this.a[n] * d2 * Math.cos(d2 * d + this.b[n]);
        }
        if (d2 < 0.0) {
            return Math.abs(d2) * (this.a[n] * Math.exp(Math.abs(d2) * d) - this.b[n] * Math.exp(-Math.abs(d2) * d));
        }
        return this.a[n];
    }

    public double psi(double d) {
        for (int i = 0; i < this.nSteps; ++i) {
            if (!(d < this.x[i])) continue;
            return this.psi(i, d);
        }
        return 0.0;
    }

    public double psiPrime(double d) {
        for (int i = 0; i < this.nSteps; ++i) {
            if (!(d < this.x[i])) continue;
            return this.psiPrime(i, d);
        }
        return 0.0;
    }

    public int nSignChange() {
        int n = 0;
        for (int i = 0; i < this.nSteps; ++i) {
            double d = this.xMin;
            double d2 = this.xMax;
            if (i > 0) {
                d = this.x[i - 1];
            }
            if (i < this.nSteps - 1) {
                d2 = this.x[i];
            }
            if (this.waveVector(i) <= 0.0) {
                if (i == this.nSteps - 1) {
                    if (!(this.a[i] * this.psi(i, d) < 0.0)) continue;
                    ++n;
                    continue;
                }
                if (i <= 0 || !(this.psi(i, d) * this.psi(i, d2) < 0.0)) continue;
                ++n;
                continue;
            }
            double d3 = this.waveVector(i);
            n += (int)(Math.floor((d3 * d2 + this.b[i]) / Math.PI) - Math.floor((d3 * d + this.b[i]) / Math.PI));
        }
        return n;
    }

    public void setKeepDivergence(boolean bl) {
        this.keepDivergence = bl;
    }

    public void computeWaveFunction() {
        this.a[0] = 1.0;
        this.b[0] = this.keepDivergence ? (double)8 * Math.exp(-this.waveVector(0) * (this.xMin + this.x[0])) : 0.0;
        if (this.nSteps == 1 && this.waveVector(0) < 0.0) {
            this.b[0] = 1.0;
        }
        for (int i = 1; i < this.nSteps; ++i) {
            double d;
            double d2 = this.waveVector(i);
            double d3 = this.psi(i - 1, this.x[i - 1]);
            double d4 = this.psiPrime(i - 1, this.x[i - 1]);
            if (d2 > 0.0) {
                d = Math.atan2(d3, d4 / Math.abs(d2));
                this.b[i] = d - d2 * this.x[i - 1];
                this.a[i] = d3 * Math.sin(d) + d4 / Math.abs(d2) * Math.cos(d);
                continue;
            }
            if (d2 < 0.0) {
                d = Math.exp(Math.abs(d2) * this.x[i - 1]);
                this.a[i] = (d3 + d4 / Math.abs(d2)) / (double)2 / d;
                this.b[i] = (d3 - d4 / Math.abs(d2)) / (double)2 * d;
                continue;
            }
            this.a[i] = d4;
            this.b[i] = d3 - d4 * this.x[i - 1];
        }
    }

    void normaliseWaveFunction() {
        int n;
        double d = 9.999999999999999E-31;
        double d2 = this.xMin;
        for (n = 0; n < this.nSteps; ++n) {
            if (this.waveVector(n) > 0.0) {
                double d3 = this.waveVector(n);
                d = Math.floor(((double)2 * d3 * d2 + (double)2 * this.b[n]) / (double)2 / Math.PI - 0.5) != Math.floor(((double)2 * d3 * this.x[n] + (double)2 * this.b[n]) / (double)2 / Math.PI - 0.5) ? Math.max(d, (double)2 * Math.abs(this.a[n])) : MathTools.max(d, (double)2 * Math.abs(this.psi(n, d2)), (double)2 * Math.abs(this.psi(n, this.x[n])));
            }
            d2 = this.x[n];
        }
        if (d == 9.999999999999999E-31) {
            d = Math.max(d, Math.abs(this.psi(-1.0)));
            d = Math.max(d, Math.abs(this.psi(1.0)));
            for (n = 1; n < this.nSteps - 1; ++n) {
                d = Math.max(d, Math.abs(this.psi(this.x[n])));
            }
        }
        for (n = 0; n < this.nSteps; ++n) {
            int n2 = n;
            this.a[n2] = this.a[n2] / d;
            if (!(this.waveVector(n) <= 0.0)) continue;
            int n3 = n;
            this.b[n3] = this.b[n3] / d;
        }
    }

    public void cancelExponentialTail() {
        this.a[this.nSteps - 1] = 0.0;
    }

    int findEnergyLevels() {
        this.setEnergy(this.maxPotential() - 0.01);
        this.computeWaveFunction();
        this.nLevels = Math.min(this.nSignChange(), this.maxLevels);
        for (int i = 0; i < this.nLevels; ++i) {
            this.energyLevel[i] = this.findEnergyLevel(i);
        }
        return this.nLevels;
    }

    double findEnergyLevel(int n) {
        double d = this.minPotential();
        double d2 = this.maxPotential();
        for (int i = 0; i < 15; ++i) {
            this.setEnergy((d + d2) / (double)2);
            this.computeWaveFunction();
            if (this.nSignChange() > n) {
                d2 = this.energy;
                continue;
            }
            d = this.energy;
        }
        this.b[this.nSteps - 1] = 0.0;
        return this.energy;
    }
}

