/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.util.Complex;

class MultiPuitsStructureNouvelleVersion {
    double xMin = -1.0;
    double xMax = 1.0;
    int nSteps = 5;
    int maxSteps = 10;
    double[] x = new double[this.maxSteps];
    double[] y = new double[this.maxSteps];
    double energy;
    Complex[] a = new Complex[this.maxSteps];
    Complex[] b = new Complex[this.maxSteps];
    double[] energyLevel;
    int nLevels;
    int maxLevels = 20;
    boolean sym = false;

    MultiPuitsStructureNouvelleVersion() {
        this.x[0] = -0.5;
        this.y[0] = 3.0;
        this.x[1] = 0.0;
        this.y[1] = 2.0;
        this.x[2] = 0.5;
        this.y[2] = 1.0;
        this.x[3] = 0.7;
        this.y[3] = 0.0;
        this.x[4] = 1.5;
        this.y[4] = 3.0;
        this.energyLevel = new double[this.maxLevels];
    }

    void setPotential(double[] dArray, double[] dArray2) {
        this.nSteps = dArray.length;
        for (int i = 0; i < this.nSteps; ++i) {
            this.x[i] = dArray[i];
            this.y[i] = dArray2[i];
        }
    }

    int nPoints() {
        return 2 * this.nSteps - 1;
    }

    double getX(int n) {
        return this.x[n / 2];
    }

    double getY(int n) {
        return this.y[(n + 1) / 2];
    }

    double maxPotential() {
        return Math.min(this.y[0], this.y[this.nSteps - 1]);
    }

    double minPotential() {
        double d = this.maxPotential();
        for (int i = 0; i < this.nSteps; ++i) {
            d = Math.min(d, this.y[i]);
        }
        return d;
    }

    public void setSym(boolean bl) {
        this.sym = bl;
        if (this.sym) {
            for (int i = 0; i < this.nPoints() / 2 - 1; ++i) {
                int n = this.nPoints() - i - 2;
                this.x[n / 2] = -this.x[i / 2];
                this.y[(n + 1) / 2] = this.y[(i + 1) / 2];
            }
        }
    }

    void setEnergy(double d) {
        this.energy = d;
    }

    double getEnergy() {
        return this.energy;
    }

    double getEnergy(int n) {
        return this.energyLevel[n];
    }

    double xMinEnergy() {
        return this.xMinEnergy(this.energy);
    }

    double xMaxEnergy() {
        return this.xMaxEnergy(this.energy);
    }

    double xMinEnergy(double d) {
        if (d > this.y[0]) {
            return this.xMin;
        }
        for (int i = 1; i < this.nSteps; ++i) {
            if (!(d > this.y[i])) continue;
            return this.x[i - 1];
        }
        return this.xMin;
    }

    double xMaxEnergy(double d) {
        for (int i = this.nSteps - 1; i >= 0; --i) {
            if (!(d > this.y[i])) continue;
            return Math.min(this.xMax, this.x[i]);
        }
        return this.xMax;
    }

    void setPoint(int n, double d, double d2) {
        if (n >= 0 && n < this.nPoints()) {
            this.x[n / 2] = d;
            this.y[(n + 1) / 2] = d2;
            if (this.sym) {
                int n2 = this.nPoints() - n - 2;
                this.x[n2 / 2] = -d;
                this.y[(n2 + 1) / 2] = d2;
            }
        }
    }

    boolean isEvanescent(int n) {
        return this.energy < this.y[n];
    }

    double waveVector(int n) {
        if (this.energy > this.y[n]) {
            return Math.sqrt(this.energy - this.y[n]) * (double)10;
        }
        return -Math.sqrt(this.y[n] - this.energy) * (double)10;
    }

    Complex complexPsi(int n, double d) {
        double d2 = this.waveVector(n);
        if (d2 > 0.0) {
            return Complex.add(Complex.mul(this.a[n], Complex.expI(d2 * d)), Complex.mul(this.b[n], Complex.expI(-d2 * d)));
        }
        return Complex.add(Complex.mul(this.a[n], Math.exp(Math.abs(d2) * d)), Complex.mul(this.b[n], Math.exp(-Math.abs(d2) * d)));
    }

    double psi(int n, double d) {
        return this.complexPsi((int)n, (double)d).re;
    }

    Complex complexPsiPrime(int n, double d) {
        double d2 = this.waveVector(n);
        if (d2 > 0.0) {
            return Complex.mul(new Complex(0.0, d2), Complex.add(Complex.mul(this.a[n], Complex.expI(d2 * d)), Complex.mul(new Complex(-this.b[n].re, -this.b[n].im), Complex.expI(-d2 * d))));
        }
        return Complex.mul(new Complex(Math.abs(d2), 0.0), Complex.add(Complex.mul(this.a[n], Math.exp(Math.abs(d2) * d)), Complex.mul(new Complex(-this.b[n].re, -this.b[n].im), Math.exp(-Math.abs(d2) * d))));
    }

    Complex complexPsi(double d) {
        for (int i = 0; i < this.nSteps; ++i) {
            if (!(d < this.x[i])) continue;
            return this.complexPsi(i, d);
        }
        return new Complex(0.0, 0.0);
    }

    double psi(double d) {
        return this.complexPsi((double)d).re;
    }

    int nSignChange() {
        int n = 0;
        for (int i = 0; i < this.nSteps; ++i) {
            double d = this.xMin;
            double d2 = this.xMax;
            if (i > 0) {
                d = this.x[i - 1];
            }
            if (i < this.nSteps - 1) {
                d2 = this.x[i];
            }
            if (this.isEvanescent(i)) {
                if (i == this.nSteps - 1) {
                    if (!(this.a[i].re * this.psi(i, d) < 0.0)) continue;
                    ++n;
                    continue;
                }
                if (i <= 0 || !(this.psi(i, d) * this.psi(i, d2) < 0.0)) continue;
                ++n;
                continue;
            }
            double d3 = this.waveVector(i);
        }
        return n;
    }

    void computeWaveFunction() {
        this.a[0] = new Complex(1.0, 0.0);
        this.b[0] = new Complex(0.0, 0.0);
        if (this.nSteps == 0 && this.waveVector(0) < 0.0) {
            this.b[0] = new Complex(1.0, 0.0);
        }
        for (int i = 1; i < this.nSteps; ++i) {
            double d = this.waveVector(i);
            Complex complex = this.complexPsi(i - 1, this.x[i - 1]);
            Complex complex2 = Complex.mul(this.complexPsiPrime(i - 1, this.x[i - 1]), 1.0 / Math.abs(d));
            if (d > 0.0) {
                complex2 = complex2.mul(new Complex(0.0, -1.0));
                this.a[i] = Complex.mul(Complex.mul(Complex.add(complex, complex2), new Complex(0.5, 0.0)), Complex.expI(-d * this.x[i - 1]));
                this.b[i] = Complex.sub(complex, complex2).mul(0.5).mul(Complex.expI(d * this.x[i - 1]));
                continue;
            }
            this.a[i] = Complex.add(complex, complex2).mul(0.5 * Math.exp(-Math.abs(d) * this.x[i - 1]));
            this.b[i] = Complex.sub(complex, complex2).mul(0.5 * Math.exp(Math.abs(d) * this.x[i - 1]));
        }
    }

    void normaliseWaveFunction() {
        int n;
        double d = 9.999999999999999E-31;
        for (n = 0; n < this.nSteps; ++n) {
            if (this.isEvanescent(n)) continue;
            d = Math.max(d, this.a[n].abs() + this.b[n].abs());
        }
        if (d != 9.999999999999999E-31) {
            d *= (double)2;
        }
        for (n = 0; n < this.nSteps; ++n) {
            this.a[n].mul(1.0 / d);
            this.b[n].mul(1.0 / d);
        }
    }

    void cancelExponentialTail() {
        if (this.isEvanescent(this.nSteps - 1)) {
            this.a[this.nSteps - 1] = new Complex();
        }
    }

    int findEnergyLevels() {
        this.setEnergy(this.maxPotential() - 0.01);
        this.computeWaveFunction();
        this.nLevels = Math.min(this.nSignChange(), this.maxLevels);
        for (int i = 0; i < this.nLevels; ++i) {
            this.energyLevel[i] = this.findEnergyLevel(i);
        }
        return this.nLevels;
    }

    double findEnergyLevel(int n) {
        double d = this.minPotential();
        double d2 = this.maxPotential();
        for (int i = 0; i < 15; ++i) {
            this.setEnergy((d + d2) / (double)2);
            this.computeWaveFunction();
            if (this.nSignChange() > n) {
                d2 = this.energy;
                continue;
            }
            d = this.energy;
        }
        return this.energy;
    }
}

