/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import phy.control.HotHLine;
import phy.control.HotPoint;
import phy.dynaplot.PlotDataSet;
import phy.graphe.BufferedPanel;
import phy.quanta.MultiPuitsStructure;
import phy.util.DoublePoint;
import phy.util.MathTools;

public class MultiPuitsWindow
extends BufferedPanel
implements KeyListener {
    int nPoints = 200;
    protected MultiPuitsStructure puits = new MultiPuitsStructure();
    protected double xViewMax = 1.1;
    protected double xViewMin = -1.1;
    protected int nLevelsShown = 1000;
    protected boolean hotPotentialEnabled = true;
    protected String potentialLabel = "V(x)";
    protected double energy = 2.0;
    protected boolean computationValid = false;
    protected int mode = 0;
    protected PlotDataSet dataSet;
    protected boolean showEnergyLevels = true;
    boolean showWaveFunctions = true;
    boolean showSelect = false;
    boolean showTrialFunction = true;
    protected boolean shouldCancelTail = false;

    public MultiPuitsStructure getPuits() {
        return this.puits;
    }

    public void setXViewMax(double d) {
        this.xViewMax = d;
    }

    public double getXViewMax() {
        return this.xViewMax;
    }

    public void setXViewMin(double d) {
        this.xViewMin = d;
    }

    public double getXViewMin() {
        return this.xViewMin;
    }

    public void setNLevelsShown(int n) {
        this.nLevelsShown = n;
    }

    public int getNLevelsShown() {
        return this.nLevelsShown;
    }

    public void setHotPotentialEnabled(boolean bl) {
        this.hotPotentialEnabled = bl;
    }

    public boolean isHotPotentialEnabled() {
        return this.hotPotentialEnabled;
    }

    public void setPotentialLabel(String string) {
        this.potentialLabel = string;
    }

    public void setEnergy(double d) {
        this.energy = d;
    }

    public void setComputationValid(boolean bl) {
        this.computationValid = bl;
    }

    public boolean isComputationValid() {
        return this.computationValid;
    }

    public void setShowEnergyLevels(boolean bl) {
        this.showEnergyLevels = bl;
    }

    public void setShowWaveFunctions(boolean bl) {
        this.showWaveFunctions = bl;
        if (bl) {
            this.setShowEnergyLevels(true);
        }
    }

    public void setShowSelect(boolean bl) {
        this.showSelect = bl;
    }

    public void setShowTrialFunction(boolean bl) {
        this.showTrialFunction = bl;
    }

    public void setMode(int n) {
        this.mode = n;
        switch (n) {
            case 0: {
                this.setShowEnergyLevels(false);
                this.setShowWaveFunctions(false);
                this.setShowTrialFunction(true);
                break;
            }
            case 1: {
                this.setShowEnergyLevels(true);
                this.setShowWaveFunctions(false);
                this.setShowTrialFunction(false);
                break;
            }
            case 2: {
                this.setShowWaveFunctions(true);
                this.setShowTrialFunction(false);
            }
        }
        this.setComputationValid(false);
    }

    public void setSym(boolean bl) {
        this.puits.setSym(bl);
        this.doComputation();
        this.refresh();
    }

    public boolean isSym() {
        return this.puits.isSym();
    }

    MultiPuitsWindow() {
        this.graphics.setWindow(-1.0, -1.0, 1.0, 6.0);
        this.setMouseActive(true);
        this.dataSet = new PlotDataSet(1, this.nPoints);
        this.dataSet.FillX(-1.0, 1.0);
        this.setFlag("WAVE");
        this.setFlag("TRIAL_ENERGY");
        this.addKeyListener(this);
    }

    public void build() {
        super.build();
        this.doComputation();
    }

    void initDataSet() {
        if (this.showWaveFunctions) {
            if (this.dataSet.getNCurves() != this.puits.nLevels + 1) {
                this.dataSet.resize(this.puits.nLevels + 1, this.nPoints);
                this.dataSet.FillX(-1.0, 1.0);
            }
        } else if (this.dataSet.getNCurves() != 1) {
            this.dataSet.resize(1, this.nPoints);
            this.dataSet.FillX(-1.0, 1.0);
        }
    }

    public void doComputation() {
        this.puits.findEnergyLevels();
        if (this.showWaveFunctions && !this.isComputationValid()) {
            this.initDataSet();
            double d = 1.0;
            if (!this.showTrialFunction) {
                d = 0.5;
            }
            for (int i = 0; i < this.puits.nLevels; ++i) {
                this.puits.setEnergy(this.puits.getEnergy(i));
                this.puits.computeWaveFunction();
                this.puits.cancelExponentialTail();
                this.puits.normaliseWaveFunction();
                for (int j = 0; j < this.nPoints; ++j) {
                    this.dataSet.zData[i + 1][j] = d * this.puits.psi(this.dataSet.X(j)) + this.puits.getEnergy();
                }
            }
            this.setComputationValid(true);
        }
        this.doFunctionComputation();
    }

    protected void doFunctionComputation() {
        this.shouldCancelTail = false;
        if (this.showTrialFunction) {
            int n;
            this.initDataSet();
            for (n = 0; n < this.puits.nLevels; ++n) {
                if (this.yScreen(this.energy) != this.yScreen(this.puits.getEnergy(n))) continue;
                this.energy = this.puits.getEnergy(n);
                this.shouldCancelTail = true;
                break;
            }
            this.puits.setEnergy(this.energy);
            this.puits.computeWaveFunction();
            if (this.shouldCancelTail) {
                this.puits.cancelExponentialTail();
            }
            this.puits.normaliseWaveFunction();
            for (n = 0; n < this.nPoints; ++n) {
                this.dataSet.zData[0][n] = this.puits.psi(this.dataSet.X(n)) + this.puits.getEnergy();
            }
        }
    }

    protected boolean isFreeWave() {
        return this.puits.getY(0) < this.puits.getEnergy();
    }

    public void paintCore() {
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        int n3;
        super.paintCore();
        this.graphics.setColor(Color.green);
        if (this.puits.getPotentialFunction() != null) {
            for (n3 = 1; n3 < this.dataSet.getNPoints(); ++n3) {
                this.graphics.drawLine(new DoublePoint(this.dataSet.X(n3 - 1), this.puits.getPotentialFunction().getValue(this.dataSet.X(n3 - 1))), new DoublePoint(this.dataSet.X(n3), this.puits.getPotentialFunction().getValue(this.dataSet.X(n3))));
            }
        } else {
            this.graphics.moveTo(this.puits.xMin, this.puits.getY(0));
            for (n3 = 0; n3 < this.puits.nPoints(); ++n3) {
                this.graphics.drawTo(this.puits.getX(n3), this.puits.getY(n3));
            }
            this.graphics.drawTo(this.puits.xMax, this.puits.getY(this.puits.nPoints() - 1));
        }
        if (this.isFlagSet("V")) {
            Point point = this.graphics.screenPoint(this.puits.xMax, this.puits.getY(this.puits.nPoints() - 1));
            point.x -= 5;
            point.y -= 4;
            this.graphics.drawString(this.potentialLabel, point, 2);
        }
        this.graphics.setColor(Color.white);
        for (n2 = 0; n2 < this.puits.nLevels && n2 < this.getNLevelsShown(); ++n2) {
            if ((!this.showEnergyLevels || this.showSelect) && !this.isFlagSet(String.valueOf("LEVEL").concat(String.valueOf(n2)))) continue;
            this.graphics.moveTo(this.puits.xMinEnergy(this.puits.getEnergy(n2)), this.puits.getEnergy(n2));
            this.graphics.drawTo(this.puits.xMaxEnergy(this.puits.getEnergy(n2)), this.puits.getEnergy(n2));
        }
        if (this.showWaveFunctions) {
            this.graphics.setColor(Color.yellow);
            if (this.showTrialFunction) {
                this.graphics.setColor(Color.gray);
            }
            for (n2 = 0; n2 < this.puits.nLevels && n2 < this.getNLevelsShown(); ++n2) {
                if (this.showSelect && !this.isFlagSet(String.valueOf("LEVEL").concat(String.valueOf(n2)))) continue;
                this.graphics.moveTo(this.dataSet.X(0), this.dataSet.Z(n2 + 1, 0));
                for (n = 0; n < this.dataSet.getNPoints(); ++n) {
                    this.graphics.drawTo(this.dataSet.X(n), this.dataSet.Z(n2 + 1, n));
                }
            }
        }
        this.graphics.setColor(Color.white);
        for (n2 = 0; n2 < this.puits.nLevels && n2 < this.getNLevelsShown(); ++n2) {
            if (!this.isFlagSet("ENERGY_LABEL") && !this.isFlagSet(String.valueOf("LEVEL").concat(String.valueOf(n2)))) continue;
            this.graphics.drawTeX(String.valueOf("E_").concat(String.valueOf(n2)), new DoublePoint(this.puits.xMaxEnergy(this.puits.getEnergy(n2)) + this.graphics.getHPixel() * (double)5, this.puits.getEnergy(n2)), 6);
        }
        if (this.showTrialFunction) {
            if (this.isFlagSet("TRIAL_ENERGY")) {
                this.graphics.setColor(Color.red);
                this.graphics.moveTo(this.puits.xMinEnergy(), this.puits.getEnergy());
                this.graphics.drawTo(this.puits.xMaxEnergy(), this.puits.getEnergy());
                Point point = this.graphics.screenPoint(this.puits.xMaxEnergy(), this.puits.getEnergy());
                point.x -= 5;
                point.y -= 2;
                this.graphics.drawString("E", point, 2);
            }
            if (this.isFlagSet("WAVE")) {
                int n4;
                this.graphics.setColor(Color.yellow);
                this.graphics.moveTo(this.dataSet.X(0), this.dataSet.Z(0, 0));
                for (n4 = 1; n4 < this.dataSet.getNPoints() && this.dataSet.X(n4) <= this.getXViewMin(); ++n4) {
                    this.graphics.moveTo(this.dataSet.X(n4), this.dataSet.Z(0, n4));
                }
                while (n4 < this.dataSet.getNPoints() && this.dataSet.X(n4) < this.getXViewMax()) {
                    this.graphics.drawTo(this.dataSet.X(n4), this.dataSet.Z(0, n4));
                    ++n4;
                }
            }
        }
        if (this.isFlagSet("POINT_CONT_1")) {
            double d4 = this.puits.getX(0);
            d3 = this.puits.psi(d4);
            d2 = this.puits.psiPrime(d4);
            d = (double)50 * this.graphics.getHPixel() / Math.sqrt(1.0 + MathTools.sqr(d2 * this.graphics.getHPixel() / this.graphics.getVPixel()));
            this.graphics.setColor(Color.white);
            this.graphics.fillDisk(new DoublePoint(d4, this.puits.getEnergy() + d3), new Integer(3));
            this.graphics.drawDoubleArrow(new DoublePoint(d4 - d, this.puits.getEnergy() + d3 - d * d2), new DoublePoint(d4 + d, this.puits.getEnergy() + d3 + d * d2), 10);
        }
        if (this.isFlagSet("POINT_CONT_2")) {
            double d5 = this.puits.getX(2);
            d3 = this.puits.psi(d5);
            d2 = this.puits.psiPrime(d5);
            d = (double)50 * this.graphics.getHPixel() / Math.sqrt(1.0 + MathTools.sqr(d2 * this.graphics.getHPixel() / this.graphics.getVPixel()));
            this.graphics.setColor(Color.white);
            this.graphics.fillDisk(new DoublePoint(d5, this.puits.getEnergy() + d3), new Integer(3));
            this.graphics.drawDoubleArrow(new DoublePoint(d5 - d, this.puits.getEnergy() + d3 - d * d2), new DoublePoint(d5 + d, this.puits.getEnergy() + d3 + d * d2), 10);
        }
        if (this.isFlagSet("EQ1")) {
            this.graphics.drawTeX("\\white \\frac{\\hbar ^2}{2 m} \\frac{d^2 \\varphi(x)}{d x^2} + (E-V) \\varphi(x) =0", new Point(20, 10), 4);
        }
        if (this.isFlagSet("EQ2")) {
            if (this.isFreeWave()) {
                this.graphics.drawTeX("\\yellow E-V = \\frac{\\hbar ^2 k^2}{2 m}", new Point(20, 70), 6);
            } else {
                this.graphics.drawTeX("\\yellow V-E = \\frac{\\hbar ^2 k^2}{2 m}", new Point(20, 70), 6);
            }
        }
        if (this.isFlagSet("EQ3")) {
            this.graphics.drawTeX("\\white \\rightarrow", new Point(200, 30), 6);
            if (this.isFreeWave()) {
                this.graphics.drawTeX("\\white \\frac{d^2 \\varphi(x)}{d x^2} + k^2 \\varphi(x) =0", new Point(225, 10), 4);
            } else {
                this.graphics.drawTeX("\\white \\frac{d^2 \\varphi(x)}{d x^2} - k^2 \\varphi(x) =0", new Point(225, 10), 4);
            }
        }
        if (this.isFlagSet("EQ4")) {
            if (this.isFreeWave()) {
                this.graphics.drawTeX("\\yellow \\varphi(x) = A exp(ikx) + B exp(-ikx)", new Point(220, 70), 6);
            } else {
                this.graphics.drawTeX("\\yellow \\varphi(x) = A exp(kx) + B exp(-kx)", new Point(220, 70), 6);
            }
        }
        if (this.shouldCancelTail) {
            int n5 = 480;
            n = 38;
            this.graphics.setColor(Color.red);
            if (this.isFlagSet("CROSS_3")) {
                this.graphics.drawLineThick(new Point(n5 - 25, n - 10), new Point(n5 + 25, n + 10));
            }
            if (this.isFlagSet("CROSS_4")) {
                this.graphics.drawLineThick(new Point(n5 + 25, n - 10), new Point(n5 - 25, n + 10));
            }
        }
        this.initHotSpots();
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        if (this.puits.getPotentialFunction() == null && this.isHotPotentialEnabled()) {
            for (int i = 0; i < this.puits.nPoints(); ++i) {
                this.getHotSpotVector().addElement(new HotPoint(this.xScreen(this.puits.getX(i)), this.yScreen(this.puits.getY(i)), 0));
            }
        }
        if (this.showTrialFunction) {
            this.getHotSpotVector().addElement(new HotHLine(this.xScreen(this.puits.xMinEnergy(this.puits.getEnergy())), this.xScreen(this.puits.xMaxEnergy(this.puits.getEnergy())), this.yScreen(this.puits.getEnergy())));
        }
    }

    public void hotSpotHasMoved(int n) {
        double d = this.xUser(this.getCurrentHotSpot().getX());
        double d2 = this.yUser(this.getCurrentHotSpot().getY());
        if (this.getCurrentHotSpot() instanceof HotPoint) {
            this.puits.setPoint(n, d, d2);
            this.setComputationValid(false);
            this.doComputation();
            this.repaint();
        } else {
            this.energy = d2;
            this.doComputation();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        this.doComputation();
        this.refresh();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.showTrialFunction && this.isMouseActive()) {
            if (keyEvent.getKeyCode() == 40) {
                this.energy -= this.graphics.getVPixel();
                this.energy = MathTools.minMax(this.energy, this.graphics.getY1(), this.graphics.getY2());
                this.doComputation();
                this.refresh();
            } else if (keyEvent.getKeyCode() == 38) {
                this.energy += this.graphics.getVPixel();
                this.energy = MathTools.minMax(this.energy, this.graphics.getY1(), this.graphics.getY2());
                this.doComputation();
                this.refresh();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

