/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.quanta.QuantumState;
import phy.util.MathTools;

class ParticleInABox
implements QuantumState {
    double x0 = 1.0;
    double wx = 1.0;
    double omega = 1.0;
    double phaseShift;
    protected double time;

    ParticleInABox() {
    }

    public void setOmega(double d) {
        this.omega = d;
    }

    public void setPhaseShift(double d) {
        this.phaseShift = d;
    }

    public void setTime(double d) {
        this.time = d;
        double d2 = d / 8.0 + this.phaseShift / Math.PI / (double)2;
        double d3 = (Math.abs(d2 - Math.floor(d2) - 0.5) - 0.25) * (double)4;
        this.x0 = d3 * (double)2;
        this.wx = Math.sqrt(1.0 + MathTools.sqr(d % (double)100 / (double)30));
    }

    public double getValue(double d) {
        double d2;
        double d3;
        double d4 = this.x0 / (double)2;
        if (d4 < 0.0) {
            d3 = (double)-4 - this.x0;
            d2 = (double)30 * (d + (double)2) + Math.PI;
        } else {
            d3 = (double)4 - this.x0;
            d2 = (double)30 * (d - (double)2) + Math.PI;
        }
        return (Math.exp(-MathTools.sqr((d - this.x0) / this.wx * (double)4)) + Math.exp(-MathTools.sqr((d - d3) / this.wx * (double)4)) + Math.exp(-MathTools.sqr((d - this.x0) / this.wx * (double)4) / (double)2 - MathTools.sqr((d - d3) / this.wx * (double)4) / (double)2) * (double)2 * Math.cos(d2)) / (double)4 / Math.sqrt(this.wx);
    }

    public double getCenter() {
        return this.x0;
    }
}

