/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.quanta.QuantumState;
import phy.util.MathTools;

class ParticleInABoxQuantumLimit
implements QuantumState {
    double x0 = 1.0;
    double wx = 1.0;
    double omega = 1.0;
    double phaseShift;
    double[] coeffR = new double[this.nStates];
    double[] coeffI = new double[this.nStates];
    int nStates = 3;
    protected double time;

    public ParticleInABoxQuantumLimit() {
        this.setTime(0.0);
    }

    public void setOmega(double d) {
        this.omega = d;
    }

    public void setPhaseShift(double d) {
        this.phaseShift = d;
    }

    public void setTime(double d) {
        this.time = d;
        double d2 = d / 8.0 * (double)2 * Math.PI + this.phaseShift;
        for (int i = 0; i < this.nStates; ++i) {
            double d3 = MathTools.sqr(i + 1);
            this.coeffR[i] = Math.cos(d3 * d2);
            this.coeffI[i] = Math.sin(d3 * d2);
        }
    }

    public double getValue(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.7853981633974483;
        for (int i = 0; i < this.nStates; ++i) {
            double d5 = Math.sin(d4 * (double)(i + 1) * (d + (double)2));
            d2 += d5 * this.coeffR[i];
            d3 += d5 * this.coeffI[i];
        }
        return (MathTools.sqr(d2) + MathTools.sqr(d3)) / (double)15;
    }

    public double getCenter() {
        return 0.0;
    }
}

