/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.control.HotPoint;
import phy.graphe.BufferedPanel;
import phy.graphe.Scaler;
import phy.quanta.StationaryState;
import phy.util.PhysicApplet;

class PolarMultiViewer
extends BufferedPanel
implements ActionListener {
    int x0;
    int y0;
    int nStates = 2;
    StationaryState[] state = new StationaryState[this.nStates];
    Scaler scalerX = new Scaler();
    Scaler scalerY = new Scaler();

    public PolarMultiViewer(StationaryState stationaryState, StationaryState stationaryState2) {
        this.setCursor(new Cursor(12));
        this.setBackground(PhysicApplet.getDefaultBackground());
        this.state[0] = stationaryState;
        this.state[1] = stationaryState2;
        this.scalerX.setBounds(-1.5, 1.5);
        this.scalerY.setBounds(1.5, -1.5);
        for (int i = 0; i < this.nStates; ++i) {
            this.state[i].addActionListener(this);
        }
    }

    public void sizeHasChanged() {
        int n = Math.min(this.getWidth(), this.getHeight());
        this.scalerX.setNPixels(n);
        this.scalerY.setNPixels(n);
        this.scalerX.translate((this.getWidth() - n) / 2);
        this.scalerY.translate((this.getHeight() - n) / 2);
    }

    public void paintCore() {
        this.graphics.setColor(Color.white);
        this.graphics.drawArrow(new Point(this.scalerX.getI(-1.3), this.scalerY.getI(0.0)), new Point(this.scalerX.getI(1.3), this.scalerY.getI(0.0)));
        this.graphics.drawArrow(new Point(this.scalerX.getI(0.0), this.scalerY.getI(-1.3)), new Point(this.scalerX.getI(0.0), this.scalerY.getI(1.3)));
        this.graphics.getGraphics().drawOval(this.scalerX.getI(-1.0), this.scalerY.getI(1.0), this.scalerX.getDeltaI(2.0), this.scalerY.getDeltaI(-2.0));
        for (int i = 0; i < this.nStates; ++i) {
            String string = String.valueOf(String.valueOf("|\u03c8").concat(String.valueOf(i + 1))).concat(String.valueOf("(t)>"));
            int n = this.scalerX.getI(this.state[i].getRe());
            int n2 = this.scalerY.getI(this.state[i].getIm());
            this.graphics.setColor(Color.yellow);
            this.graphics.getGraphics().fillOval(n - 5, n2 - 5, 11, 11);
            this.graphics.getGraphics().drawString(string, n - 5, n2 - 8);
        }
        this.initHotSpots();
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        for (int i = 0; i < this.nStates; ++i) {
            this.getHotSpotVector().addElement(new HotPoint(this.scalerX.getI(this.state[i].getRe()), this.scalerY.getI(this.state[i].getIm()), 0));
        }
    }

    public void hotSpotHasMoved(int n) {
        this.state[n].setState(this.scalerX.getX(this.getCurrentHotSpot().getX()), this.scalerY.getX(this.getCurrentHotSpot().getY()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
    }
}

