/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.acq.DataSrcSupport;
import phy.quanta.PhiLaw;
import phy.quanta.RadialLaw;
import phy.quanta.ThetaLaw;
import phy.util.Point3D;

public class ProbabilityCloud
extends DataSrcSupport {
    protected int nShots = 1000;
    protected Point3D[] data;
    protected int n = 2;
    protected int l = 1;
    protected int m = 0;
    protected ThetaLaw thetaLaw = new ThetaLaw();
    protected PhiLaw phiLaw = new PhiLaw();
    protected RadialLaw radialLaw = new RadialLaw();
    protected double rate = 300.0;
    protected int indexRenewal = 0;

    public int size() {
        return this.nShots;
    }

    public Point3D getPoint(int n) {
        return this.data[n];
    }

    public void setN(int n) {
        System.out.println(String.valueOf("setN ").concat(String.valueOf(n)));
        this.n = n;
        this.radialLaw.hydrogen.setN(this.getN());
        this.radialLaw.init();
        this.initCloud();
    }

    public int getN() {
        return this.n;
    }

    public void setL(int n) {
        System.out.println(String.valueOf("setL ").concat(String.valueOf(n)));
        this.l = n;
        this.thetaLaw.setL(this.getL());
        this.radialLaw.hydrogen.setL(this.getL());
        this.radialLaw.init();
        this.initCloud();
    }

    public int getL() {
        return this.l;
    }

    public void setM(int n) {
        System.out.println(String.valueOf("setM ").concat(String.valueOf(n)));
        this.m = n;
        this.thetaLaw.setM(this.getM());
        this.initCloud();
    }

    public int getM() {
        return this.m;
    }

    public ProbabilityCloud() {
        this.data = new Point3D[this.nShots];
        for (int i = 0; i < this.nShots; ++i) {
            this.data[i] = new Point3D();
        }
        this.initCloud();
    }

    protected void initCloud() {
        this.computeCloud(0, this.nShots);
        this.indexRenewal = 0;
    }

    protected void computeCloud(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            int n3 = i % this.nShots;
            double d = this.radialLaw.getValue(Math.random());
            double d2 = this.thetaLaw.getValue(Math.random());
            double d3 = this.phiLaw.getValue(Math.random());
            this.data[n3].x = d * Math.sin(d2) * Math.cos(d3);
            this.data[n3].y = d * Math.sin(d2) * Math.sin(d3);
            this.data[n3].z = d * Math.cos(d2);
        }
    }

    protected void update() {
        int n = (int)Math.ceil(this.rate * this.getElapsedTime());
        this.computeCloud(this.indexRenewal, this.indexRenewal + n);
        this.indexRenewal = (this.indexRenewal + n) % this.nShots;
    }
}

