/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import phy.control.ListValueMonitor;
import phy.control.PhyButton;
import phy.quanta.QuantaDictionnaryEN;
import phy.quanta.QuantaDictionnaryFR;
import phy.util.MathTools;
import phy.util.PhysicApplet;
import phy.util.SoundPlayer;

public class QuantaApplet
extends PhysicApplet {
    protected boolean toolBarHandCursor = false;
    protected Panel toolBar;

    public static String getVersion() {
        return "1.01";
    }

    public void useToolBarHandCursor() {
        this.toolBarHandCursor = true;
        if (this.toolBar != null && this.toolBar.isEnabled()) {
            this.toolBar.setCursor(new Cursor(12));
        }
    }

    public boolean isToolBarHandCursor() {
        return this.toolBarHandCursor;
    }

    public void setToolBar(Panel panel) {
        this.toolBar = panel;
        if (this.toolBarHandCursor) {
            this.toolBar.setCursor(new Cursor(12));
        }
    }

    public Panel getToolBar() {
        return this.toolBar;
    }

    public void disableToolBar() {
        if (this.toolBar != null) {
            if (this.toolBarHandCursor) {
                this.toolBar.setCursor(new Cursor(0));
            }
            this.toolBar.setEnabled(false);
            for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                Component component = this.toolBar.getComponent(i);
                if (component instanceof Checkbox) {
                    ((Checkbox)component).setEnabled(false);
                } else if (component instanceof ListValueMonitor) {
                    ((ListValueMonitor)component).setListEnabled(false);
                } else if (component instanceof PhyButton) {
                    ((PhyButton)component).setButtonEnabled(false);
                } else {
                    component.setForeground(Color.gray);
                }
                component.repaint();
            }
        }
    }

    public void enableToolBar() {
        if (this.toolBar != null) {
            if (this.toolBarHandCursor) {
                this.toolBar.setCursor(new Cursor(12));
            }
            this.toolBar.setEnabled(true);
            for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
                Component component = this.toolBar.getComponent(i);
                if (component instanceof Checkbox) {
                    ((Checkbox)component).setEnabled(true);
                } else if (component instanceof ListValueMonitor) {
                    ((ListValueMonitor)component).setListEnabled(true);
                } else if (component instanceof PhyButton) {
                    ((PhyButton)component).setButtonEnabled(true);
                } else {
                    component.setForeground(Color.black);
                }
                component.repaint();
            }
            this.toolBar.repaint();
        }
        if (this.getPlayButton() != null) {
            this.getPlayButton().setButtonEnabled(true);
        }
    }

    public QuantaApplet() {
        PhysicApplet.setDefaultBackground(Color.black);
    }

    public void init() {
        super.init();
        MathTools.setDecimalPoint('.');
        if (PhysicApplet.getLanguage().equals("FR")) {
            PhysicApplet.phyDictionnary = new QuantaDictionnaryFR();
            SoundPlayer.setDirectory("wav/fr");
        } else {
            PhysicApplet.phyDictionnary = new QuantaDictionnaryEN();
            SoundPlayer.setDirectory("wav/gb");
        }
    }

    protected boolean isLicenseValid() {
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.isLicenseValid()) {
            super.paint(graphics);
        } else {
            this.setBackground(Color.black);
            graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setColor(Color.white);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = "Quantum Physics Online cannot run from site";
            graphics.drawString(string, (this.getSize().width - fontMetrics.stringWidth(string)) / 2, this.getSize().height / 2 - 30);
            string = this.codeBase;
            graphics.drawString(string, (this.getSize().width - fontMetrics.stringWidth(string)) / 2, this.getSize().height / 2);
            string = "Contact manuel.joffre@wanadoo.fr for obtaining a valid license";
            graphics.drawString(string, (this.getSize().width - fontMetrics.stringWidth(string)) / 2, this.getSize().height / 2 + 30);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TOOLBAR ENABLE")) {
            this.enableToolBar();
        } else if (actionEvent.getActionCommand().equals("TOOLBAR DISABLE")) {
            this.disableToolBar();
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

