/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.ActionEvent;
import phy.quanta.HarmonicWindow;
import phy.quanta.QuantaApplet;

public class Quasicla
extends QuantaApplet {
    long speed = 50L;
    Button button;
    Label label;
    double theta;
    int thetaMax;
    int dx;
    int xVuport;
    int yVuport;
    int wVuport;
    int hVuport;
    double xW1;
    double xW2;
    double yW1;
    double yW2;
    double aX;
    double aY;
    int bX;
    int bY;
    int XA;
    int XB;
    int XC;
    int YA;
    int YB;
    int YC;
    int NNiveaux;
    int MaxNiveaux;
    double EMax;
    double xMax;
    double[] weight;
    double[][] phi;
    double[] x;
    double[] proba;
    int NPoints = 200;
    boolean repaintPartial = false;
    double xMean = 0.0;
    double eMean = 2.5;
    Image potImg = null;
    Graphics potGraphics;
    public Image offscreenImg = null;
    Graphics offscreenGraphics;
    boolean flagMouseDown = false;
    int iWeight = 0;
    boolean coherentMode = false;
    double maxScaleWeight = 0.5;
    boolean imageInvalid = true;
    HarmonicWindow harmonicWindow;

    public void SetVuport(int n, int n2, int n3, int n4) {
        this.xVuport = n;
        this.yVuport = n2;
        this.wVuport = n3;
        this.hVuport = n4;
    }

    public void SetWindow(double d, double d2, double d3, double d4) {
        this.xW1 = d;
        this.xW2 = d3;
        this.yW1 = d2;
        this.yW2 = d4;
        this.aX = (double)this.wVuport / (this.xW2 - this.xW1);
        this.bX = this.xVuport - (int)(this.xW1 * this.aX);
        this.aY = (double)this.hVuport / (this.yW1 - this.yW2);
        this.bY = this.yVuport - (int)(this.yW2 * this.aY);
    }

    public void PlotLine(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = (int)(d2 * this.aY + (double)this.bY);
        int n2 = (int)(d4 * this.aY + (double)this.bY);
        if (n < this.yVuport + this.hVuport) {
            graphics.drawLine((int)(d * this.aX + (double)this.bX), n, (int)(d3 * this.aX + (double)this.bX), n2);
        }
    }

    public void PlotPoly(Graphics graphics, double[] dArray, double[] dArray2) {
        int[] nArray = new int[dArray.length + 2];
        int[] nArray2 = new int[dArray.length + 2];
        nArray[0] = this.xVuport;
        nArray2[0] = this.bY;
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i + 1] = (int)Math.rint(dArray[i] * this.aX + (double)this.bX);
            nArray2[i + 1] = (int)Math.rint(dArray2[i] * this.aY + (double)this.bY);
        }
        nArray[dArray.length + 1] = this.xVuport + this.wVuport;
        nArray2[dArray.length + 1] = this.bY;
        graphics.fillPolygon(nArray, nArray2, nArray.length);
    }

    public void PlotBroadHLine(Graphics graphics, double d, double d2, double d3, int n) {
        int n2 = (int)(d3 * this.aY + (double)this.bY);
        if (n2 < this.yVuport + this.hVuport) {
            graphics.fillRect((int)(d * this.aX + (double)this.bX), n2 - n / 2, (int)((d2 - d) * this.aX), n);
        }
    }

    void initNNiveaux(int n) {
        this.NNiveaux = n;
        this.EMax = this.NNiveaux;
        this.xMax = Math.sqrt((double)2 * this.EMax) + 1.0;
        this.BuildPhi();
    }

    public void init() {
        super.init();
        this.initSimulator();
        this.getSimulator().getTimer().addActionListener(this);
        this.speed = 100L;
        this.thetaMax = 100;
        this.dx = 1;
        this.button = new Button("Pause");
        this.label = new Label();
        this.harmonicWindow = new HarmonicWindow(this);
        this.label.setText("<E> = 0.000");
        this.add(this.harmonicWindow);
        this.add(this.label);
        this.add(this.button);
        this.MaxNiveaux = 15;
        this.weight = new double[this.MaxNiveaux];
        this.phi = new double[this.MaxNiveaux][this.NPoints];
        this.x = new double[this.NPoints];
        this.proba = new double[this.NPoints];
        this.initNNiveaux(this.MaxNiveaux);
        for (int i = 0; i < this.NNiveaux; ++i) {
            this.weight[i] = 0.0;
        }
        this.weight[12] = 0.25;
        this.weight[11] = 0.25;
        this.weight[10] = 0.25;
        this.weight[9] = 0.25;
        this.ComputeProba();
    }

    public void start() {
        this.XA = 5;
        this.XB = this.getSize().width * 5 / 8;
        this.XC = this.getSize().width - 10;
        this.YA = 5;
        this.YB = this.getSize().height * 3 / 4;
        this.YC = this.getSize().height - 10;
        super.start();
    }

    public void BuildPhi() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.NPoints; ++n2) {
            this.phi[0][n2] = 1.0;
            this.proba[n2] = 1.0;
            this.x[n2] = -this.xMax + (double)2 * this.xMax * (double)n2 / (double)(this.NPoints - 1);
            this.phi[1][n2] = (double)2 * this.x[n2];
            for (n = 2; n < this.NNiveaux; ++n) {
                this.phi[n][n2] = (double)2 * this.x[n2] * this.phi[n - 1][n2] - (double)(2 * (n - 1)) * this.phi[n - 2][n2];
            }
        }
        double d = 1.0;
        for (n = 0; n < this.MaxNiveaux; ++n) {
            if (n > 0) {
                d *= (double)(2 * n);
            }
            for (n2 = 0; n2 < this.NPoints; ++n2) {
                double[] dArray = this.phi[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] * (Math.exp(-this.x[n2] * this.x[n2] / (double)2) / Math.sqrt(d) / (double)2);
            }
        }
    }

    void ComputeWeight() {
        double d;
        this.maxScaleWeight = 0.5;
        double d2 = Math.sqrt(this.eMean - 0.5);
        this.weight[0] = d = Math.exp(-d2 * d2);
        if (this.weight[0] > this.maxScaleWeight) {
            this.maxScaleWeight = 1.0;
        }
        double d3 = 1.0;
        double d4 = 1.0;
        for (int i = 1; i < this.NNiveaux; ++i) {
            d3 = d3 * d2 * d2;
            this.weight[i] = d * d3 / (d4 *= (double)i);
            if (!(this.weight[i] > this.maxScaleWeight)) continue;
            this.maxScaleWeight = 1.0;
        }
    }

    void normalizeWeight() {
        int n;
        double d = 0.0;
        this.maxScaleWeight = 0.5;
        for (n = 0; n < this.NNiveaux; ++n) {
            d += this.weight[n];
        }
        if (d > 0.0) {
            for (n = 0; n < this.NNiveaux; ++n) {
                int n2 = n;
                this.weight[n2] = this.weight[n2] / d;
                if (!(this.weight[n] > this.maxScaleWeight)) continue;
                this.maxScaleWeight = 1.0;
            }
        } else {
            this.weight[0] = 1.0;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME") && this.getSimulator().isRunning()) {
            this.theta += (double)2;
            if (this.theta > (double)this.thetaMax) {
                this.theta = 0.0;
            }
            this.ComputeProba();
            this.updatePanel();
            this.harmonicWindow.repaint();
        } else if (actionEvent.getSource() == this.button) {
            if (this.getSimulator().isRunning()) {
                this.button.setLabel("Start");
                this.getSimulator().pause();
            } else {
                this.button.setLabel("Pause");
                this.getSimulator().resume();
            }
        }
    }

    double Potentiel(double d) {
        return d * d / (double)2;
    }

    public void updatePanel() {
        if (this.potImg == null) {
            this.offscreenImg = this.createImage(this.XB - this.XA, this.YC - this.YA);
            this.offscreenGraphics = this.offscreenImg.getGraphics();
            this.potImg = this.createImage(this.XB - this.XA, this.YB - this.YA);
            this.potGraphics = this.potImg.getGraphics();
        }
        if (this.imageInvalid) {
            int n;
            this.SetVuport(0, 0, this.XB - this.XA, this.YB - this.YA);
            this.SetWindow(this.x[0], 0.0, this.x[this.NPoints - 1], this.EMax);
            this.potGraphics.setColor(this.getBackground());
            this.potGraphics.fillRect(0, 0, this.XB - this.XA, this.YC - this.YA);
            this.potGraphics.setColor(this.getForeground());
            for (n = 0; n < this.wVuport; n += this.dx) {
                double d = (double)(n - this.bX) / this.aX;
                double d2 = d + (double)this.dx / this.aX;
                this.PlotLine(this.potGraphics, d, this.Potentiel(d), d2, this.Potentiel(d2));
            }
            for (n = 0; n < this.NNiveaux; ++n) {
                this.PlotLine(this.potGraphics, this.xW1, (double)n + 0.5, this.xW2, (double)n + 0.5);
            }
            this.potGraphics.setColor(Color.green);
            for (n = 0; n < this.NNiveaux; ++n) {
                for (int i = 1; i < this.NPoints; ++i) {
                    this.PlotLine(this.potGraphics, this.x[i - 1], (double)n + 0.5 + this.phi[n][i - 1], this.x[i], (double)n + 0.5 + this.phi[n][i]);
                }
            }
            this.imageInvalid = false;
        }
        this.offscreenGraphics.drawImage(this.potImg, 0, 0, this);
        this.SetVuport(0, this.YB - this.YA, this.XB - this.XA, this.YC - this.YB);
        this.SetWindow(this.x[0], -0.1, this.x[this.NPoints - 1], 2.0);
        this.offscreenGraphics.setColor(this.getBackground());
        this.offscreenGraphics.fillRect(0, this.YB - this.YA, this.XB - this.XA, this.YC - this.YB);
        this.offscreenGraphics.setColor(this.getForeground());
        this.PlotPoly(this.offscreenGraphics, this.x, this.proba);
        this.SetVuport(0, 0, this.XB - this.XA, this.YB - this.YA);
        this.SetWindow(this.x[0], 0.0, this.x[this.NPoints - 1], this.EMax);
        this.offscreenGraphics.setColor(Color.yellow);
        double d = Math.sqrt((double)2 * this.eMean);
        this.offscreenGraphics.fillRect((int)(-this.aX * d + (double)this.bX), (int)(this.aY * this.eMean + (double)this.bY - 1.0), (int)(this.aX * (double)2 * d), 3);
        this.offscreenGraphics.setColor(Color.blue);
        this.offscreenGraphics.fillOval((int)(this.aX * this.xMean + (double)this.bX) - 10, (int)(this.aY * this.Potentiel(this.xMean) + (double)this.bY) - 10, 20, 20);
    }

    public void paint(Graphics graphics) {
        this.harmonicWindow.setBounds(this.XA, this.YA, this.XB - this.XA, this.YC - this.YA);
        this.label.setText(String.valueOf("<E> = ").concat(String.valueOf(Math.floor(this.eMean * (double)1000) / (double)1000)));
        this.label.setLocation(this.XB + 10, this.YB + 70);
        this.button.setLocation(this.XB + 20, this.YB + 40);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(Color.white);
        graphics.fillRect(0, n2 - 3, n, 3);
        graphics.fillRect(n - 3, 0, 3, n2 - 1);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.drawLine(1, 1, n - 2, 1);
        graphics.drawLine(2, 2, n - 3, 2);
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.drawLine(1, 1, 1, n2 - 2);
        graphics.drawLine(2, 2, 2, n2 - 3);
        graphics.setColor(this.getForeground());
        graphics.setColor(this.getBackground());
        graphics.fillRect(this.XB, this.YA, n - this.XB - 3, this.YB - this.YA);
        this.SetVuport(this.XB, this.YA, this.XC - this.XB, this.YB - this.YA);
        this.SetWindow(-this.maxScaleWeight / (double)10, 0.0, this.maxScaleWeight, this.EMax);
        graphics.setColor(Color.yellow);
        int n3 = (int)Math.abs(this.aY * 0.6) + 1;
        for (int i = 0; i < this.NNiveaux; ++i) {
            this.PlotBroadHLine(graphics, 0.0, this.weight[i], (double)i + 0.5, n3);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void ComputeProba() {
        if (this.coherentMode) {
            this.computeProbaCoherentState();
        } else {
            this.computeProbaAnyState();
        }
    }

    void computeProbaAnyState() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.NNiveaux; ++n) {
            d3 += this.weight[n];
            d4 += ((double)n + 0.5) * this.weight[n];
        }
        if (d3 == 0.0) {
            this.weight[0] = 1.0;
            d3 = 1.0;
            this.eMean = 0.5;
        } else {
            this.eMean = d4 / d3;
        }
        for (n = 0; n < this.NPoints; ++n) {
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i = 0; i < this.NNiveaux; ++i) {
                d5 += Math.sqrt(this.weight[i]) * this.phi[i][n] * Math.cos((double)i * this.theta / (double)this.thetaMax * (double)2 * Math.PI);
                d6 += Math.sqrt(this.weight[i]) * this.phi[i][n] * Math.sin((double)i * this.theta / (double)this.thetaMax * (double)2 * Math.PI);
            }
            this.proba[n] = (d5 * d5 + d6 * d6) * (double)3 / d3;
            d += this.proba[n];
            d2 += this.x[n] * this.proba[n];
        }
        this.xMean = d2 / d;
    }

    void computeProbaCoherentState() {
        this.xMean = Math.sqrt(this.eMean - 0.5) * Math.sqrt(2.0) * Math.cos(Math.PI * 2 * this.theta / (double)this.thetaMax);
        for (int i = 0; i < this.NPoints; ++i) {
            this.proba[i] = Math.exp(-(this.x[i] - this.xMean) * (this.x[i] - this.xMean));
            if (!(this.proba[i] < 1.0E-6)) continue;
            this.proba[i] = 0.0;
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (n < this.XB && n2 < this.YB) {
            this.iWeight = -1;
            this.flagMouseDown = true;
            this.theta = 0.0;
        } else if (n > this.XB && n2 < this.YB) {
            this.SetVuport(this.XB, this.YA, this.XC - this.XB, this.YB - this.YA);
            this.SetWindow(-this.maxScaleWeight / (double)10, 0.0, this.maxScaleWeight, this.EMax);
            this.iWeight = (int)Math.rint((double)(n2 - this.bY) / this.aY - 0.5);
            if (this.iWeight >= 0 && this.iWeight < this.NNiveaux) {
                this.flagMouseDown = true;
                this.theta = 0.0;
                double d = (double)(n - this.bX) / this.aX;
                this.weight[this.iWeight] = Math.max(0.0, Math.min(d, 1.0));
                this.ComputeProba();
                this.updatePanel();
                this.harmonicWindow.repaint();
            }
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.flagMouseDown) {
            if (this.iWeight < 0) {
                this.coherentMode = true;
                this.SetVuport(this.XA, this.YA, this.XB - this.XA, this.YB - this.YA);
                this.SetWindow(this.x[0], 0.0, this.x[this.NPoints - 1], this.EMax);
                double d = (double)(n2 - this.yVuport - this.bY) / this.aY;
                this.eMean = Math.min(this.EMax, Math.max(0.5, d));
                this.ComputeWeight();
                this.ComputeProba();
                this.updatePanel();
                this.repaint();
                this.harmonicWindow.repaint();
            } else {
                this.coherentMode = false;
                this.SetVuport(this.XB, this.YA, this.XC - this.XB, this.YB - this.YA);
                this.SetWindow(-this.maxScaleWeight / (double)10, 0.0, this.maxScaleWeight, this.EMax);
                double d = (double)(n - this.bX) / this.aX;
                this.weight[this.iWeight] = Math.max(0.0, Math.min(d, 1.0));
                this.ComputeProba();
                this.updatePanel();
                this.repaint();
                this.harmonicWindow.repaint();
            }
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.flagMouseDown = false;
        if (this.iWeight >= 0) {
            this.normalizeWeight();
            this.repaint();
        }
        return true;
    }
}

