/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.util.ActionEventSupport;

public class StationaryState
extends ActionEventSupport {
    protected double time = 0.0;
    protected long timeZero = 0L;
    protected double omega = 1.0;
    protected double re0 = 1.0;
    protected double im0 = 0.0;
    protected double re = 1.0;
    protected double im = 0.0;
    protected double phase = 0.0;

    public double getRe() {
        return this.re;
    }

    public double getIm() {
        return this.im;
    }

    public double getSqr() {
        return this.re * this.re + this.im * this.im;
    }

    public double getPhase() {
        return this.phase;
    }

    public void mul(double d) {
        this.re0 *= d;
        this.re *= d;
        this.im0 *= d;
        this.im *= d;
    }

    public void checkNormalisation() {
        this.fireActionEvent("CHECK");
        double d = Math.sqrt(this.getSqr());
        if (d > 1.0) {
            this.mul(1.0 / d);
        }
    }

    public void setRe(double d) {
        this.re = d;
        this.re0 = this.re * Math.cos(this.phase) + this.im * Math.sin(this.phase);
        this.checkNormalisation();
        this.fireActionEvent("UPDATE");
    }

    public void setIm(double d) {
        this.im = d;
        this.im0 = -this.re * Math.sin(this.phase) + this.im * Math.cos(this.phase);
        this.checkNormalisation();
        this.fireActionEvent("UPDATE");
    }

    public void setState(double d, double d2) {
        this.re = d;
        this.im = d2;
        this.re0 = this.re * Math.cos(this.phase) + this.im * Math.sin(this.phase);
        this.im0 = -this.re * Math.sin(this.phase) + this.im * Math.cos(this.phase);
        this.checkNormalisation();
        this.fireActionEvent("UPDATE");
    }

    public void setTimeZero(long l) {
        this.timeZero = l;
        this.re0 = this.re;
        this.im0 = this.im;
    }

    public void setTime(double d) {
        this.time = d;
        this.update();
    }

    public void update() {
        this.phase = -this.omega * (this.time / 16.0 * (double)2 * Math.PI) % (Math.PI * 2);
        this.re = this.re0 * Math.cos(this.phase) - this.im0 * Math.sin(this.phase);
        this.im = this.re0 * Math.sin(this.phase) + this.im0 * Math.cos(this.phase);
    }

    public void setOmega(double d) {
        this.omega = d;
    }
}

