/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.function.TabulatedFunctionV1;
import phy.graphe.BufferedPanel;
import phy.graphe.MultiFunctionViewer;
import phy.quanta.LarmorWindow;
import phy.quanta.PolarMultiViewer;
import phy.quanta.StationaryStateViewer;
import phy.quanta.SumFunction;
import phy.quanta.SumSquareFunction;
import phy.util.BackgroundPanel;
import phy.util.PhysicApplet;

public class SuperpositionViewer
extends BufferedPanel
implements ActionListener {
    int nStates = 2;
    StationaryStateViewer[] state = new StationaryStateViewer[this.nStates];
    protected MultiFunctionViewer viewer = new MultiFunctionViewer();
    PolarMultiViewer polarViewer;
    private LarmorWindow larmorWindow;

    public MultiFunctionViewer getViewer() {
        return this.viewer;
    }

    public SuperpositionViewer(StationaryStateViewer stationaryStateViewer, StationaryStateViewer stationaryStateViewer2) {
        TabulatedFunctionV1 tabulatedFunctionV1;
        TabulatedFunctionV1 tabulatedFunctionV12;
        this.viewer.setBackground(PhysicApplet.getDefaultBackground());
        if (stationaryStateViewer == null) {
            this.nStates = 1;
            this.state[0] = stationaryStateViewer2;
        } else if (stationaryStateViewer2 == null) {
            this.nStates = 1;
            this.state[0] = stationaryStateViewer;
        } else {
            this.state[0] = stationaryStateViewer;
            this.state[1] = stationaryStateViewer2;
        }
        if (this.nStates == 1) {
            tabulatedFunctionV12 = this.state[0].getFunctionRe();
            tabulatedFunctionV1 = this.state[0].getFunctionIm();
        } else {
            tabulatedFunctionV12 = new SumFunction(this.state[0].getFunctionRe(), this.state[1].getFunctionRe());
            tabulatedFunctionV1 = new SumFunction(this.state[0].getFunctionIm(), this.state[1].getFunctionIm());
            this.polarViewer = new PolarMultiViewer(this.state[0].getState(), this.state[1].getState());
        }
        SumSquareFunction sumSquareFunction = new SumSquareFunction(tabulatedFunctionV12, tabulatedFunctionV1);
        tabulatedFunctionV12.getXScaler().setBounds(0.0, 1.0);
        tabulatedFunctionV12.getYScaler().setBounds(-1.3, 1.3);
        tabulatedFunctionV1.getXScaler().setBounds(0.0, 1.0);
        tabulatedFunctionV1.getYScaler().setBounds(-1.3, 1.3);
        sumSquareFunction.getXScaler().setBounds(0.0, 1.0);
        sumSquareFunction.getYScaler().setBounds(3.0, 0.0);
        this.viewer.addCurve(sumSquareFunction, 1, Color.yellow);
        if (this.nStates > 1) {
            this.viewer.addCurve(tabulatedFunctionV12, 0, Color.green);
            this.viewer.addCurve(tabulatedFunctionV1, 0, Color.orange);
        }
        this.setLayout(new GridLayout(1, 3));
        this.add(this.viewer);
        BufferedPanel bufferedPanel = new BufferedPanel();
        bufferedPanel.setBackground(PhysicApplet.getDefaultBackground());
        this.add(bufferedPanel);
        if (this.nStates == 2) {
            this.add(this.polarViewer);
        } else {
            this.add(new BackgroundPanel(PhysicApplet.getDefaultBackground()));
        }
    }

    public void setTime(double d) {
        this.viewer.refresh();
        if (this.polarViewer != null) {
            this.polarViewer.repaint();
        }
        if (this.larmorWindow != null) {
            this.larmorWindow.setState(this.state[0].getState().getRe(), this.state[0].getState().getIm(), this.state[1].getState().getRe(), this.state[1].getState().getIm());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("CHECK") && this.nStates > 1) {
            double d = Math.sqrt(this.state[0].getState().getSqr() + this.state[1].getState().getSqr());
            if (d > 1.0) {
                this.state[0].getState().mul(1.0 / d);
                this.state[1].getState().mul(1.0 / d);
            }
            this.state[0].refreshAll();
            this.state[1].refreshAll();
        } else if (actionEvent.getActionCommand().equals("UPDATE")) {
            this.viewer.refresh();
            if (this.larmorWindow != null) {
                this.larmorWindow.setState(this.state[0].getState().getRe(), this.state[0].getState().getIm(), this.state[1].getState().getRe(), this.state[1].getState().getIm());
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

