/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Graphics;
import phy.control.HotPoint;
import phy.dynaplot.PlotDataSet;
import phy.dynaplot.PlotWindow;
import phy.quanta.HermiteDecomposition;
import phy.quanta.HermitePolynomials;
import phy.quanta.WeightTuner;
import phy.util.MathTools;

public class TailorFunctionWindow
extends PlotWindow {
    int functionType = 1;
    double functionCenter = 0.0;
    double functionWidth = 3.0;
    int currentState = 0;
    HermiteDecomposition applet;
    protected double functionAmplitude = 1.0;
    String mode;
    protected Color color1 = Color.green;
    protected Color color2 = Color.lightGray;
    protected Color color3 = Color.lightGray;
    protected boolean hermiteComponentShown = true;

    void setFunctionType(int n) {
        this.functionType = n;
    }

    void setFunctionCenter(double d) {
        this.functionCenter = d;
    }

    double getFunctionCenter() {
        return this.functionCenter;
    }

    void setFunctionWidth(double d) {
        if (d > 0.05) {
            this.functionWidth = d;
        }
    }

    double getFunctionWidth() {
        return this.functionWidth;
    }

    public void setFunctionAmplitude(double d) {
        this.functionAmplitude = d;
    }

    public double getFunctionAmplitude() {
        return this.functionAmplitude;
    }

    void computeDataSet() {
        if (!this.mode.equals("fit")) {
            return;
        }
        switch (this.functionType) {
            case 0: {
                for (int i = 0; i < this.dataSet.getNPoints(); ++i) {
                    this.dataSet.zData[1][i] = Math.abs(this.dataSet.X(i) - this.functionCenter) < this.functionWidth / (double)2 ? this.functionAmplitude : 0.0;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.dataSet.getNPoints(); ++i) {
                    this.dataSet.zData[1][i] = Math.abs(this.dataSet.X(i) - this.functionCenter) < this.functionWidth / (double)2 ? (1.0 - (double)2 * Math.abs(this.dataSet.X(i) - this.functionCenter) / this.functionWidth) * this.functionAmplitude : 0.0;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.dataSet.getNPoints(); ++i) {
                    double d = (this.dataSet.X(i) - this.functionCenter) / this.functionWidth * (double)5;
                    this.dataSet.zData[1][i] = this.functionAmplitude * Math.exp(-d * d / (double)2);
                }
                break;
            }
        }
    }

    TailorFunctionWindow(HermiteDecomposition hermiteDecomposition, String string) {
        this.applet = hermiteDecomposition;
        this.mode = string;
        this.graphics.setWindow(-10.0, -1.5, 10.0, 1.5);
        this.dataSet = string.equals("fit") ? new PlotDataSet(2, 200) : new PlotDataSet(1, 200);
        this.dataSet.FillX(-10.0, 10.0);
        this.computeDataSet();
    }

    void drawHorizontalDoubleArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.magenta);
        graphics.fillPolygon(new int[]{n - 10, n - 28, n - 10, n - 10, n + 10, n + 10, n + 28, n + 10, n + 10, n - 10}, new int[]{n2 - 10, n2, n2 + 10, n2 + 4, n2 + 4, n2 + 10, n2, n2 - 10, n2 - 4, n2 - 4}, 10);
    }

    void drawVerticalDoubleArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.magenta);
        graphics.fillPolygon(new int[]{n - 10, n, n + 10, n + 4, n + 4, n + 10, n, n - 10, n - 4, n - 4}, new int[]{n2 - 10, n2 - 28, n2 - 10, n2 - 10, n2 + 10, n2 + 10, n2 + 28, n2 + 10, n2 + 10, n2 - 10}, 10);
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        if (this.mode.equals("fit")) {
            this.getHotSpotVector().addElement(new HotPoint(this.xScreen(this.functionCenter), this.yScreen(1.0), 0));
            this.getHotSpotVector().addElement(new HotPoint(this.xScreen(this.functionCenter + this.functionWidth / (double)2), this.yScreen(0.0), 1));
        }
    }

    public void hotSpotHasMoved(int n) {
        double d = this.xUser(this.getCurrentHotSpot().getX());
        double d2 = this.yUser(this.getCurrentHotSpot().getY());
        switch (n) {
            case 0: {
                this.setFunctionCenter(d);
                this.setFunctionAmplitude(MathTools.minMax(d2, 0.2, 1.8));
                break;
            }
            case 1: {
                this.setFunctionWidth((double)2 * (d - this.functionCenter));
            }
        }
        this.getHotSpot(0).setXY(this.xScreen(this.functionCenter), this.yScreen(this.functionAmplitude));
        this.getHotSpot(1).setXY(this.xScreen(this.functionCenter + this.functionWidth / (double)2), this.yScreen(0.0));
        this.computeDataSet();
        this.applet.doFitIfNeeded();
        this.refresh();
    }

    public void setColor1(Color color) {
        this.color1 = color;
    }

    public void setColor2(Color color) {
        this.color2 = color;
    }

    public void setColor3(Color color) {
        this.color3 = color;
    }

    public boolean setCurveColor(int n) {
        if (n == 0) {
            if (this.color1 == null) {
                return false;
            }
            this.graphics.setColor(this.color1);
        } else {
            if (this.color2 == null) {
                return false;
            }
            this.graphics.setColor(this.color2);
        }
        return true;
    }

    public void computeHermiteSum(WeightTuner weightTuner, HermitePolynomials hermitePolynomials) {
        for (int i = 0; i < this.dataSet.getNPoints(); ++i) {
            this.dataSet.zData[0][i] = 0.0;
            for (int j = 0; j < weightTuner.getNPoints(); ++j) {
                double[] dArray = this.dataSet.zData[0];
                int n = i;
                dArray[n] = dArray[n] + weightTuner.getWeight(j) * hermitePolynomials.phi[j][i];
            }
        }
    }

    public void setHermiteComponentShown(boolean bl) {
        this.hermiteComponentShown = bl;
    }

    public boolean isHermiteComponentShown() {
        return this.hermiteComponentShown;
    }

    public void paintCorePlot() {
        if (this.currentState >= 0 && this.isHermiteComponentShown()) {
            this.graphics.setColor(Color.lightGray);
            double[] dArray = new double[this.dataSet.nPoints + 2];
            double[] dArray2 = new double[this.dataSet.nPoints + 2];
            dArray[0] = this.dataSet.X(0);
            dArray[this.dataSet.nPoints + 1] = this.dataSet.X(this.dataSet.nPoints - 1);
            dArray2[this.dataSet.nPoints + 1] = 0.0;
            dArray2[0] = 0.0;
            for (int i = 0; i < this.dataSet.nPoints; ++i) {
                dArray[i + 1] = this.dataSet.X(i);
                dArray2[i + 1] = this.applet.hermitePolynomials.phi[this.currentState][i];
                if (!this.applet.tuner.isMouseDown()) continue;
                int n = i + 1;
                dArray2[n] = dArray2[n] * this.applet.tuner.getWeight(this.currentState);
            }
            this.graphics.setColor(this.color3);
            this.graphics.fillPolygon(dArray, dArray2);
            this.graphics.drawStringRT(String.valueOf("n=").concat(String.valueOf(this.currentState)), 9.5, 1.4);
        }
        super.paintCorePlot();
    }

    public void setCurrentState(int n) {
        this.currentState = n;
        this.repaint();
    }
}

