/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

class VumeterPanel
extends Canvas {
    int width;
    int height;
    int x0;
    int y0;
    int r;
    double value = 0.0;
    Image offscreenImg;
    Graphics offscreenG;

    VumeterPanel() {
    }

    void setValue(double d) {
        this.value = Math.max(0.0, Math.min(1.0, d));
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void drawArrow(Graphics graphics, Point point, Point point2) {
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        float f = point2.x - point.x;
        float f2 = point2.y - point.y;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if (f3 > (float)10) {
            Point point3 = new Point(point2.x, point2.y);
            Point point4 = new Point(point2.x, point2.y);
            int n = 15;
            if (this.getSize().width < 250) {
                n = 10;
            }
            float f4 = (float)Math.cos(0.39269908169872414);
            float f5 = (float)Math.sin(0.39269908169872414);
            point3.x = (int)((float)point3.x + (float)n * (-f4 * f + f5 * f2) / f3);
            point3.y = (int)((float)point3.y + (float)n * (-f5 * f - f4 * f2) / f3);
            point4.x = (int)((float)point4.x + (float)n * (-f4 * f - f5 * f2) / f3);
            point4.y = (int)((float)point4.y + (float)n * (f5 * f - f4 * f2) / f3);
            int[] nArray = new int[]{point2.x, point3.x, point4.x};
            int[] nArray2 = new int[]{point2.y, point3.y, point4.y};
            graphics.fillPolygon(nArray, nArray2, 3);
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreenImg == null || this.width != this.getSize().width || this.height != this.getSize().height) {
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            this.x0 = this.width / 2;
            this.r = Math.min(this.width / 2, this.height);
            this.y0 = Math.max(this.height / 2, this.r);
            this.offscreenImg = this.createImage(this.width, this.height);
            this.offscreenG = this.offscreenImg.getGraphics();
        }
        this.offscreenG.setColor(this.getBackground());
        this.offscreenG.fillRect(0, 0, this.width, this.height);
        this.offscreenG.setColor(new Color(0, 80, 120));
        this.offscreenG.fillArc((int)((double)this.x0 - (double)this.r * 0.9), (int)((double)this.y0 - (double)this.r * 0.9), (int)((double)(2 * this.r) * 0.9), (int)((double)(2 * this.r) * 0.9), 45, 90);
        this.offscreenG.setColor(new Color(160, 160, 160));
        this.offscreenG.fillArc((int)((double)this.x0 - (double)this.r * 0.8), (int)((double)this.y0 - (double)this.r * 0.8), (int)((double)(2 * this.r) * 0.8), (int)((double)(2 * this.r) * 0.8), 45, 90);
        this.offscreenG.setColor(Color.white);
        this.offscreenG.drawArc((int)((double)this.x0 - (double)this.r * 0.9), (int)((double)this.y0 - (double)this.r * 0.9), (int)((double)(2 * this.r) * 0.9), (int)((double)(2 * this.r) * 0.9), 45, 90);
        this.offscreenG.drawArc((int)((double)this.x0 - (double)this.r * 0.1), (int)((double)this.y0 - (double)this.r * 0.1), (int)((double)(2 * this.r) * 0.1), (int)((double)(2 * this.r) * 0.1), 45, 90);
        this.offscreenG.drawLine(this.x0, this.y0, (int)((double)this.x0 + (double)this.r * 0.9 / Math.sqrt(2.0)), (int)((double)this.y0 - (double)this.r * 0.9 / Math.sqrt(2.0)));
        this.offscreenG.drawLine(this.x0, this.y0, (int)((double)this.x0 - (double)this.r * 0.9 / Math.sqrt(2.0)), (int)((double)this.y0 - (double)this.r * 0.9 / Math.sqrt(2.0)));
        for (int i = 0; i <= 10; ++i) {
            this.offscreenG.drawLine((int)((double)this.x0 + (double)this.r * 0.85 * Math.sin(((double)i - 5.0) / (double)10 * Math.PI / (double)2)), (int)((double)this.y0 - (double)this.r * 0.85 * Math.cos(((double)i - 5.0) / (double)10 * Math.PI / (double)2)), (int)((double)this.x0 + (double)this.r * 0.9 * Math.sin(((double)i - 5.0) / (double)10 * Math.PI / (double)2)), (int)((double)this.y0 - (double)this.r * 0.9 * Math.cos(((double)i - 5.0) / (double)10 * Math.PI / (double)2)));
        }
        double d = (this.value - 0.5) * Math.PI / (double)2;
        this.offscreenG.setColor(Color.red);
        this.drawArrow(this.offscreenG, new Point(this.x0, this.y0), new Point((int)((double)this.x0 + (double)this.r * 0.9 * Math.sin(d)), (int)((double)this.y0 - (double)this.r * 0.9 * Math.cos(d))));
        this.offscreenG.setColor(this.getBackground());
        this.offscreenG.fillArc((int)((double)this.x0 - (double)this.r * 0.1), (int)((double)this.y0 - (double)this.r * 0.1), (int)((double)(2 * this.r) * 0.1), (int)((double)(2 * this.r) * 0.1), 30, 120);
        this.offscreenG.setColor(this.getForeground());
        this.offscreenG.drawArc((int)((double)this.x0 - (double)this.r * 0.1), (int)((double)this.y0 - (double)this.r * 0.1), (int)((double)(2 * this.r) * 0.1), (int)((double)(2 * this.r) * 0.1), 45, 90);
        graphics.drawImage(this.offscreenImg, 0, 0, this);
    }
}

