/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import phy.control.HotPoint;
import phy.graphe.BufferedPanel;
import phy.quanta.HermiteDecomposition;
import phy.util.DoublePoint;

public class WeightTuner
extends BufferedPanel {
    int nPoints;
    int maxNPoints = 200;
    double[] data = new double[this.maxNPoints];
    double maxValue = 1.0;
    double minValue = -1.0;
    HermiteDecomposition applet;

    WeightTuner(HermiteDecomposition hermiteDecomposition) {
        this.applet = hermiteDecomposition;
        this.nPoints = 5;
        this.data[0] = 1.0;
        this.graphics.setXAxis(-1.0, 6.0);
        this.graphics.setYAxis(-1.0, 1.0);
        this.graphics.setHMargin(10);
        this.graphics.setVMargin(20);
    }

    public void setNPoints(int n) {
        this.nPoints = Math.min(n, this.maxNPoints);
        this.graphics.setXAxis(-1.0, this.nPoints + 1);
        this.initHotSpots();
    }

    public int getNPoints() {
        return this.nPoints;
    }

    double getWeight(int n) {
        return this.data[n];
    }

    public void setWeight(int n, double d) {
        this.data[n] = d;
        this.getHotSpotVector().getHotSpot(n).setXY(this.xScreen(n), this.yScreen(this.data[n]));
    }

    public void paintCore() {
        this.graphics.setClipping(false);
        this.graphics.clear();
        this.graphics.setColor(Color.white);
        this.graphics.drawArrow(new DoublePoint(-1.0, 0.0), new DoublePoint(this.nPoints + 1, 0.0), 10);
        this.graphics.drawArrow(new DoublePoint(0.0, -1.0), new DoublePoint(0.0, 1.0 + (double)15 * this.graphics.getVPixel()), 10);
        this.graphics.drawTeX("C_n", new DoublePoint((double)-5 * this.graphics.getHPixel(), 1.0 + (double)19 * this.graphics.getVPixel()), 5);
        this.graphics.drawTeX("n", new DoublePoint(this.nPoints + 1, (double)5 * this.graphics.getVPixel()), 2);
        this.graphics.setClipping(true);
        this.graphics.setColor(Color.white);
        this.graphics.drawLine(this.graphics.getX1(), 0.0, this.graphics.getX2(), 0.0);
        for (int i = 0; i < this.nPoints; ++i) {
            int n;
            int n2;
            int n3 = Math.abs(this.yScreen(this.data[i]) - this.yScreen(0.0));
            int n4 = Math.max(Math.min(20, this.xScreen(1.0) - this.xScreen(0.0)), 1);
            if (this.data[i] >= 0.0) {
                n2 = this.xScreen(i) - n4 / 2;
                n = this.yScreen(this.data[i]);
                this.graphics.setColor(Color.green);
                this.graphics.getGraphics().fillRect(n2, n, n4, n3);
                continue;
            }
            n2 = this.xScreen(i) - n4 / 2;
            n = this.yScreen(0.0);
            this.graphics.setColor(Color.green);
            this.graphics.getGraphics().fillRect(n2, n, n4, n3);
        }
        this.graphics.setColor(Color.red);
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        for (int i = 0; i < this.nPoints; ++i) {
            this.getHotSpotVector().addElement(new HotPoint(this.xScreen(i), this.yScreen(this.data[i]), 2));
        }
    }

    public void hotSpotHasMoved(int n) {
        this.data[n] = this.yUser(this.getCurrentHotSpot().getY());
        this.repaint();
        this.applet.functionWindow.computeHermiteSum(this, this.applet.hermitePolynomials);
        this.applet.functionWindow.refresh();
    }

    public void hotSpotApproached() {
        this.applet.functionWindow.setCurrentState(this.getCurrentHotSpotIndex());
    }
}

