/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import phy.control.NavigationPanel;
import phy.quanta.QuantaApplet;
import phy.quanta.YoungPanel;
import phy.util.CrackedString;
import phy.util.PhysicApplet;
import phy.util.Timer;

public class Young
extends QuantaApplet
implements ItemListener {
    YoungPanel youngPanel;
    Choice choiceTaux;
    Choice choiceFranges;
    Button resetButton;
    Button pauseButton;
    boolean firstTime = true;

    public void setTaux(int n) {
        this.choiceTaux.select(String.valueOf("").concat(String.valueOf(n)));
        this.youngPanel.setRate(Double.valueOf(this.choiceTaux.getSelectedItem()));
    }

    public void init() {
        super.init();
        double d = 30.0;
        int n = 4;
        int n2 = this.getParameter("tailleAtomes", 1);
        this.setLayout(new BorderLayout());
        this.choiceTaux = new Choice();
        this.choiceTaux.addItem("10");
        this.choiceTaux.addItem("30");
        this.choiceTaux.addItem("100");
        this.choiceTaux.addItem("300");
        this.choiceTaux.addItem("1000");
        this.choiceTaux.addItemListener(this);
        this.choiceTaux.select("100");
        this.choiceFranges = new Choice();
        this.choiceFranges.addItem("1");
        this.choiceFranges.addItem("2");
        this.choiceFranges.addItem("3");
        this.choiceFranges.addItem("4");
        this.choiceFranges.addItem("5");
        this.choiceFranges.addItem("6");
        this.choiceFranges.addItem("7");
        this.choiceFranges.addItem("8");
        this.choiceFranges.addItem("9");
        this.choiceFranges.addItem("10");
        this.choiceFranges.addItemListener(this);
        this.choiceFranges.select("4");
        this.setToolBar(new NavigationPanel());
        this.pauseButton = new Button("Pause");
        this.getToolBar().add(this.pauseButton);
        this.pauseButton.addActionListener(this);
        this.resetButton = new Button("Reset");
        this.getToolBar().add(this.resetButton);
        this.resetButton.addActionListener(this);
        this.getToolBar().add(new Label(String.valueOf(PhysicApplet.getWord("Rate")).concat(String.valueOf(" [s^-1]")), 2));
        this.getToolBar().add(this.choiceTaux);
        this.getToolBar().add(new Label(PhysicApplet.getWord("NFringes"), 2));
        this.getToolBar().add(this.choiceFranges);
        Panel panel = new Panel();
        GridLayout gridLayout = new GridLayout(2, 1);
        gridLayout.setVgap(10);
        panel.setLayout(gridLayout);
        this.youngPanel = new YoungPanel(d, n);
        this.youngPanel.useMouse = false;
        this.youngPanel.leftInset = 40;
        this.youngPanel.rightInset = 40;
        this.youngPanel.atomSize = n2;
        panel.add(this.youngPanel);
        panel.add(this.youngPanel.getPlotWindow());
        this.add("Center", panel);
        this.add("South", this.getToolBar());
        this.timer = new Timer(String.valueOf("").concat(String.valueOf(this)));
        this.timer.addActionListener(this);
    }

    public void resetExperiment() {
        this.youngPanel.reset();
        this.youngPanel.getPlotWindow().setYAxis(0.0, 0.5);
    }

    public void resume() {
        this.youngPanel.resume();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME")) {
            this.youngPanel.repaint();
            if (this.youngPanel.maxCount > this.youngPanel.getPlotWindow().getY2()) {
                this.youngPanel.getPlotWindow().setYAxis(0.0, 1.8 * this.youngPanel.maxCount);
            }
            this.youngPanel.getPlotWindow().setTitle(String.valueOf(String.valueOf(PhysicApplet.getWord("NShotsTotal")).concat(String.valueOf(" : "))).concat(String.valueOf(this.youngPanel.nAtoms)));
            this.youngPanel.getPlotWindow().refresh();
        } else if (actionEvent.getSource() == this.resetButton) {
            this.resetExperiment();
        } else if (actionEvent.getSource() == this.pauseButton) {
            if (this.pauseButton.getLabel().equals("Pause")) {
                this.youngPanel.pause();
                this.pauseButton.setLabel("Start");
            } else {
                this.youngPanel.resume();
                this.pauseButton.setLabel("Pause");
            }
        } else if (actionEvent.getActionCommand().startsWith("SHOW_RATE ")) {
            if (CrackedString.getField(actionEvent.getActionCommand(), 1).equals("ON")) {
                this.choiceTaux.setBackground(Color.yellow);
            } else {
                this.choiceTaux.setBackground(Color.white);
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choiceTaux) {
            this.youngPanel.setRate(Double.valueOf(this.choiceTaux.getSelectedItem()));
        } else if (itemEvent.getSource() == this.choiceFranges) {
            this.youngPanel.setFranges(Integer.valueOf(this.choiceFranges.getSelectedItem()));
            this.youngPanel.getPlotWindow().setYAxis(0.0, 0.5);
        }
    }
}

