/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

import java.awt.Color;

public class ColorScale {
    public static final int COLOR = 0;
    public static final int GRAY = 1;
    protected static int mode = 0;
    public static final int BLACK = 0;
    public static final int WHITE = 1;
    protected static float[] tabWavelength = new float[]{400.0f, 420.0f, 495.0f, 520.0f, 570.0f, 600.0f, 620.0f, 640.0f, 800.0f};
    protected static float[] tabHue = new float[]{190.0f, 160.0f, 120.0f, 80.0f, 40.0f, 20.0f, 14.0f, 10.0f, 0.0f};

    public static void setMode(int n) {
        mode = n;
    }

    public static int doubleToColorIndex(double d) {
        return ColorScale.doubleToColorIndex(d, 0);
    }

    public static int doubleToColorIndex(double d, int n) {
        int n2 = (int)(Math.abs(d) * (double)255);
        n2 = Math.min(n2, 255);
        int n3 = 255 - n2;
        if (mode == 1) {
            return 0xFF000000 | n2 << 16 | n2 << 8 | n2;
        }
        if (d > 0.0) {
            return 0xFF000000 | n2 << 8 | n * n3 | n * n3 << 16;
        }
        return 0xFF000000 | n2 << 16 | n * n3 | n * n3 << 8;
    }

    public static Color doubleToColor(double d) {
        return new Color(ColorScale.doubleToColorIndex(d, 0));
    }

    public static Color doubleToColor(double d, int n) {
        return new Color(ColorScale.doubleToColorIndex(d, n));
    }

    public static int wavelengthToColorIndex(double d) {
        return Color.HSBtoRGB(ColorScale.wavelengthToHue(d), 1.0f, 1.0f);
    }

    public static int wavelengthToColorIndex(double d, double d2) {
        d2 = Math.pow(d2, 0.2);
        return Color.HSBtoRGB(ColorScale.wavelengthToHue(d), 1.0f, (float)d2);
    }

    public static Color wavelengthToColor(double d) {
        return Color.getHSBColor(ColorScale.wavelengthToHue(d), 1.0f, 1.0f);
    }

    public static float wavelengthToHue(double d) {
        float f;
        int n = tabHue.length;
        if (d < (double)tabWavelength[0]) {
            f = tabHue[0];
        } else if (d > (double)tabWavelength[n - 1]) {
            f = tabHue[n - 1];
        } else {
            int n2 = 0;
            int n3 = n - 1;
            while (n3 > n2 + 1) {
                int n4 = (n2 + n3) / 2;
                if (d < (double)tabWavelength[n4]) {
                    n3 = n4;
                    continue;
                }
                n2 = n4;
            }
            float f2 = ((float)d - tabWavelength[n2]) / (tabWavelength[n3] - tabWavelength[n2]);
            f = tabHue[n2] * (1.0f - f2) + tabHue[n3] * f2;
        }
        return f / (float)240;
    }
}

