/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

public final class Complex {
    public double re;
    public double im;

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double d) {
        this(d, 0.0);
    }

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public Complex(Complex complex) {
        this(complex.re, complex.im);
    }

    public Complex add(Complex complex) {
        return Complex.add(this, complex);
    }

    public Complex mul(Complex complex) {
        return Complex.mul(this, complex);
    }

    public Complex mul(double d) {
        return Complex.mul(this, d);
    }

    public Complex addPhase(double d) {
        return Complex.mul(this, Complex.expI(d));
    }

    public double abs() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public double arg() {
        return Math.atan2(this.re, this.im);
    }

    public double sqr() {
        return this.re * this.re + this.im * this.im;
    }

    public Complex inv() {
        return new Complex(this.re / this.sqr(), -this.im / this.sqr());
    }

    public Complex conj() {
        return Complex.conj(this);
    }

    public static Complex add(Complex complex, Complex complex2) {
        return new Complex(complex.re + complex2.re, complex.im + complex2.im);
    }

    public static Complex sub(Complex complex, Complex complex2) {
        return new Complex(complex.re - complex2.re, complex.im - complex2.im);
    }

    public static Complex mul(Complex complex, Complex complex2) {
        return new Complex(complex.re * complex2.re - complex.im * complex2.im, complex.re * complex2.im + complex.im * complex2.re);
    }

    public static Complex mul(Complex complex, double d) {
        return new Complex(complex.re * d, complex.im * d);
    }

    public static Complex expI(double d) {
        return new Complex(Math.cos(d), Math.sin(d));
    }

    public static Complex conj(Complex complex) {
        return new Complex(complex.re, -complex.im);
    }

    public static Complex polarComplex(double d, double d2) {
        return new Complex(d * Math.cos(d2), d * Math.sin(d2));
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("[").concat(String.valueOf(this.re))).concat(String.valueOf(","))).concat(String.valueOf(this.im))).concat(String.valueOf("]"));
    }
}

