/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

import java.util.Vector;
import phy.util.DataPoint;

public class DataSequence {
    public static int FIXED = 0;
    public static int SCROLLING = 1;
    protected int mode = FIXED;
    protected Vector vector = new Vector();
    protected double timeStep;
    protected double timeOrigin = 0.0;
    protected int firstIndex = 0;
    protected int maxSize = 1000;
    int lastIndex = -1;

    public void setScrollingMode(int n) {
        this.mode = n;
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(double d) {
        this.timeStep = d;
    }

    public int size() {
        return this.vector.size();
    }

    public double getTimeOrigin() {
        return this.timeOrigin;
    }

    public double getTime(int n) {
        return this.timeOrigin + this.timeStep * (double)n;
    }

    public double getTimeEnd() {
        return this.getTime(this.lastIndex);
    }

    public double getTimeNext() {
        return this.getTime(this.lastIndex + 1);
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.firstIndex + this.size() - 1;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public boolean isFull() {
        return this.size() >= this.getMaxSize() && this.mode == FIXED;
    }

    public DataSequence(double d) {
        this();
        this.timeStep = d;
    }

    public DataSequence() {
    }

    public void reset() {
        this.vector.removeAllElements();
        this.firstIndex = 0;
        this.lastIndex = -1;
    }

    public DataPoint getDataPoint(int n) {
        return (DataPoint)this.vector.elementAt(n - this.firstIndex);
    }

    public double getData(String string, int n) {
        return this.getDataPoint(n).get(string);
    }

    public void putDataPoint(DataPoint dataPoint) {
        if (this.size() >= this.maxSize) {
            if (this.mode == FIXED) {
                return;
            }
            this.vector.removeElementAt(0);
            ++this.firstIndex;
        }
        this.vector.addElement(dataPoint);
        ++this.lastIndex;
    }

    public double getInterpolatedData(String string, double d) {
        double d2 = (d - this.timeOrigin) / this.timeStep;
        int n = (int)Math.floor(d2);
        if (d2 == (double)n) {
            return this.getData(string, n);
        }
        return this.getData(string, n) * ((double)(n + 1) - d2) + this.getData(string, n + 1) * (d2 - (double)n);
    }
}

