/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

import phy.util.MathTools;

public class DoublePoint {
    public double x;
    public double y;

    public DoublePoint(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public DoublePoint(DoublePoint doublePoint) {
        this.x = doublePoint.x;
        this.y = doublePoint.y;
    }

    public DoublePoint(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this(doublePoint2);
        this.sub(doublePoint);
    }

    public DoublePoint() {
        this(0.0, 0.0);
    }

    public void sub(DoublePoint doublePoint) {
        this.x -= doublePoint.x;
        this.y -= doublePoint.y;
    }

    public void add(DoublePoint doublePoint) {
        this.x += doublePoint.x;
        this.y += doublePoint.y;
    }

    public void mul(double d) {
        this.x *= d;
        this.y *= d;
    }

    public void addAndAverage(DoublePoint doublePoint, double d) {
        this.x = this.x * (1.0 - d) + doublePoint.x * d;
        this.y = this.y * (1.0 - d) + doublePoint.y * d;
    }

    public double distanceTo(DoublePoint doublePoint) {
        return Math.sqrt(MathTools.sqr(this.x - doublePoint.x) + MathTools.sqr(this.y - doublePoint.y));
    }

    public double length() {
        return Math.sqrt(this.sqr());
    }

    public void normalize() {
        double d = this.length();
        if (d > 0.0) {
            this.x /= d;
            this.y /= d;
        }
    }

    public double sqr() {
        return MathTools.sqr(this.x) + MathTools.sqr(this.y);
    }

    public static double scalarProduct(DoublePoint doublePoint, DoublePoint doublePoint2) {
        return doublePoint.x * doublePoint2.x + doublePoint.y * doublePoint2.y;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf("[").concat(String.valueOf(this.x))).concat(String.valueOf(","))).concat(String.valueOf(this.y))).concat(String.valueOf("]"));
    }
}

