/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import phy.acq.Simulator;
import phy.control.PhyButton;
import phy.graphe.BufferedPanel;
import phy.util.ActionEventSupport;
import phy.util.CrackedString;
import phy.util.FileToolkit;
import phy.util.PhyDictionnary;
import phy.util.PhyTools;
import phy.util.SoundPlayer;
import phy.util.TimeEvent;
import phy.util.TimeLine;
import phy.util.TimeObserver;
import phy.util.Timer;

public class PhysicApplet
extends AbstractPhysicApplet
implements PropertyChangeListener,
TimeObserver,
WindowListener {
    protected Image offscreenImage;
    public static final int SLOW = 1;
    public static final int STANDARD = 2;
    public static final int FAST = 3;
    protected static int computerSpeed = 2;
    protected static int counterMeasurementSpeed = 0;
    protected static long totalMeasurementTime = 0L;
    protected ActionListener defaultListener;
    protected transient Simulator simulator;
    public static final transient int DONE = -1;
    public static final transient int JUST_STARTED = 0;
    public static final transient int STEP1 = 1;
    public static final transient int STEP2 = 2;
    public static final transient int STEP3 = 3;
    public static final transient int STEP4 = 4;
    public static final transient int STEP5 = 5;
    protected transient int state = 0;
    protected PhyButton playButton;
    protected transient String mode = "";
    protected transient Hashtable table;
    protected static transient String language = "FR";
    protected static transient boolean standalone = true;
    protected static Color defaultBackground = new Color(0, 80, 120);
    protected static Font defaultFont = new Font("SansSerif", 0, 12);
    protected boolean rewindable = true;
    protected String codeBase = "";
    protected boolean started = false;
    transient ActionEventSupport actionEventSupport = new ActionEventSupport(this);
    protected int xRemoteMouse = 0;
    protected int yRemoteMouse = 0;
    protected transient TimeLine timeLine = new TimeLine(this);
    protected transient Timer timer;
    protected Hashtable flagTable = new Hashtable();
    protected Image backgroundImage;
    protected String backgroundImageName;
    protected String qcmStatus = "XXXXXXXXXXXXX";
    protected boolean autoEnableQCM = true;
    protected boolean qcmEnabled = false;
    protected static PhyDictionnary phyDictionnary;

    public static int getComputerSpeed() {
        return computerSpeed;
    }

    protected void measureComputerSpeed() {
        if (counterMeasurementSpeed < 10) {
            double d = 1.0;
            long l = System.currentTimeMillis();
            for (int i = 0; i < 100000; ++i) {
                d = Math.sin(d * 3187.54 + Math.sqrt(Math.abs(d)));
            }
            l = System.currentTimeMillis() - l;
            if (counterMeasurementSpeed > 0) {
                totalMeasurementTime += l;
                l = totalMeasurementTime / (long)counterMeasurementSpeed;
            }
            computerSpeed = l > (long)150 ? 1 : (l < (long)100 ? 3 : 2);
            String string = String.valueOf("").concat(String.valueOf(l));
            if (l == (long)0) {
                string = "<50";
            }
            PhyTools.issueMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Test de temps de calcul : ").concat(String.valueOf(string))).concat(String.valueOf(" ms ["))).concat(String.valueOf(computerSpeed))).concat(String.valueOf("]")));
            if (d < (double)2) {
                ++counterMeasurementSpeed;
            }
        }
    }

    public void setDefaultListener(ActionListener actionListener) {
        this.defaultListener = actionListener;
    }

    public ActionListener getDefaultListener() {
        return this.defaultListener;
    }

    public void addAppletListener(ActionListener actionListener) {
        this.defaultListener = AWTEventMulticaster.add(this.defaultListener, actionListener);
    }

    public void initSimulator() {
        this.setSimulator(new Simulator());
        this.timer = new Timer(this.getSimulator(), String.valueOf("").concat(String.valueOf(this)));
        this.getSimulator().setTimer(this.timer);
    }

    public void setSimulator(Simulator simulator) {
        this.simulator = simulator;
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public void setState(int n) {
        if (this.state != n) {
            this.state = n;
            if (this.state == -1) {
                this.enableQCM();
                this.fireActionEvent("DONE");
                System.out.println("DONE sent !");
            }
        }
    }

    public void setStateSilently(int n) {
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public boolean isComplete() {
        return this.getState() == -1;
    }

    public PhyButton getPlayButton() {
        return this.playButton;
    }

    public void initPlayButton() {
        this.playButton = new PhyButton("PLAY");
        this.playButton.addActionListener(this);
        this.playButton.setCursor(new Cursor(12));
    }

    public void setParamList(String string) {
        int n;
        this.table = new Hashtable();
        String string2 = string;
        while (string2.length() > 0 && (n = string2.indexOf("=")) >= 0) {
            String string3 = string2.substring(0, n).trim();
            if ((string2 = string2.substring(n + 1, string2.length()).trim()).length() == 0) break;
            String string4 = string2;
            int n2 = string2.indexOf(" ");
            if (n2 > 0) {
                string4 = string2.substring(0, n2).trim();
            }
            this.table.put(string3, string4);
            string2 = string2.substring(n2 + 1, string2.length()).trim();
        }
    }

    private boolean isStandaloneInternal() {
        try {
            this.getCodeBase();
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = true;
            return bl;
        }
    }

    public static void setLanguage(String string) {
        language = string;
    }

    public static String getLanguage() {
        return language;
    }

    public static boolean isStandalone() {
        return standalone;
    }

    public boolean isRunning() {
        return true;
    }

    public void setRunning(boolean bl) {
    }

    public String getParameter(String string, String string2) {
        if (this.table != null) {
            String string3 = (String)this.table.get(string);
            return string3 != null ? string3 : string2;
        }
        return PhysicApplet.isStandalone() ? System.getProperty(string, string2) : (this.getParameter(string) != null ? this.getParameter(string) : string2);
    }

    public int getParameter(String string, int n) {
        try {
            int n2 = Integer.valueOf(this.getParameter(string, Integer.toString(n)));
            return n2;
        }
        catch (Exception exception) {
            int n3 = n;
            return n3;
        }
    }

    public double getParameter(String string, double d) {
        return Double.valueOf(this.getParameter(string, Double.toString(d)));
    }

    public boolean getParameter(String string, boolean bl) {
        return Boolean.valueOf(this.getParameter(string, new Boolean(bl).toString()));
    }

    public static Color getDefaultBackground() {
        return defaultBackground;
    }

    public static void setDefaultBackground(Color color) {
        defaultBackground = color;
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font font) {
        defaultFont = font;
    }

    public void setFont(Font font) {
        super.setFont(font);
        PhysicApplet.setDefaultFont(font);
    }

    public static boolean isFastDrawing() {
        return false;
    }

    public void startShow() {
    }

    public void initApplet() {
        this.timeLine.reset();
    }

    public void flushApplet() {
    }

    public boolean isRewindable() {
        return this.rewindable;
    }

    public void setRewindable(boolean bl) {
        this.rewindable = bl;
    }

    public void repaintApplet() {
        if (this.getComponent(0) != null && this.getComponent(0) instanceof Container) {
            Container container = (Container)this.getComponent(0);
            for (int i = 0; i < container.getComponentCount(); ++i) {
                container.getComponent(i).repaint();
            }
        }
        this.getComponent(0).repaint();
    }

    public PhysicApplet() {
        FileToolkit.setApplet(this);
        SoundPlayer.setEnabled(true);
        this.measureComputerSpeed();
    }

    public void init() {
        this.setBackground(PhysicApplet.getDefaultBackground());
        this.setForeground(Color.white);
        standalone = this.isStandaloneInternal();
        this.mode = this.getParameter("mode", "normal");
        try {
            this.codeBase = this.getCodeBase().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAppletInfo() {
        return "Applet pour la physique";
    }

    public void stop() {
        if (this.timeLine != null) {
            this.timeLine.end();
        }
        if (this.timer != null) {
            this.timer.end();
        }
    }

    public void start() {
        if (this.timer != null) {
            this.timer.start();
        }
        if (!PhysicApplet.isStandalone()) {
            this.startShow();
        }
        if (this.isAutoEnableQCM()) {
            this.enableQCM();
        }
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void startAnimation() {
    }

    public boolean isReadyToGo() {
        return true;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionEventSupport.addActionListener(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionEventSupport.removeActionListener(actionListener);
    }

    public void fireImmediateEvent(String string) {
        this.fireActionEvent("ERROR");
        this.fireActionEvent(string);
    }

    public void fireActionEvent(String string) {
        this.actionEventSupport.fireActionEvent(string);
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        this.actionEventSupport.fireActionEvent(actionEvent);
    }

    public String getParam(String string) {
        return "";
    }

    public String getMessageUncomplete() {
        return "";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void processTimeEvent(TimeEvent timeEvent) {
        if (timeEvent.getActionCommand().startsWith("APPLET")) {
            String string = timeEvent.getActionCommand().substring(6).trim();
            TimeEvent timeEvent2 = new TimeEvent(timeEvent, string);
            if (timeEvent2.getActionListener() != null) {
                timeEvent2.getActionListener().actionPerformed(timeEvent2);
            } else if (timeEvent2.getType().equals("PCE")) {
                timeEvent2.getPCListener().propertyChange(timeEvent2.getPCE());
            } else {
                this.actionPerformed(timeEvent2);
            }
        } else {
            this.fireActionEvent(timeEvent.getActionCommand());
        }
    }

    protected void uncrackMetaEvent(long l, CrackedString crackedString) {
        int n = crackedString.getInt(1);
        int n2 = crackedString.getInt(2);
        if (PhysicApplet.getComputerSpeed() == 1) {
            n2 *= n - 1;
            n = Math.max(n / 2, 3);
            n2 /= n - 1;
        }
        double d = crackedString.getDouble(3);
        double d2 = (crackedString.getDouble(4) - d) / (double)(n - 1);
        String string = String.valueOf("APPLET ").concat(String.valueOf(crackedString.getTail(5)));
        for (int i = 0; i < n; ++i) {
            this.addTimeEvent(l + (long)(i * n2), String.valueOf(String.valueOf(string).concat(String.valueOf(" "))).concat(String.valueOf(d + (double)i * d2)));
        }
    }

    protected void uncrackMetaEvent2(long l, CrackedString crackedString) {
        int n = crackedString.getInt(1);
        int n2 = crackedString.getInt(2);
        if (n >= 5 && PhysicApplet.getComputerSpeed() == 1) {
            n2 *= n - 1;
            n = Math.max(n / 2, 3);
            n2 /= n - 1;
        }
        double d = crackedString.getDouble(3);
        double d2 = (crackedString.getDouble(5) - d) / (double)(n - 1);
        double d3 = crackedString.getDouble(4);
        double d4 = (crackedString.getDouble(6) - d3) / (double)(n - 1);
        String string = String.valueOf("APPLET ").concat(String.valueOf(crackedString.getTail(7)));
        for (int i = 0; i < n; ++i) {
            this.addTimeEvent(l + (long)(i * n2), String.valueOf(String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf(" "))).concat(String.valueOf(d + (double)i * d2))).concat(String.valueOf(" "))).concat(String.valueOf(d3 + (double)i * d4)));
        }
    }

    public int getXRemoteMouse() {
        return this.xRemoteMouse;
    }

    public int getYRemoteMouse() {
        return this.yRemoteMouse;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getActionCommand().startsWith("REMOTE_MOUSE XY ")) {
            object = new CrackedString(actionEvent.getActionCommand());
            this.xRemoteMouse = ((CrackedString)object).getInt(2);
            this.yRemoteMouse = ((CrackedString)object).getInt(3);
        }
        if (actionEvent.getActionCommand().startsWith("META")) {
            object = new CrackedString(actionEvent.getActionCommand());
            long l = this.timeLine.getTime();
            if (((CrackedString)object).getField(0).equals("META")) {
                int n = ((CrackedString)object).getInt(1);
                int n2 = ((CrackedString)object).getInt(2);
                String string = String.valueOf("APPLET ").concat(String.valueOf(((CrackedString)object).getTail(3)));
                for (int i = 0; i < n; ++i) {
                    this.addTimeEvent(l + (long)(i * n2), string);
                }
            } else if (((CrackedString)object).getField(0).equals("METADOUBLE")) {
                this.uncrackMetaEvent(l, (CrackedString)object);
            } else if (((CrackedString)object).getField(0).equals("METADOUBLE2")) {
                this.uncrackMetaEvent2(l, (CrackedString)object);
            }
        } else if (actionEvent.getActionCommand().startsWith("REMOTE_MOUSE MOVE ")) {
            object = new CrackedString(actionEvent.getActionCommand());
            double d = ((CrackedString)object).getDouble(4);
            int n = (int)Math.floor(d / (double)100);
            this.uncrackMetaEvent2(this.timeLine.getTime(), new CrackedString(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("METADOUBLE2 ").concat(String.valueOf(n))).concat(String.valueOf(" 100 "))).concat(String.valueOf(this.xRemoteMouse))).concat(String.valueOf(" "))).concat(String.valueOf(this.yRemoteMouse))).concat(String.valueOf(" "))).concat(String.valueOf(((CrackedString)object).getField(2)))).concat(String.valueOf(" "))).concat(String.valueOf(((CrackedString)object).getField(3)))).concat(String.valueOf(" REMOTE_MOUSE XY"))));
        } else if (actionEvent.getActionCommand().equals("PLAY")) {
            if (this.simulator != null) {
                this.simulator.resume();
                this.repaint();
            }
            if (actionEvent.getSource() instanceof PhyButton) {
                ((PhyButton)actionEvent.getSource()).setButtonType("PAUSE");
            } else if (this.getPlayButton() != null) {
                this.getPlayButton().setButtonType("PAUSE");
                this.getPlayButton().repaint();
            }
        } else if (actionEvent.getActionCommand().equals("PAUSE")) {
            if (this.simulator != null) {
                this.simulator.pause();
            }
            if (actionEvent.getSource() instanceof PhyButton) {
                ((PhyButton)actionEvent.getSource()).setButtonType("PLAY");
            } else if (this.getPlayButton() != null) {
                this.getPlayButton().setButtonType("PLAY");
                this.getPlayButton().repaint();
            }
        } else if (actionEvent.getActionCommand().startsWith("SOUND")) {
            if (actionEvent.getActionCommand().endsWith("ON")) {
                SoundPlayer.setEnabled(true);
            } else if (actionEvent.getActionCommand().endsWith("OFF")) {
                SoundPlayer.setEnabled(false);
            }
        } else if (actionEvent.getActionCommand().equals("INIT")) {
            this.initApplet();
        } else if (actionEvent.getActionCommand().equals("START")) {
            this.startShow();
        } else if (actionEvent.getActionCommand().startsWith("LISTENER")) {
            object = CrackedString.getField(actionEvent.getActionCommand(), 1);
            Component component = this.searchComponent((String)object);
            if (component != null && component instanceof ActionListener) {
                this.setDefaultListener((ActionListener)((Object)component));
            }
        } else if (actionEvent.getActionCommand().startsWith("TELL ")) {
            object = new CrackedString(actionEvent.getActionCommand());
            Component component = this.searchComponent(((CrackedString)object).getField(1));
            if (component != null && component instanceof ActionListener) {
                ((ActionListener)((Object)component)).actionPerformed(new TimeEvent((Object)this, 0L, ((CrackedString)object).getTail(2)));
            }
        } else if (this.getDefaultListener() != null) {
            this.getDefaultListener().actionPerformed(new TimeEvent((Object)this, 0L, actionEvent.getActionCommand()));
        } else {
            PhyTools.issueMessage(String.valueOf("WARNING - je ne sais pas traiter cet \u00e9v\u00e8nement : ").concat(String.valueOf(actionEvent)));
        }
    }

    public void actionPerformed(String string) {
        this.actionPerformed(new ActionEvent(this, 1001, string));
    }

    public void addTimeEvent(long l, String string, ActionListener actionListener) {
        this.timeLine.add(new TimeEvent((Object)this.timeLine, l, string, actionListener));
    }

    public void addTimeEvent(long l, String string) {
        this.timeLine.add(new TimeEvent((Object)this.timeLine, l, string));
    }

    public void addRelativeTimeEvent(long l, String string, ActionListener actionListener) {
        this.addTimeEvent(l + this.timeLine.getTime(), string, actionListener);
    }

    public void addRelativeTimeEvent(long l, String string) {
        this.addTimeEvent(l + this.timeLine.getTime(), string);
    }

    public void setEventSequence(String string) {
        long l = 0L;
        do {
            String string2;
            int n;
            if ((n = string.indexOf(",")) >= 0) {
                string2 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            } else {
                string2 = string;
                string = "";
            }
            CrackedString crackedString = new CrackedString(string2);
            if (crackedString.getNFields() <= 1) continue;
            long l2 = Integer.valueOf(crackedString.getField(0)).longValue() + l;
            if (crackedString.getNFields() > 3 && crackedString.getField(2).equals("METADOUBLE")) {
                this.uncrackMetaEvent(l2, new CrackedString(crackedString.getTail(2)));
                continue;
            }
            if (crackedString.getNFields() > 3 && crackedString.getField(2).equals("METADOUBLE2")) {
                this.uncrackMetaEvent2(l2, new CrackedString(crackedString.getTail(2)));
                continue;
            }
            if (crackedString.getField(1).equals("ZERO")) {
                l = l2;
                continue;
            }
            this.addTimeEvent(l2, crackedString.getTail(1));
        } while (string.length() > 0);
    }

    public void setAutoSequence(String string) {
        if (this.isAutoSequencing()) {
            this.setEventSequence(string);
        }
    }

    public void addTimeListener(ActionListener actionListener) {
        PhyTools.issueMessage("Obsol\u00e8te : il vaut mieux utiliser un simulator");
        if (this.timer == null) {
            this.timer = new Timer(String.valueOf("").concat(String.valueOf(this)));
        }
        this.timer.addActionListener(actionListener);
    }

    public void setFlag(String string) {
        if (!this.flagTable.containsKey(string)) {
            this.flagTable.put(string, new Object());
        }
    }

    public void clearFlag(String string) {
        if (this.flagTable.containsKey(string)) {
            this.flagTable.remove(string);
        }
    }

    public void clearFlags() {
        this.flagTable.clear();
    }

    public boolean isFlagSet(String string) {
        return this.flagTable.containsKey(string);
    }

    public void setImagePath(String string) {
        FileToolkit.setImagePath(string);
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public void setBackgroundImageName(String string) {
        this.backgroundImageName = string;
    }

    public String getBackgroundImageName() {
        return this.backgroundImageName;
    }

    public Image getBackgroundImage() {
        if (this.backgroundImage == null && this.backgroundImageName != null) {
            this.backgroundImage = FileToolkit.loadImage(this.backgroundImageName);
        }
        return this.backgroundImage;
    }

    public void invalidate() {
        super.invalidate();
        this.offscreenImage = null;
    }

    public void paint(Graphics graphics) {
        if (this.getBackgroundImage() != null) {
            graphics.drawImage(this.getBackgroundImage(), 0, 0, this);
        }
        super.paint(graphics);
    }

    public void update(Graphics graphics) {
        if (this.getBackgroundImage() != null) {
            this.paint(graphics);
        } else {
            super.update(graphics);
        }
    }

    public void setQCMStatus(String string) {
        this.qcmStatus = string;
        this.qcmHasChanged();
    }

    public String getQCMStatus() {
        return this.qcmStatus;
    }

    public void qcmHasChanged() {
    }

    public boolean isAutoEnableQCM() {
        return this.autoEnableQCM;
    }

    public void setAutoEnableQCM(boolean bl) {
        this.autoEnableQCM = bl;
    }

    public void enableQCM() {
        if (!this.qcmEnabled) {
            this.fireActionEvent("ENABLE_QCM");
        }
        this.qcmEnabled = true;
    }

    public static String getWord(String string) {
        if (phyDictionnary != null) {
            return PhyDictionnary.getWord(string);
        }
        return "dict unavailable";
    }

    public Component searchComponent(String string) {
        int n;
        for (n = 0; n < this.getComponentCount(); ++n) {
            if (!this.getComponent(n).getName().equals(string)) continue;
            return this.getComponent(n);
        }
        for (n = 0; n < this.getComponentCount(); ++n) {
            Component component;
            if (!(this.getComponent(n) instanceof BufferedPanel) || (component = ((BufferedPanel)this.getComponent(n)).searchComponent(string)) == null) continue;
            return component;
        }
        return null;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

