/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class TeXTokenizer {
    public static final int CHAR = 0;
    public static final int SET = 1;
    public static final int COMMAND = 2;
    public static final int SPECIAL_SYMBOL = 3;
    public static final int FUNCTION = 4;
    public static final int EQTEXT = 5;
    public static final int EQ = 6;
    protected int type = 0;
    protected boolean wholeWordMode = false;
    protected String token;
    protected String teXToken;
    protected static Hashtable symbolTable = TeXTokenizer.generateHashtable(new String[]{"alpha", "\u03b1", "beta", "\u03b2", "gamma", "\u03b3", "delta", "\u03b4", "epsilon", "\u03b5", "varepsilon", "\u03b5", "zeta", "\u03b6", "eta", "\u03b7", "theta", "\u03b8", "vartheta", "\u03d1", "iota", "\u03b9", "kappa", "\u03ba", "lambda", "\u03bb", "mu", "\u03bc", "nu", "\u03bd", "xi", "\u03be", "pi", "\u03c0", "varpi", "\u03d6", "rho", "\u03c1", "varrho", "\u03c1", "sigma", "\u03c3", "varsigma", "\u03c3", "tau", "\u03c4", "upsilon", "\u03c5", "phi", "\u03c6", "varphi", "\u03c6", "chi", "\u03c7", "psi", "\u03c8", "omega", "\u03c9", "Gamma", "\u0393", "Delta", "\u0394", "Theta", "\u0398", "Lambda", "\u039b", "Xi", "\u039e", "Pi", "\u03a0", "Sigma", "\u03a3", "Upsilon", "\u03d2", "Phi", "\u03a6", "Psi", "\u03a8", "Omega", "\u03a9", "rangle", "\u3009", "pm", "\u00b1", "mp", "\u2213", "oplus", "\u2295", "otimes", "\u2297", "ortho", "\u22a5", "pvec", "\u2227", "leq", "\u2264", "geq", "\u2265", "sim", "\u223c", "ll", "\u226a", "gg", "\u226b", "subset", "\u2282", "approx", "\u2248", "in", "\u2208", "leftarrow", "\u2190", "uparrow", "\u2191", "Leftarrow", "\u21d0", "downarrow", "\u2193", "leftrightarrow", "\u2194", "Leftrightarrow", "\u21d4", "forall", "\u2200", "infty", "\u221e", "emptyset", "\u2205", "exists", "\u2203", "nabla", "\u2207", "partial", "\u2202", "{", "{", "}", "}"});
    protected static Vector specialSymbolVector = TeXTokenizer.generateVector("rightarrow/Rightarrow/hbar/rangle/Gcal/bullet/,/:/;", '/');
    protected static Vector commandVector = TeXTokenizer.generateVector("frac,sqrt,int,vec,brackett,mbox,hat,dot,red,yellow,white,black,n,hline,QCM,item,em,tab", ',');
    protected static Vector functionVector = TeXTokenizer.generateVector("arccos,arcsin,arctan,arg,cos,cosh,cot,coth,csc,deg,det,dim,exp,gcd,hom,inf,ker,lg,lim,liminf,limsup,ln,log,max,min,Pr,sec,sin,sinh,sup,tan,tanh", ',');
    private int currentPosition;
    private int maxPosition;
    private String str;

    protected void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setWholeWordMode(boolean bl) {
        this.wholeWordMode = bl;
    }

    public boolean isWholeWordMode() {
        return this.wholeWordMode;
    }

    protected void setToken(String string) {
        this.token = string;
    }

    public String getToken() {
        return this.token;
    }

    protected void setTeXToken(String string) {
        this.teXToken = string;
    }

    public String getTeXToken() {
        return this.teXToken;
    }

    protected static Hashtable generateHashtable(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length / 2; ++i) {
            hashtable.put(stringArray[2 * i].intern(), stringArray[2 * i + 1].intern());
        }
        return hashtable;
    }

    protected static Vector generateVector(String string, char c) {
        Vector<String> vector = new Vector<String>();
        while (string.length() > 0) {
            int n = string.indexOf(c);
            if (n == -1) {
                vector.addElement(string);
                string = "";
                continue;
            }
            vector.addElement(string.substring(0, n));
            string = string.substring(n + 1);
        }
        return vector;
    }

    public TeXTokenizer(String string) {
        this(string, false);
    }

    public TeXTokenizer(String string, boolean bl) {
        this.setWholeWordMode(bl);
        this.currentPosition = 0;
        this.str = string;
        this.maxPosition = string.length();
    }

    public boolean hasMoreTokens() {
        return this.currentPosition < this.maxPosition;
    }

    public String nextToken() {
        String string = "\\{}_^ ";
        this.setType(0);
        this.setToken("");
        this.setTeXToken("");
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        char c = ' ';
        while (c == ' ' && this.currentPosition < this.maxPosition) {
            c = this.str.charAt(this.currentPosition++);
        }
        if (c == '\\') {
            String string2;
            int n = this.currentPosition;
            String string3 = "\\{_^([|-`_^@)]\u00b0=+}$%*!/:;.,?<> ";
            while (this.currentPosition < this.maxPosition && string3.indexOf(this.str.charAt(this.currentPosition)) < 0) {
                ++this.currentPosition;
            }
            if (this.currentPosition == n && this.currentPosition < this.maxPosition) {
                this.currentPosition = n + 1;
            }
            if (specialSymbolVector.contains((string2 = this.str.substring(n, this.currentPosition)).intern())) {
                this.setToken(string2.intern());
                this.setTeXToken(String.valueOf("\\").concat(String.valueOf(string2)));
                this.setType(3);
            } else if (symbolTable.containsKey(string2.intern())) {
                this.setToken((String)symbolTable.get(string2.intern()));
                this.setTeXToken(String.valueOf("\\").concat(String.valueOf(string2)));
                this.setType(0);
            } else if (functionVector.contains(string2.intern())) {
                this.setToken(string2.intern());
                this.setTeXToken(String.valueOf("\\").concat(String.valueOf(string2)));
                this.setType(4);
            } else if (commandVector.contains(string2.intern())) {
                this.setToken(string2.intern());
                this.setTeXToken(String.valueOf("\\").concat(String.valueOf(string2)));
                this.setType(2);
            } else {
                System.out.println(String.valueOf(String.valueOf(String.valueOf("Commande ").concat(String.valueOf(string2.intern()))).concat(String.valueOf(" inconnue "))).concat(String.valueOf(this.str)));
                this.currentPosition = this.maxPosition;
            }
        } else if (c == '{') {
            int n = this.currentPosition;
            int n2 = 1;
            while (this.currentPosition < this.maxPosition && n2 > 0) {
                if (this.str.charAt(this.currentPosition) == '{') {
                    ++n2;
                } else if (this.str.charAt(this.currentPosition) == '}') {
                    --n2;
                }
                ++this.currentPosition;
            }
            if (n2 == 0) {
                this.setToken(this.str.substring(n, this.currentPosition - 1));
                this.setTeXToken(this.getToken());
                this.setType(1);
            } else {
                System.out.println(String.valueOf("Commande inconnue ").concat(String.valueOf(this.str)));
                this.currentPosition = this.maxPosition;
            }
        } else if (c == '_') {
            this.setType(2);
            this.setToken("_");
            this.setTeXToken("_");
        } else if (c == '^') {
            this.setType(2);
            this.setToken("^");
            this.setTeXToken("^");
        } else if (c == '$') {
            if (this.str.charAt(this.currentPosition) == '$') {
                ++this.currentPosition;
                this.setType(6);
                int n = this.currentPosition;
                while (this.currentPosition < this.maxPosition && this.str.charAt(this.currentPosition) != '$') {
                    ++this.currentPosition;
                }
                this.setToken(this.str.substring(n, this.currentPosition));
                this.setTeXToken(this.getToken());
                this.currentPosition += 2;
                System.out.println(String.valueOf("EQ ").concat(String.valueOf(this.getToken())));
            } else {
                this.setType(5);
                int n = this.currentPosition;
                while (this.currentPosition < this.maxPosition && this.str.charAt(this.currentPosition) != '$') {
                    ++this.currentPosition;
                }
                this.setToken(this.str.substring(n, this.currentPosition));
                this.setTeXToken(this.getToken());
                ++this.currentPosition;
                System.out.println(String.valueOf("EQ ").concat(String.valueOf(this.getToken())));
            }
        } else {
            this.setToken(String.valueOf("").concat(String.valueOf(c)));
            if (this.isWholeWordMode()) {
                while (this.currentPosition < this.maxPosition && string.indexOf(this.str.charAt(this.currentPosition)) < 0) {
                    this.setToken(String.valueOf(this.getToken()).concat(String.valueOf(this.str.charAt(this.currentPosition))));
                    ++this.currentPosition;
                }
            }
            this.setTeXToken(this.getToken());
            this.setType(0);
        }
        return this.getToken();
    }
}

