/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

import java.awt.event.ActionListener;
import java.util.Vector;
import phy.util.ActionEventSupport;
import phy.util.TimeEvent;
import phy.util.TimeObserver;

public class TimeLine
extends Thread {
    ActionEventSupport actionEventSupport = new ActionEventSupport();
    protected long tickPeriod = 0L;
    protected long lastTick = 0L;
    protected TimeObserver observer;
    protected Vector queue = new Vector();
    protected long timeOrigin;
    protected boolean emptyQueue = true;
    protected TimeEvent pendingEvt;
    protected boolean running = true;

    public synchronized void addTimeListener(ActionListener actionListener) {
        this.actionEventSupport.addActionListener(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionEventSupport.removeActionListener(actionListener);
    }

    public void setTickPeriod(long l) {
        this.tickPeriod = l;
    }

    public TimeLine(TimeObserver timeObserver) {
        this(String.valueOf(String.valueOf("TimeLine (").concat(String.valueOf(timeObserver))).concat(String.valueOf(")")));
        this.observer = timeObserver;
    }

    public TimeLine(String string) {
        super(string);
        this.reset();
        TimeEvent timeEvent = new TimeEvent((Object)this, 0L, "test");
    }

    public int size() {
        return this.queue.size();
    }

    public long getTime() {
        return System.currentTimeMillis() - this.timeOrigin;
    }

    protected synchronized TimeEvent getNextEvent() {
        if (this.queue.size() == 0) {
            return null;
        }
        Object e = this.queue.elementAt(0);
        this.queue.removeElementAt(0);
        return (TimeEvent)e;
    }

    public synchronized void shift(long l) {
        for (int i = 0; i < this.queue.size(); ++i) {
            TimeEvent timeEvent = (TimeEvent)this.queue.elementAt(i);
            timeEvent.setTime(timeEvent.getTime() + l);
        }
    }

    public void run() {
        while (this.running) {
            while (this.size() > 0 && this.running) {
                long l;
                this.emptyQueue = false;
                this.pendingEvt = this.getNextEvent();
                while (this.tickPeriod != (long)0 && this.lastTick + this.tickPeriod < this.pendingEvt.getTime()) {
                    l = this.lastTick + this.tickPeriod - this.getTime();
                    if (l > (long)0) {
                        try {
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.fireEvent(new TimeEvent((Object)this, 0L, "TICK"));
                    this.lastTick = this.getTime();
                }
                l = this.pendingEvt.getTime() - this.getTime();
                if (l <= (long)0) {
                    this.fireEvent(this.pendingEvt);
                    this.pendingEvt = null;
                    continue;
                }
                try {
                    Thread.sleep(l);
                    this.fireEvent(this.pendingEvt);
                    this.pendingEvt = null;
                }
                catch (InterruptedException interruptedException) {}
            }
            while (this.queue.size() == 0 && this.running) {
                this.emptyQueue = true;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized void flush() {
        this.fireEvent(this.pendingEvt);
        while (this.queue.size() > 0) {
            this.fireEvent(this.getNextEvent());
        }
        this.reset();
    }

    protected void fireEvent(TimeEvent timeEvent) {
        long l = this.getTime();
        if (this.observer != null) {
            this.observer.processTimeEvent(timeEvent);
        }
        this.actionEventSupport.fireActionEvent(timeEvent);
        l = this.getTime() - timeEvent.getTime();
        if (timeEvent.getActionCommand().startsWith("PLAY ")) {
            this.shift(l);
        }
    }

    public synchronized void add(TimeEvent timeEvent) {
        int n;
        for (n = 0; n < this.queue.size() && ((TimeEvent)this.queue.elementAt(n)).getTime() <= timeEvent.getTime(); ++n) {
        }
        this.queue.insertElementAt(timeEvent, n);
        if (!this.isAlive()) {
            this.start();
        }
    }

    public void clear() {
        this.timeOrigin = System.currentTimeMillis();
        this.queue.removeAllElements();
    }

    public void reset() {
        this.timeOrigin = System.currentTimeMillis();
        this.queue.removeAllElements();
        this.interrupt();
    }

    public void end() {
        this.running = false;
        if (!this.isAlive()) {
            this.start();
        }
        this.reset();
    }
}

