/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

import phy.util.MathTools;

public class Unit {
    public static final int ATTO = -6;
    public static final int FEMTO = -5;
    public static final int PICO = -4;
    public static final int NANO = -3;
    public static final int MICRO = -2;
    public static final int MILLI = -1;
    public static final int STANDARD = 0;
    public static final int KILO = 1;
    public static final int MEGA = 2;
    public static final int GIGA = 3;
    public static final int TERA = 4;
    public static final int PETA = 5;
    public static final int FIRST_SCALE = -6;
    public static final int NScales = 12;
    public static final double atto = Unit.getScale(-6);
    public static final double femto = Unit.getScale(-5);
    public static final double pico = Unit.getScale(-4);
    public static final double nano = Unit.getScale(-3);
    public static final double micro = Unit.getScale(-2);
    public static final double milli = Unit.getScale(-1);
    public static final double kilo = Unit.getScale(1);
    public static final double mega = Unit.getScale(2);
    public static final double giga = Unit.getScale(3);
    public static final double tera = Unit.getScale(4);
    public static final double peta = Unit.getScale(5);
    public static final double centi = 0.01;
    protected static final String[] scaleName = new String[]{"a", "f", "p", "n", "\u00b5", "m", "", "k", "M", "G", "T", "P"};
    public static final int NONE = 0;
    public static final int TIME = 1;
    public static final int VOLTAGE = 2;
    public static final int CURRENT = 3;
    public static final int CHARGE = 4;
    public static final int ENERGY = 5;
    public static final int MASS = 6;
    public static final int LENGTH = 7;
    public static final int NUnits = 7;
    public static final double hour = 3600.0;
    public static final double day = 86400.0;
    public static final double sideralDay = 86160.0;
    public static final double year = 3.1536E7;
    public static final double tropicalYear = 3.1469250720000003E7;
    public static final double UA = 1.496E11;
    protected static final String[] unitName = new String[]{"", "s", "V", "A", "C", "J", "g", "m"};
    protected int scaleId = 0;
    protected double scale = 1.0;
    protected int id = 0;
    protected String name;

    public static String getName(int n) {
        return unitName[n];
    }

    public static String getPrefix(int n) {
        return scaleName[n - -6];
    }

    public static double getScale(int n) {
        return Math.pow(10.0, 3 * n);
    }

    public static int findScaleId(String string) {
        for (int i = -6; i < 6; ++i) {
            if (i == 0 || !string.startsWith(Unit.getPrefix(i))) continue;
            return i;
        }
        return 0;
    }

    public static int findId(String string) {
        for (int i = 1; i <= 7; ++i) {
            if (!string.equals(Unit.getName(i))) continue;
            return i;
        }
        return 0;
    }

    public void setScaleId(int n) {
        this.scaleId = n;
        this.setScale(Unit.getScale(this.scaleId));
    }

    public int getScaleId() {
        return this.scaleId;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setId(int n) {
        this.id = n;
        this.setName(Unit.getName(this.id));
    }

    public int getId() {
        return this.id;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return Unit.getPrefix(this.getScaleId());
    }

    public String getFullName() {
        return String.valueOf(this.getPrefix()).concat(String.valueOf(this.getName()));
    }

    public static double getSIValue(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return MathTools.parseDouble(string);
        }
        String string2 = string.substring(0, n).trim();
        Unit unit = new Unit(string.substring(n).trim());
        return MathTools.parseDouble(string2) * unit.getScale();
    }

    public Unit(int n, int n2) {
        this.setId(n);
        this.setScaleId(n2);
    }

    public Unit(String string, int n) {
        this(0, n);
        this.setName(string);
    }

    public Unit(String string, double d) {
        this.setScaleId(0);
        this.setId(0);
        this.setScale(d);
        this.setName(string);
    }

    public Unit(int n) {
        this(n, 0);
    }

    public Unit(String string) {
        string = string.trim();
        if (string.indexOf("&") == 0) {
            this.setId(0);
            this.setScaleId(0);
            this.setName(string.substring(1));
        } else if (string.indexOf("/") >= 0) {
            int n = string.indexOf("/");
            Unit unit = new Unit(string.substring(0, n));
            Unit unit2 = new Unit(string.substring(n + 1));
            this.setScaleId(0);
            this.setId(0);
            this.setScale(unit.getScale() / unit2.getScale());
            this.setName(string);
        } else if (string.equals("m")) {
            this.setId(7);
            this.setScaleId(0);
        } else if (string.equals("\u00b0")) {
            this.setId(0);
            this.setScaleId(0);
            this.setScale(Math.PI / 180);
            this.setName(string);
        } else {
            int n = string.indexOf("#Omega");
            if (n >= 0) {
                string = String.valueOf(String.valueOf(string.substring(0, n)).concat(String.valueOf("\u03a9"))).concat(String.valueOf(string.substring(n + 6)));
            }
            this.setScaleId(Unit.findScaleId(string));
            String string2 = this.getScaleId() == 0 ? string : string.substring(1);
            this.setId(Unit.findId(string2));
            if (this.getId() == 0) {
                this.setName(string2);
            } else if (this.getId() == 6) {
                this.setScale(this.getScale() / (double)1000);
            }
        }
    }

    public Unit() {
        this(0);
    }

    public String toString() {
        return this.getFullName();
    }
}

