/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.project.PvCameraIf;
import jv.project.PvDisplayIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuVectorGeom;

public class PvDisplayOption
extends P_Vector {
    public static final int SHOW_ANTIALIAS = 1;
    public static final int SHOW_AUTOROTATE = 2;
    public static final int SHOW_AXES = 3;
    public static final int SHOW_AXES_LABEL = 4;
    public static final int SHOW_BACKGROUND_IMAGE = 5;
    public static final int SHOW_BORDER = 7;
    public static final int SHOW_BOUNDING_BOX = 8;
    public static final int SHOW_CENTER = 9;
    public static final int SHOW_CROSS = 10;
    public static final int SHOW_DEPTHCUE = 11;
    public static final int SHOW_DRAWING = 12;
    public static final int SHOW_EDGE_AURA = 13;
    public static final int SHOW_FOREGROUND_IMAGE = 14;
    public static final int SHOW_FRAME = 15;
    public static final int SHOW_INFO = 16;
    public static final int SHOW_LIGHTING = 17;
    public static final int SHOW_MAGNET = 18;
    public static final int SHOW_SINGLE = 19;
    public static final int SHOW_SORTING = 20;
    public static final int SHOW_VISIBLE = 21;
    public static final int SHOW_XY_GRID = 22;
    public static final int SHOW_XZ_GRID = 23;
    public static final int SHOW_YZ_GRID = 24;
    public static final int SHOW_ZBUFFER = 25;
    public static final int LIGHT_BULB = 1;
    public static final int LIGHT_RGB_CUBE = 2;
    public static final int LIGHT_HUE = 3;
    public static final int LIGHT_SPOT = 4;
    public static final int LIGHT_SUN = 5;
    protected String m_version = "0.90";
    protected String m_versionType = "dump";
    protected String m_title;
    protected String m_abstract;
    protected int m_dim;
    protected String[] m_axesLabel;
    protected int m_numCameras;
    protected int m_currentCamera;
    protected int[] m_cameraProjection;
    protected PdVector[] m_cameraPosition;
    protected PdVector[] m_cameraInterest;
    protected double[] m_cameraRoll;
    protected double[] m_cameraFieldOfView;
    protected boolean[] m_cameraEnableTransform;
    protected int[] m_cameraAmbient;
    protected int[] m_cameraPerspective;
    protected boolean[] m_cameraEnableClip;
    protected double[] m_cameraNearClip;
    protected double[] m_cameraFarClip;
    protected int m_numLights;
    protected Color m_ambientLight;
    protected int[] m_lightType;
    protected PdVector[] m_lightPosition;
    protected PdVector[] m_lightInterest;
    protected Color[] m_lightColor;
    protected Color m_backgroundColor;
    protected String m_backgroundImageRepeat;
    protected String m_backgroundImage;
    protected Color m_foregroundColor;
    protected String m_foregroundImageRepeat;
    protected String m_foregroundImage;
    protected Point m_windowPosition;
    protected Dimension m_windowSize;
    protected PdVector m_viewCenter;
    protected PiVector m_axesEdge;

    public void setCameraPerspective(int n, int n2) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraPerspective[n] = n2;
    }

    public double getCameraRoll(int n) {
        return this.m_cameraRoll[n];
    }

    public void setCameraRoll(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraRoll[n] = d;
    }

    public void setEnabledCameraTransform(int n, boolean bl) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraEnableTransform[n] = bl;
    }

    public String getBackgroundImage() {
        return this.m_backgroundImage;
    }

    public void setBackgroundImage(String string) {
        this.m_backgroundImage = string;
    }

    public boolean isEnabledCameraClip(int n) {
        return this.m_cameraEnableClip[n];
    }

    protected boolean getOption(int n) {
        return this.hasTag(n);
    }

    public void setOption(int n, boolean bl) {
        if (bl) {
            this.setTag(n);
            return;
        }
        this.clearTag(n);
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public PiVector getAxesEdge() {
        return this.m_axesEdge;
    }

    public int getCameraAmbient(int n) {
        return this.m_cameraAmbient[n];
    }

    public void setCameraAmbient(int n, int n2) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraAmbient[n] = n2;
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColor = color;
    }

    public void setAxesEdge(PiVector piVector) {
        this.m_axesEdge = piVector;
    }

    public int getCurrentCamera() {
        return this.m_currentCamera;
    }

    public void setCurrentCamera(int n) {
        this.m_currentCamera = n;
    }

    public int getNumLights() {
        return this.m_numLights;
    }

    public void setNumLights(int n) {
        if (n < 0) {
            PsDebug.warning("number = " + n + " < 0");
            return;
        }
        if (n == this.m_numLights) {
            return;
        }
        this.m_numLights = n;
        this.m_lightType = PuData.realloc(this.m_lightType, this.m_numLights);
        this.m_lightPosition = PdVector.realloc(this.m_lightPosition, this.m_numLights);
        this.m_lightInterest = PdVector.realloc(this.m_lightInterest, this.m_numLights);
        this.m_lightColor = PdColor.realloc(this.m_lightColor, this.m_numLights);
    }

    public PdMatrix getCameraMatrix(int n) {
        PdVector pdVector = this.getCameraInterest(n);
        PdVector pdVector2 = this.getCameraPosition(n);
        PdVector pdVector3 = PdVector.subNew(pdVector, pdVector2);
        pdVector3.normalize();
        PdVector pdVector4 = new PdVector(0.0, 0.0, 1.0);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = pdVector4.orthogonalPart(null, pdVector3);
        if (!pdVector6.normalize()) {
            pdVector4.m_data[1] = pdVector4.m_data[1] + 1.0;
            pdVector6 = pdVector4.orthogonalPart(null, pdVector3);
            if (!pdVector6.normalize()) {
                pdVector4.m_data[2] = pdVector4.m_data[2] + 1.0;
                pdVector6 = pdVector4.orthogonalPart(null, pdVector3);
                if (!pdVector6.normalize()) {
                    pdVector4.m_data[2] = pdVector4.m_data[2] + 1.0;
                    pdVector6 = pdVector4.orthogonalPart(null, pdVector3);
                }
            }
        }
        pdVector4.copy(pdVector6);
        PuVectorGeom.rotatePointAroundVector(pdVector6, pdVector4, pdVector3, this.m_cameraRoll[n] * Math.PI / 180.0);
        pdVector5.cross(pdVector3, pdVector6);
        PdMatrix pdMatrix = new PdMatrix(4);
        double d = PdVector.dist(pdVector2, pdVector);
        int n2 = 0;
        do {
            pdMatrix.m_data[0][n2] = d * pdVector5.m_data[n2];
            pdMatrix.m_data[1][n2] = d * pdVector6.m_data[n2];
            pdMatrix.m_data[2][n2] = -d * pdVector3.m_data[n2];
            pdMatrix.m_data[3][n2] = pdVector.m_data[n2];
        } while (++n2 < 3);
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public void setCameraMatrix(int n, PdMatrix pdMatrix) {
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        int n2 = 0;
        do {
            pdVector4.m_data[n2] = pdMatrix.m_data[0][n2];
            pdVector3.m_data[n2] = pdMatrix.m_data[1][n2];
            pdVector2.m_data[n2] = -pdMatrix.m_data[2][n2];
            pdVector.m_data[n2] = pdMatrix.m_data[3][n2];
            pdVector5.m_data[n2] = pdMatrix.m_data[n2][2];
        } while (++n2 < 3);
        this.setCameraPosition(n, PdVector.subNew(pdVector, pdVector2));
        this.setCameraInterest(n, pdVector);
        pdVector5.setEntry(2, 0.0);
        pdVector5.normalize();
        double d = Math.acos(pdVector5.getEntry(1)) * 180.0 / Math.PI;
        this.setCameraRoll(n, d);
    }

    public boolean isEnabledCameraTransform(int n) {
        return this.m_cameraEnableTransform[n];
    }

    public double getCameraFarClip(int n) {
        return this.m_cameraFarClip[n];
    }

    public double getCameraFieldOfView(int n) {
        return this.m_cameraFieldOfView[n];
    }

    public void setCameraFieldOfView(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraFieldOfView[n] = d;
    }

    public void setCameraFarClip(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraFarClip[n] = d;
    }

    public PdVector getCameraPosition(int n) {
        return this.m_cameraPosition[n];
    }

    public void setCameraPosition(int n, PdVector pdVector) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraPosition[n].copy(pdVector);
    }

    public Color getAmbientLight() {
        return this.m_ambientLight;
    }

    public void setAmbientLight(Color color) {
        this.m_ambientLight = color;
    }

    public PdVector getLightPosition(int n) {
        return this.m_lightPosition[n];
    }

    public void setLightPosition(int n, PdVector pdVector) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightPosition[n] = pdVector;
    }

    public void configure(PvDisplayIf pvDisplayIf) {
        Object object;
        if (pvDisplayIf == null) {
            PsDebug.warning("missing display");
            return;
        }
        pvDisplayIf.setEnabledUpdate(false);
        pvDisplayIf.setAutoCenter(false);
        pvDisplayIf.setPaintTag(64, this.getOption(1));
        pvDisplayIf.setEnabledAnimation(this.getOption(2));
        if (this.getBackgroundColor() != null) {
            pvDisplayIf.setBackgroundColor(this.getBackgroundColor());
        }
        pvDisplayIf.showBackImage(this.getOption(5));
        if (this.getBackgroundImage() != null) {
            pvDisplayIf.setBackgroundImage(this.getBackgroundImage());
        }
        pvDisplayIf.showBndBox(this.getOption(8));
        pvDisplayIf.setPaintTag(4, this.getOption(7));
        pvDisplayIf.setPaintTag(16384, this.getOption(9));
        pvDisplayIf.setPaintTag(16, this.getOption(10));
        pvDisplayIf.showDepthcue(this.getOption(11));
        pvDisplayIf.setPaintTag(1, this.getOption(12));
        pvDisplayIf.showEdgeAura(this.getOption(13));
        if (this.getForegroundColor() != null) {
            pvDisplayIf.setForegroundColor(this.getForegroundColor());
        }
        pvDisplayIf.showFrame(this.getOption(15));
        pvDisplayIf.setPaintTag(256, this.getOption(16));
        pvDisplayIf.showMagnet(this.getOption(18));
        pvDisplayIf.setPaintTag(2048, this.getOption(19));
        pvDisplayIf.setEnabledPainters(this.getOption(20));
        pvDisplayIf.showGrid(this.getOption(22));
        pvDisplayIf.setEnabledZBuffer(this.getOption(25));
        int n = 0;
        while (n < this.m_numCameras) {
            object = null;
            if (!pvDisplayIf.hasCamera(this.m_cameraProjection[n])) {
                pvDisplayIf.selectCamera(this.m_cameraProjection[n]);
            }
            object = pvDisplayIf.getCamera(this.m_cameraProjection[n]);
            object.setInterest(this.m_cameraInterest[n]);
            object.setPosition(this.m_cameraPosition[n]);
            object.setFieldOfView(this.m_cameraFieldOfView[n]);
            object.setRoll(this.m_cameraRoll[n]);
            object.setEnabledClip(this.isEnabledCameraClip(n));
            object.setNearClip(this.getCameraNearClip(n));
            object.setFarClip(this.getCameraFarClip(n));
            object.update(object);
            ++n;
        }
        pvDisplayIf.selectCamera(this.getCurrentCamera());
        Frame frame = pvDisplayIf.getFrame();
        if (frame != null && (object = this.getWindowPosition()) != null) {
            ((Component)frame).setLocation((Point)object);
        }
        if ((object = this.getWindowSize()) != null) {
            pvDisplayIf.setSizeWithinFrame(((Dimension)object).width, ((Dimension)object).height);
        }
        pvDisplayIf.setName(this.getTitle());
        pvDisplayIf.setEnabledUpdate(true);
        pvDisplayIf.showAxes(this.getOption(3));
    }

    public int getCameraProjection(int n) {
        return this.m_cameraProjection[n];
    }

    public void setCameraProjection(int n, int n2) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraProjection[n] = n2;
    }

    public String getAbstract() {
        return this.m_abstract;
    }

    public void setAbstract(String string) {
        this.m_abstract = string;
    }

    public Point getWindowPosition() {
        return this.m_windowPosition;
    }

    public void setWindowPosition(int n, int n2) {
        this.m_windowPosition = new Point(n, n2);
    }

    public Dimension getWindowSize() {
        return this.m_windowSize;
    }

    public void setWindowSize(int n, int n2) {
        this.m_windowSize = new Dimension(n, n2);
    }

    public String[] getAxesLabel() {
        return this.m_axesLabel;
    }

    public void setAxesLabel(String[] stringArray) {
        this.m_axesLabel = stringArray;
    }

    public void setOptions(PvDisplayIf pvDisplayIf) {
        Cloneable cloneable;
        Frame frame;
        if (pvDisplayIf == null) {
            PsDebug.warning("missing display");
            return;
        }
        this.setOption(1, pvDisplayIf.hasPaintTag(64));
        this.setOption(2, pvDisplayIf.isEnabledAnimation());
        this.setOption(3, pvDisplayIf.isShowingAxes());
        this.setBackgroundColor(pvDisplayIf.getBackgroundColor());
        this.setOption(5, pvDisplayIf.isShowingBackImage());
        this.setOption(8, pvDisplayIf.isShowingBndBox());
        this.setOption(7, pvDisplayIf.hasPaintTag(4));
        this.setOption(9, pvDisplayIf.hasPaintTag(16384));
        this.setOption(10, pvDisplayIf.hasPaintTag(16));
        this.setOption(11, pvDisplayIf.isShowingDepthcue());
        this.setOption(12, pvDisplayIf.hasPaintTag(1));
        this.setOption(13, pvDisplayIf.isShowingEdgeAura());
        this.setForegroundColor(pvDisplayIf.getForegroundColor());
        this.setOption(15, pvDisplayIf.isShowingFrame());
        this.setOption(16, pvDisplayIf.hasPaintTag(256));
        this.setOption(18, pvDisplayIf.isShowingMagnet());
        this.setOption(19, pvDisplayIf.hasPaintTag(2048));
        this.setOption(20, pvDisplayIf.isEnabledPainters());
        this.setOption(22, pvDisplayIf.isShowingGrid());
        this.setOption(25, pvDisplayIf.isEnabledZBuffer());
        PvCameraIf[] pvCameraIfArray = pvDisplayIf.getCameras();
        int n = pvCameraIfArray.length;
        this.setNumCameras(n);
        int n2 = 0;
        while (n2 < n) {
            this.setCameraProjection(n2, pvCameraIfArray[n2].getProjectionMode());
            this.setCameraPosition(n2, pvCameraIfArray[n2].getPosition());
            this.setCameraInterest(n2, pvCameraIfArray[n2].getInterest());
            this.setCameraAngle(n2, pvCameraIfArray[n2].getFieldOfView());
            this.setCameraRoll(n2, pvCameraIfArray[n2].getRoll());
            this.setEnabledCameraClip(n2, pvCameraIfArray[n2].isEnabledClip());
            this.setCameraNearClip(n2, pvCameraIfArray[n2].getNearClip());
            this.setCameraFarClip(n2, pvCameraIfArray[n2].getFarClip());
            ++n2;
        }
        PvCameraIf pvCameraIf = pvDisplayIf.getCamera();
        if (pvCameraIf != null) {
            this.setCurrentCamera(pvCameraIf.getProjectionMode());
        }
        if ((frame = pvDisplayIf.getFrame()) != null) {
            cloneable = frame.location();
            if (cloneable != null) {
                this.setWindowPosition(cloneable.x, cloneable.y);
            } else {
                this.setWindowPosition(-1, -1);
            }
        }
        this.setTitle(pvDisplayIf.getName());
        cloneable = pvDisplayIf.getSize();
        this.setWindowSize(((Dimension)cloneable).width, ((Dimension)cloneable).height);
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public String getVersionType() {
        return this.m_versionType;
    }

    public void setVersionType(String string) {
        this.m_versionType = string;
    }

    public PdVector getCameraInterest(int n) {
        return this.m_cameraInterest[n];
    }

    public void setCameraInterest(int n, PdVector pdVector) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraInterest[n].copy(pdVector);
    }

    public void setEnabledCameraClip(int n, boolean bl) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraEnableClip[n] = bl;
    }

    public double getCameraNearClip(int n) {
        return this.m_cameraNearClip[n];
    }

    public void setCameraNearClip(int n, double d) {
        if (!this.assureCameraIndex(n)) {
            return;
        }
        this.m_cameraNearClip[n] = d;
    }

    public int getLightType(int n) {
        return this.m_lightType[n];
    }

    public void setLightType(int n, int n2) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightType[n] = n2;
    }

    public PdVector getLightInterest(int n) {
        return this.m_lightInterest[n];
    }

    public void setLightInterest(int n, PdVector pdVector) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightInterest[n] = pdVector;
    }

    public String getForegroundImageRepeat() {
        return this.m_foregroundImageRepeat;
    }

    public void setForegroundImageRepeat(String string) {
        this.m_foregroundImageRepeat = string;
    }

    public String getForegroundImage() {
        return this.m_foregroundImage;
    }

    public void setForegroundImage(String string) {
        this.m_foregroundImage = string;
    }

    public int getNumCameras() {
        return this.m_numCameras;
    }

    public void setNumCameras(int n) {
        if (n < 0) {
            PsDebug.warning("num = " + n + " < 0");
            return;
        }
        if (n == this.m_numCameras) {
            return;
        }
        this.m_numCameras = n;
        this.m_cameraProjection = PuData.realloc(this.m_cameraProjection, this.m_numCameras);
        this.m_cameraPosition = PdVector.realloc(this.m_cameraPosition, this.m_numCameras, this.m_dim);
        this.m_cameraInterest = PdVector.realloc(this.m_cameraInterest, this.m_numCameras, this.m_dim);
        this.m_cameraFieldOfView = PuData.realloc(this.m_cameraFieldOfView, this.m_numCameras);
        this.m_cameraRoll = PuData.realloc(this.m_cameraRoll, this.m_numCameras);
        this.m_cameraEnableTransform = PuData.realloc(this.m_cameraEnableTransform, this.m_numCameras);
        this.m_cameraAmbient = PuData.realloc(this.m_cameraAmbient, this.m_numCameras);
        this.m_cameraPerspective = PuData.realloc(this.m_cameraPerspective, this.m_numCameras);
        this.m_cameraEnableClip = PuData.realloc(this.m_cameraEnableClip, this.m_numCameras);
        this.m_cameraNearClip = PuData.realloc(this.m_cameraNearClip, this.m_numCameras);
        this.m_cameraFarClip = PuData.realloc(this.m_cameraFarClip, this.m_numCameras);
    }

    public String getBackgroundImageRepeat() {
        return this.m_backgroundImageRepeat;
    }

    public void setBackgroundImageRepeat(String string) {
        this.m_backgroundImageRepeat = string;
    }

    public PvDisplayOption() {
        this.setOption(1, false);
        this.setOption(2, false);
        this.setOption(3, false);
        this.setOption(4, false);
        this.setOption(5, false);
        this.setOption(8, false);
        this.setOption(7, true);
        this.setOption(9, false);
        this.setOption(10, false);
        this.setOption(11, true);
        this.setOption(12, true);
        this.setOption(13, false);
        this.setOption(14, false);
        this.setOption(15, false);
        this.setOption(16, false);
        this.setOption(17, false);
        this.setOption(18, false);
        this.setOption(19, false);
        this.setOption(20, true);
        this.setOption(21, true);
        this.setOption(22, false);
        this.setOption(23, false);
        this.setOption(24, false);
        this.setOption(25, false);
        this.m_dim = 3;
        this.m_axesLabel = new String[]{"x", "y", "z"};
    }

    public Color getLightColor(int n) {
        return this.m_lightColor[n];
    }

    public void setLightColor(int n, Color color) {
        if (!this.assureLightIndex(n)) {
            return;
        }
        this.m_lightColor[n] = color;
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.m_foregroundColor = color;
    }

    private boolean assureCameraIndex(int n) {
        if (n < 0) {
            PsDebug.warning("index = " + n + " < 0");
            return false;
        }
        if (n < this.m_numCameras) {
            return true;
        }
        this.setNumCameras(n + 1);
        return true;
    }

    private boolean assureLightIndex(int n) {
        if (n < 0) {
            PsDebug.warning("index = " + n + " < 0");
            return false;
        }
        if (n < this.m_numLights) {
            return true;
        }
        this.setNumLights(n + 1);
        return true;
    }

    public double getCameraAngle(int n) {
        return this.getCameraFieldOfView(n);
    }

    public void setCameraAngle(int n, double d) {
        this.setCameraFieldOfView(n, d);
    }

    public int getCameraPerspective(int n) {
        return this.m_cameraPerspective[n];
    }
}

