/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;

public class PiArray_IP
extends PsPanel
implements ActionListener,
AdjustmentListener,
ItemListener {
    protected PiVector[] m_vector;
    protected Scrollbar m_scroll;
    protected Panel m_coordPanel;
    protected TextField[][] m_text;
    protected Label[] m_headerLabel;
    protected Checkbox[] m_indexLabel;
    protected int m_index = 0;
    protected int m_shownDim = 0;
    protected int m_shownVectors = 0;
    protected int m_maxVisibleDim = 5;
    protected int m_maxVisibleVectors = 5;
    protected int m_minValue = Integer.MIN_VALUE;
    protected int m_maxValue = Integer.MAX_VALUE;
    private static /* synthetic */ Class class$jv$number$PiArray_IP;

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.m_scroll) {
            if (this.m_index == this.m_scroll.getValue()) {
                return;
            }
            this.m_index = this.m_scroll.getValue();
            int n = 0;
            while (n < this.m_shownVectors) {
                PiVector piVector = this.m_vector[n + this.m_index];
                this.m_indexLabel[n].setLabel(String.valueOf(n + this.m_index));
                this.m_indexLabel[n].setState(piVector.hasTag(1));
                int n2 = Math.min(this.m_shownDim, piVector.getSize());
                int n3 = 0;
                while (n3 < n2) {
                    if (this.m_minValue <= piVector.m_data[n3] && piVector.m_data[n3] <= this.m_maxValue) {
                        ((TextComponent)this.m_text[n][n3]).setText(String.valueOf(piVector.m_data[n3]));
                    }
                    ++n3;
                }
                n3 = n2;
                while (n3 < this.m_shownDim) {
                    ((TextComponent)this.m_text[n][n3]).setText("");
                    ++n3;
                }
                ++n;
            }
        }
    }

    public PiArray_IP(int n, int n2) {
        this.m_maxVisibleVectors = n;
        this.m_maxVisibleDim = n2;
        if (this.getClass() == (class$jv$number$PiArray_IP != null ? class$jv$number$PiArray_IP : (class$jv$number$PiArray_IP = PiArray_IP.class$("jv.number.PiArray_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        int n = 0;
        while (n < this.m_shownVectors) {
            if (object == this.m_indexLabel[n]) {
                PiVector piVector = this.m_vector[n + this.m_index];
                if (this.m_indexLabel[n].getState()) {
                    piVector.setTag(1);
                } else {
                    piVector.clearTag(1);
                }
                if (this.m_parent != null) {
                    this.m_parent.update(this);
                    return;
                }
                PsDebug.warning("missing parent");
                return;
            }
            ++n;
        }
    }

    public void setVector(PiVector[] piVectorArray, String[] stringArray, int n, int n2) {
        if (n2 < 0) {
            n2 = this.m_maxVisibleDim;
        }
        if (stringArray == null || piVectorArray == null) {
            PsDebug.warning("missing or empty argument");
            return;
        }
        this.m_vector = piVectorArray;
        if (!this.setNumOfEntries(n, n2)) {
            PsDebug.error("invalid length", this);
            return;
        }
        if (this.m_index >= n - this.m_shownVectors) {
            this.m_index = Math.max(0, n - this.m_shownVectors);
        }
        this.m_scroll.setValues(this.m_index, 1, 0, Math.max(0, n - this.m_shownVectors + 1));
        int n3 = 0;
        while (n3 < this.m_shownDim) {
            this.m_headerLabel[n3].setText(stringArray[n3]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.m_shownVectors) {
            this.m_indexLabel[n4].setLabel(String.valueOf(n4 + this.m_index));
            this.m_indexLabel[n4].setState(this.m_vector[n4 + this.m_index].hasTag(1));
            int n5 = Math.min(this.m_shownDim, this.m_vector[n4 + this.m_index].getSize());
            n3 = 0;
            while (n3 < n5) {
                ((TextComponent)this.m_text[n4][n3]).setText(String.valueOf(this.m_vector[n4 + this.m_index].m_data[n3]));
                ++n3;
            }
            n3 = n5;
            while (n3 < this.m_shownDim) {
                ((TextComponent)this.m_text[n4][n3]).setText("");
                ++n3;
            }
            ++n4;
        }
        if (this.m_shownVectors < this.m_maxVisibleVectors) {
            n4 = this.m_shownVectors;
            while (n4 < this.m_maxVisibleVectors) {
                this.m_indexLabel[n4].setLabel("");
                this.m_indexLabel[n4].setState(false);
                n3 = 0;
                while (n3 < this.m_shownDim) {
                    ((TextComponent)this.m_text[n4][n3]).setText("");
                    ++n3;
                }
                ++n4;
            }
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
    }

    public boolean update(Object object) {
        if (this.m_parent == null) {
            PsDebug.warning("missing parent");
            return true;
        }
        if (object == this.m_parent) {
            int n = 0;
            int n2 = 0;
            try {
                n = 0;
                while (n < this.m_shownVectors) {
                    PiVector piVector = this.m_vector[n + this.m_index];
                    this.m_indexLabel[n].setLabel(String.valueOf(n + this.m_index));
                    this.m_indexLabel[n].setState(piVector.hasTag(1));
                    int n3 = Math.min(this.m_shownDim, piVector.getSize());
                    n2 = 0;
                    while (n2 < n3) {
                        if (this.m_minValue <= piVector.m_data[n2] && piVector.m_data[n2] <= this.m_maxValue) {
                            ((TextComponent)this.m_text[n][n2]).setText(String.valueOf(piVector.m_data[n2]));
                        }
                        ++n2;
                    }
                    n2 = n3;
                    while (n2 < this.m_shownDim) {
                        ((TextComponent)this.m_text[n][n2]).setText("");
                        ++n2;
                    }
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format = " + this.m_text[n][n2].getText());
                return false;
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 0;
        while (n < this.m_shownVectors) {
            PiVector piVector = this.m_vector[n + this.m_index];
            int n2 = 0;
            while (n2 < this.m_shownDim) {
                if (object == this.m_text[n][n2]) {
                    if (n2 >= piVector.getSize()) {
                        piVector.setSize(n2 + 1);
                        PsDebug.warning("empty field edited, j=" + n2);
                    }
                    try {
                        int n3 = Integer.parseInt(this.m_text[n][n2].getText());
                        if (this.m_minValue <= n3 && n3 <= this.m_maxValue) {
                            piVector.m_data[n2] = n3;
                        } else {
                            PsDebug.warning("value out of range = " + n3);
                            ((TextComponent)this.m_text[n][n2]).setText(String.valueOf(piVector.m_data[n2]));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        PsDebug.warning("wrong format = " + this.m_text[n][n2].getText());
                        return;
                    }
                    this.m_parent.update(this);
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean setNumOfEntries(int n, int n2) {
        if (n == -1) {
            n = this.m_maxVisibleVectors;
        }
        if (n2 == -1) {
            n2 = this.m_maxVisibleDim;
        }
        if (this.m_shownDim == Math.min(this.m_maxVisibleDim, n2) && this.m_shownVectors == Math.min(this.m_maxVisibleVectors, n)) {
            return true;
        }
        if (n > this.m_maxVisibleVectors) {
            // empty if block
        }
        if (n2 > this.m_maxVisibleDim) {
            // empty if block
        }
        this.m_coordPanel.removeAll();
        this.m_shownVectors = Math.min(this.m_maxVisibleVectors, n);
        this.m_shownDim = Math.min(this.m_maxVisibleDim, n2);
        this.m_coordPanel.setLayout(new GridLayout(this.m_maxVisibleVectors + 1, this.m_shownDim));
        this.m_headerLabel = new Label[this.m_shownDim];
        int n3 = 0;
        while (n3 < this.m_shownDim) {
            this.m_headerLabel[n3] = new Label("", 1);
            this.m_coordPanel.add(this.m_headerLabel[n3]);
            ++n3;
        }
        this.m_text = new TextField[this.m_maxVisibleVectors][];
        int n4 = 0;
        while (n4 < this.m_maxVisibleVectors) {
            this.m_text[n4] = new TextField[this.m_shownDim];
            n3 = 0;
            while (n3 < this.m_shownDim) {
                this.m_text[n4][n3] = new TextField(10);
                this.m_text[n4][n3].addActionListener(this);
                this.m_coordPanel.add(this.m_text[n4][n3]);
                ++n3;
            }
            ++n4;
        }
        this.m_coordPanel.validate();
        return true;
    }

    public void setBounds(int n, int n2) {
        if (n > n2) {
            return;
        }
        this.m_minValue = n;
        this.m_maxValue = n2;
    }

    public void init() {
        super.init();
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label(PsConfig.getMessage("Index"), 2));
        this.m_scroll = new Scrollbar(1);
        this.m_scroll.addAdjustmentListener(this);
        panel.add("West", this.m_scroll);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(this.m_maxVisibleVectors, 1));
        this.m_indexLabel = new Checkbox[this.m_maxVisibleVectors];
        int n = 0;
        while (n < this.m_maxVisibleVectors) {
            this.m_indexLabel[n] = new Checkbox(String.valueOf(n));
            this.m_indexLabel[n].addItemListener(this);
            panel2.add(this.m_indexLabel[n]);
            ++n;
        }
        panel.add("Center", panel2);
        this.m_coordPanel = new Panel();
        this.add("West", panel);
        this.add("Center", this.m_coordPanel);
    }
}

