/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUtil;
import jv.objectGui.PsMethodMenu;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgGeometry
extends PsObject
implements PgGeometryIf,
Cloneable {
    protected String m_version = "0.10";
    protected String m_versionType = "dump";
    protected String m_title;
    protected PsAuthorInfo m_authorInfo;
    protected PsGeometryInfo m_geometryInfo;
    protected int m_dim;
    protected int m_dimOfSimplex = 0;
    protected boolean m_bShowing = true;
    protected boolean m_bShowTitle;
    protected boolean m_bShowBndBox;
    protected boolean m_bShowCenter;
    protected PdVector m_center = null;
    protected int m_ambientSpace = 3;
    protected int m_ambientProj = 0;
    protected PdMatrix m_modelMatrix = null;
    protected PdMatrix m_ambientMatrix;
    protected PdMatrix m_ambientInvMatrix;
    protected transient PsMethodMenu m_methodMenu = null;
    protected Vector m_displayList = null;
    protected PiVector[] m_labelAttribute = PiVector.realloc(null, 6, 4);

    public int addPolygon(PiVector piVector) {
        return -1;
    }

    public boolean hasTagPolygon(int n, int n2) {
        return false;
    }

    public Image getTextureImage() {
        return null;
    }

    public void setTextureImage(Image image) {
        PsDebug.warning("missing implementation of method in subclass.");
    }

    public void setState(int n, boolean bl) {
        PsDebug.warning("invalid key = " + n);
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        return null;
    }

    public boolean isShowingBndBox() {
        return this.m_bShowBndBox;
    }

    public PsPanel getMaterialPanel() {
        return this.assureInspector("Material", "_MP");
    }

    public void showBndBox(boolean bl) {
        this.m_bShowBndBox = bl;
    }

    public int getAmbientProjection() {
        return this.m_ambientProj;
    }

    public void setAmbientProjection(int n) {
        this.m_ambientProj = n;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public int addElement(PiVector piVector) {
        return -1;
    }

    public boolean hasTagElement(int n, int n2) {
        return false;
    }

    public boolean isVisible() {
        return this.m_bShowing;
    }

    public int addVertex(PdVector pdVector) {
        return -1;
    }

    public boolean hasTagVertex(int n, int n2) {
        return false;
    }

    public Object clone() {
        PgGeometry pgGeometry = (PgGeometry)super.clone();
        if (pgGeometry == null) {
            return null;
        }
        if (this.m_authorInfo != null) {
            pgGeometry.m_authorInfo = (PsAuthorInfo)this.m_authorInfo.clone();
        }
        if (this.m_geometryInfo != null) {
            pgGeometry.m_geometryInfo = (PsGeometryInfo)this.m_geometryInfo.clone();
        }
        if (this.m_center != null) {
            pgGeometry.m_center = (PdVector)this.m_center.clone();
        }
        if (this.m_modelMatrix != null) {
            pgGeometry.m_modelMatrix = (PdMatrix)this.m_modelMatrix.clone();
        }
        if (this.m_ambientMatrix != null) {
            pgGeometry.m_ambientMatrix = (PdMatrix)this.m_ambientMatrix.clone();
            pgGeometry.m_ambientInvMatrix = (PdMatrix)this.m_ambientInvMatrix.clone();
        }
        pgGeometry.m_methodMenu = null;
        pgGeometry.m_displayList = null;
        pgGeometry.m_labelAttribute = (PiVector[])P_Vector.clone(this.m_labelAttribute);
        return pgGeometry;
    }

    public int getAmbientSpace() {
        return this.m_ambientSpace;
    }

    public void setAmbientSpace(int n) {
        this.m_ambientSpace = n;
    }

    public Enumeration getDisplays() {
        if (this.m_displayList == null) {
            return null;
        }
        return this.m_displayList.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgGeometry ***********\n");
        stringBuffer.append("\t Title = " + this.getTitle());
        stringBuffer.append("\t Registered Displays:\n");
        if (this.m_displayList != null) {
            Enumeration enumeration = this.m_displayList.elements();
            while (enumeration.hasMoreElements()) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                stringBuffer.append("\t\t display = " + pvDisplayIf.getName() + "\n");
            }
        } else {
            stringBuffer.append("\t\t no displays\n");
        }
        stringBuffer.append("\t Dimension of vertices: m_dim = " + this.m_dim + "\n");
        return stringBuffer.toString();
    }

    public PdMatrix getAmbientInvMatrix() {
        if (this.m_ambientMatrix == null) {
            this.m_ambientMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientInvMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientMatrix.setIdentity();
            this.m_ambientInvMatrix.setIdentity();
        }
        return this.m_ambientInvMatrix;
    }

    public PdVector getCenter() {
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        return this.m_center;
    }

    public void setCenter(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument.");
            return;
        }
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        this.m_center.copy(pdVector);
    }

    public boolean isShowingCenter() {
        return this.m_bShowCenter;
    }

    public String getTextureImageName() {
        return null;
    }

    public void setTextureImageName(String string) {
        PsDebug.warning("missing implementation of method in subclass.");
    }

    public void showCenter(boolean bl) {
        this.m_bShowCenter = bl;
    }

    public PdVector[] getAmbientBounds() {
        PdVector[] pdVectorArray = new PdVector[]{new PdVector(this.m_dim), new PdVector(this.m_dim)};
        return pdVectorArray;
    }

    public void copy(PgGeometry pgGeometry) {
        super.copy(pgGeometry);
        if (pgGeometry.getTitle() != null) {
            this.setTitle(pgGeometry.getTitle());
        }
        this.setCenter(pgGeometry.getCenter());
        PiVector.copy(this.m_labelAttribute, 0, pgGeometry.m_labelAttribute, 0, pgGeometry.m_labelAttribute.length);
    }

    public double getDiameter() {
        PdVector[] pdVectorArray = this.getBounds();
        if (pdVectorArray == null) {
            return 0.0;
        }
        return PdVector.dist(pdVectorArray[0], pdVectorArray[1]);
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgGeometry pgGeometry = (PgGeometry)this.clone();
        String string = this.getName();
        if (string == null || !string.startsWith("Reflect")) {
            string = "Reflect(0) of " + string;
        } else {
            String string2;
            int n;
            int n2 = string.indexOf("(");
            if (n2 != -1) {
                n = string.indexOf(")");
                string2 = string.substring(n2 + 1, n);
                n2 = Integer.parseInt(string2) + 1;
            }
            n = string.indexOf(" of ");
            string2 = string.substring(n + 4, string.length());
            string = "Reflect(" + n2 + ") of " + string2;
        }
        pgGeometry.setName(string);
        return pgGeometry;
    }

    public void init() {
        super.init();
        this.m_bShowing = true;
        this.m_bShowBndBox = false;
        this.m_bShowCenter = false;
        this.m_bShowTitle = false;
    }

    public Menu fillMethodMenu(Menu menu) {
        Class clazz;
        if (this.m_methodMenu == null || !this.m_methodMenu.getLanguage().equals(PsConfig.getLanguage())) {
            this.m_methodMenu = (PsMethodMenu)PsUtil.newInstance(this.getClass(), "_Menu");
            if (this.m_methodMenu == null) {
                PsDebug.warning("could not create menu");
                return null;
            }
            this.m_methodMenu.init(this);
            clazz = this.getClass();
            try {
                do {
                    String string = clazz.getName();
                    String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
                    PsMethodMenu psMethodMenu = (PsMethodMenu)PsUtil.newInstance("jvx.geom." + string2 + "_Menu");
                    if (psMethodMenu == null) continue;
                    Enumeration enumeration = this.m_methodMenu.elements();
                    while (enumeration.hasMoreElements()) {
                        psMethodMenu.addElement((MenuItem)enumeration.nextElement());
                    }
                    psMethodMenu.init(this);
                    this.m_methodMenu.removeAllElements();
                    enumeration = psMethodMenu.elements();
                    while (enumeration.hasMoreElements()) {
                        this.m_methodMenu.addElement((MenuItem)enumeration.nextElement());
                    }
                    break;
                } while ((clazz = clazz.getSuperclass()) != null);
            }
            catch (SecurityException securityException) {
                PsDebug.warning("failed with security exception,\n\t SecurityExceptionEx = " + securityException.toString() + ", Message = " + securityException.getMessage());
            }
        }
        menu.removeAll();
        clazz = this.m_methodMenu.elements();
        while (clazz.hasMoreElements()) {
            menu.add((MenuItem)clazz.nextElement());
        }
        return menu;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing argument.", this);
            return false;
        }
        if (this.getDimOfVertices() != pgGeometryIf.getDimOfVertices()) {
            PsDebug.warning("different dimension of vertices.", this);
            return false;
        }
        return true;
    }

    public PiVector getElement(int n) {
        return null;
    }

    public boolean setElement(int n, PiVector piVector) {
        return false;
    }

    public void clearTagElement(int n, int n2) {
    }

    public static PdVector getCenterOfElement(PdVector pdVector, PdVector[] pdVectorArray, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            PsDebug.warning("missing index array");
            return pdVector;
        }
        pdVector.copyArray(pdVectorArray[nArray[0]]);
        int n = 1;
        while (n < nArray.length) {
            pdVector.add(pdVectorArray[nArray[n]]);
            ++n;
        }
        pdVector.multScalar(1.0 / (double)nArray.length);
        return pdVector;
    }

    public int getDimOfVertices() {
        return this.m_dim;
    }

    protected void setDimOfVertices(int n) {
        if (this.m_dim == n) {
            return;
        }
        this.m_dim = n;
        switch (this.m_dim) {
            default: {
                this.setAmbientSpace(3);
                break;
            }
            case 5: {
                this.setAmbientSpace(9);
                break;
            }
            case 4: {
                this.setAmbientSpace(6);
                break;
            }
            case 2: {
                this.setAmbientSpace(1);
                break;
            }
            case 1: {
                this.setAmbientSpace(0);
            }
        }
        this.setAmbientProjection(0);
    }

    public boolean hasDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.contains(pvDisplayIf);
    }

    public boolean removeDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.removeElement(pvDisplayIf);
    }

    public boolean update(Object object) {
        Object object2;
        if (!super.update(object)) {
            object2 = "super has returned 'false'\n\tthis     = " + this.getClass().getName() + ", name " + this.getName() + "\n\tevent    = ";
            object2 = object == null ? (String)object2 + "null" : (object instanceof PsObject ? (String)object2 + object.getClass().getName() + ", name=" + ((PsObject)object).getName() : (object instanceof PsPanel ? (String)object2 + object.getClass().getName() + ", name=" + ((PsPanel)object).getName() : (String)object2 + object.getClass().getName()));
            PsDebug.warning((String)object2);
        }
        if (this.m_displayList != null) {
            object2 = this.m_displayList.elements();
            while (object2.hasMoreElements()) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)object2.nextElement();
                pvDisplayIf.update(this);
            }
        }
        if (this.m_methodMenu != null) {
            this.m_methodMenu.update(this);
        }
        return true;
    }

    public PiVector getLabelAttribute(int n) {
        if (n < 0 || this.m_labelAttribute.length <= n) {
            PsDebug.warning("type out of bounds, type = " + n);
            return null;
        }
        return this.m_labelAttribute[n];
    }

    public boolean setLabelAttribute(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 0 || this.m_labelAttribute.length <= n) {
            PsDebug.warning("type=" + n + " out of bounds.");
            return false;
        }
        this.m_labelAttribute[n].setEntry(0, n2);
        this.m_labelAttribute[n].setEntry(1, n3);
        this.m_labelAttribute[n].setEntry(2, n4);
        this.m_labelAttribute[n].setEntry(3, n5);
        this.m_labelAttribute[n].setEntry(4, n6);
        return true;
    }

    public boolean setLabelAttribute(int n, PiVector piVector) {
        if (piVector == null || piVector.getSize() < 5) {
            PsDebug.warning("missing attribute parameter.");
            return false;
        }
        int[] nArray = piVector.getEntries();
        this.setLabelAttribute(n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
        return true;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public int getDimOfSimplex() {
        return this.m_dimOfSimplex;
    }

    public void setDimOfSimplex(int n) {
        this.m_dimOfSimplex = n;
    }

    public boolean isShowingTitle() {
        return this.m_bShowTitle;
    }

    public PiVector getPolygon(int n) {
        return null;
    }

    public boolean setPolygon(int n, PiVector piVector) {
        return false;
    }

    public void clearTagPolygon(int n, int n2) {
    }

    public String getVersionType() {
        return this.m_versionType;
    }

    public void setVersionType(String string) {
        this.m_versionType = string;
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = new PdVector[]{new PdVector(3), new PdVector(3)};
        return pdVectorArray;
    }

    public void showTitle(boolean bl) {
        this.m_bShowTitle = bl;
    }

    public PsAuthorInfo getAuthors() {
        return this.m_authorInfo;
    }

    public void setAuthors(PsAuthorInfo psAuthorInfo) {
        this.m_authorInfo = psAuthorInfo;
    }

    public PsPanel getControlPanel() {
        return this.assureInspector("Control", "_CP");
    }

    public boolean isConfigurable(int n) {
        return this.hasTag(n);
    }

    public int[] removePolygon(int n) {
        return null;
    }

    public void setTagPolygon(int n, int n2) {
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        pvGeometryIf.setVisible(this.isVisible());
        pvGeometryIf.setState(69, this.m_bShowBndBox);
        pvGeometryIf.setState(70, this.m_bShowCenter);
        pvGeometryIf.setState(86, this.m_bShowTitle);
        pvGeometryIf.setLabelAttributes(this.m_labelAttribute);
        pvGeometryIf.setAmbientSpace(this.getAmbientSpace());
        pvGeometryIf.setAmbientProjection(this.getAmbientProjection());
        if (this.hasModelMatrix()) {
            pvGeometryIf.setModelMatrix(this.getModelMatrix());
        }
        if (this.hasAmbientMatrix()) {
            pvGeometryIf.setAmbientMatrix(this.getAmbientMatrix(), this.getAmbientInvMatrix());
        }
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (pgGeometry == null && pgGeometry2 == null) {
            PsDebug.warning("missing arguments");
            return false;
        }
        if (pgGeometry == null) {
            this.copy(pgGeometry2);
            return true;
        }
        if (pgGeometry2 == null) {
            this.copy(pgGeometry);
            return true;
        }
        this.m_dim = pgGeometry.getDimOfVertices();
        return true;
    }

    public int[] removeElement(int n) {
        return null;
    }

    public PdVector getVertex(int n) {
        return null;
    }

    public boolean setVertex(int n, PdVector pdVector) {
        return false;
    }

    public void clearTagVertex(int n, int n2) {
    }

    public void setVisible(boolean bl) {
        this.m_bShowing = bl;
    }

    public void setTagElement(int n, int n2) {
    }

    public PgGeometry() {
        this.setLabelAttribute(0, 0, 0, 0, 0, 1);
        this.setLabelAttribute(1, 4, 4, 0, 0, 1);
        this.setLabelAttribute(2, -10, 10, 0, 0, 1);
        this.setLabelAttribute(3, -3, 5, 0, 0, 1);
        this.setLabelAttribute(4, -3, 5, 0, 0, 1);
        this.setLabelAttribute(5, 4, 4, 0, 0, 3);
    }

    public PgGeometry(int n) {
        this();
        this.setDimOfVertices(n);
    }

    public PsGeometryInfo getGeometryInfo() {
        return this.m_geometryInfo;
    }

    public void setGeometryInfo(PsGeometryInfo psGeometryInfo) {
        this.m_geometryInfo = psGeometryInfo;
    }

    public int[] removeVertex(int n) {
        return null;
    }

    public void setTagVertex(int n, int n2) {
    }

    public PsAuthorInfo getAuthorInfo() {
        return this.m_authorInfo;
    }

    public void setAuthorInfo(PsAuthorInfo psAuthorInfo) {
        this.m_authorInfo = psAuthorInfo;
    }

    public PdMatrix getModelMatrix() {
        if (this.m_modelMatrix == null) {
            this.m_modelMatrix = new PdMatrix(4);
            this.m_modelMatrix.setIdentity();
        }
        return PdMatrix.copyNew(this.m_modelMatrix);
    }

    public void setModelMatrix(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            this.m_modelMatrix = null;
            return;
        }
        if (this.m_modelMatrix == null) {
            this.m_modelMatrix = new PdMatrix(4);
        }
        this.m_modelMatrix.copy(pdMatrix);
    }

    public PdMatrix getAmbientMatrix() {
        if (this.m_ambientMatrix == null) {
            this.m_ambientMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientInvMatrix = new PdMatrix(this.m_dim + 1);
            this.m_ambientMatrix.setIdentity();
            this.m_ambientInvMatrix.setIdentity();
        }
        return this.m_ambientMatrix;
    }

    public void setAmbientMatrix(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (pdMatrix == null) {
            this.m_ambientMatrix = null;
            this.m_ambientInvMatrix = null;
            return;
        }
        if (this.m_ambientMatrix == null) {
            this.m_ambientMatrix = (PdMatrix)pdMatrix.clone();
            this.m_ambientInvMatrix = (PdMatrix)pdMatrix2.clone();
        }
        this.m_ambientMatrix.copy(pdMatrix);
        this.m_ambientInvMatrix.copy(pdMatrix2);
    }

    public boolean addDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            this.m_displayList = new Vector();
        } else if (this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display = " + pvDisplayIf.getName() + " of display already used.");
            return false;
        }
        this.m_displayList.addElement(pvDisplayIf);
        return true;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        pgJvxSrc.setName(this.getName());
        pgJvxSrc.setVersion(this.getVersion());
        pgJvxSrc.setVersionType(this.getVersionType());
        pgJvxSrc.setTitle(this.getTitle());
        pgJvxSrc.setAuthorInfo(this.getAuthorInfo());
        pgJvxSrc.setGeometryInfo(this.getGeometryInfo());
        pgJvxSrc.setDimOfVertices(this.getDimOfVertices());
        pgJvxSrc.setDimOfSimplex(this.getDimOfSimplex());
        pgJvxSrc.setVisible(this.isVisible());
        pgJvxSrc.showBndBox(this.isShowingBndBox());
        pgJvxSrc.showCenter(this.isShowingCenter());
        pgJvxSrc.showTitle(this.isShowingTitle());
        PiVector.copy(pgJvxSrc.m_labelAttribute, 0, this.m_labelAttribute, 0, this.m_labelAttribute.length);
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        this.init();
        this.setName(pgJvxSrc.getName());
        this.setVersion(pgJvxSrc.getVersion());
        this.setVersionType(pgJvxSrc.getVersionType());
        this.setTitle(pgJvxSrc.getTitle());
        this.setAuthorInfo(pgJvxSrc.getAuthorInfo());
        this.setGeometryInfo(pgJvxSrc.getGeometryInfo());
        this.setDimOfSimplex(pgJvxSrc.getDimOfSimplex());
        this.m_dim = pgJvxSrc.getDimOfVertices();
        this.setVisible(pgJvxSrc.isVisible());
        this.showBndBox(pgJvxSrc.isShowingBndBox());
        this.showCenter(pgJvxSrc.isShowingCenter());
        this.showTitle(pgJvxSrc.isShowingTitle());
        PiVector.copy(this.m_labelAttribute, 0, pgJvxSrc.m_labelAttribute, 0, pgJvxSrc.m_labelAttribute.length);
    }

    public boolean hasModelMatrix() {
        return this.m_modelMatrix != null;
    }

    public boolean hasAmbientMatrix() {
        return this.m_ambientMatrix != null;
    }
}

