/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsMainFrame;
import jv.object.PsPanel;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.viewer.PvControlMenu;
import jv.viewer.PvViewer;

final class PvControl
extends PsMainFrame
implements ActionListener {
    private static final int NUM_PANELS = 7;
    private static final int PROJECT_ARR = 0;
    private static final int INFO_ARR = 1;
    private static final int MATERIAL_ARR = 2;
    private static final int TEXTURE_ARR = 3;
    private static final int CONFIG_ARR = 4;
    private static final int CAMERA_ARR = 5;
    private static final int DISPLAY_ARR = 6;
    protected static final String[] m_panelName = new String[]{"Project", "Info", "Material", "Texture", "Config", "Camera", "Display"};
    protected Panel[] m_oldPanel = new Panel[7];
    protected boolean[] m_bPanelOutside = new boolean[7];
    protected CardLayout m_crd;
    protected Panel m_inspector;
    protected int m_currentPanel_Id;
    protected Panel m_currentPanel;
    private boolean m_firstShowing;
    protected PvControlMenu m_menuBar;
    protected PvViewer m_viewer;
    protected PjProject m_project;
    protected PgGeometryIf m_geometry;
    protected PvDisplayIf m_display;

    protected void setProject(PjProject pjProject) {
        if (pjProject == null) {
            this.enableMenu(21, false);
            this.m_project = null;
            return;
        }
        if (this.m_project == pjProject) {
            return;
        }
        this.enableMenu(21, true);
        this.m_project = pjProject;
        this.m_currentPanel_Id = 0;
        if (this.isShowing()) {
            this.addInspectorPanel(this.m_currentPanel_Id, this.m_project.getInfoPanel());
            this.m_crd.show(this.m_inspector, m_panelName[this.m_currentPanel_Id]);
        }
        this.enableMenu(40, this.m_project.hasAnimation());
    }

    protected PvDisplayIf getDisplay() {
        return this.m_display;
    }

    protected void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_display == pvDisplayIf) {
            return;
        }
        this.m_display = pvDisplayIf;
        this.removeInspectorPanel(6);
        if (this.isShowing() && this.m_currentPanel_Id == 6) {
            this.showPanel(17);
        }
        this.removeInspectorPanel(5);
        if (this.isShowing() && this.m_currentPanel_Id == 5) {
            this.showPanel(16);
        }
    }

    private void addInspectorPanel(int n, Panel panel) {
        if (panel == null) {
            return;
        }
        if (this.m_oldPanel[n] == panel) {
            return;
        }
        if (this.m_oldPanel[n] != null) {
            this.m_inspector.remove(this.m_oldPanel[n]);
            this.m_oldPanel[n] = panel;
        } else {
            this.m_oldPanel[n] = panel;
        }
        this.m_inspector.add(m_panelName[n], panel);
        this.m_inspector.validate();
    }

    public PvControl(PvViewer pvViewer) {
        super(PsConfig.getProgram() + " v" + PsConfig.getVersion() + " - " + PsConfig.getMessage("Control"), (String[])null);
        this.m_viewer = pvViewer;
        this.addKeyListener(this.m_viewer);
        this.m_firstShowing = true;
        this.m_currentPanel_Id = 0;
        this.init();
    }

    public void setVisible(boolean bl) {
        if (!bl || !this.m_firstShowing) {
            super.setVisible(bl);
            return;
        }
        this.m_firstShowing = false;
        this.m_currentPanel = this.assurePanelAtPosition(this.m_currentPanel_Id);
        if (this.m_currentPanel == null || this.m_bPanelOutside[this.m_currentPanel_Id]) {
            int n = 1;
            do {
                this.enablePanel(PvViewer.getPanelId(m_panelName[this.m_currentPanel_Id]), false);
                this.m_currentPanel_Id = (this.m_currentPanel_Id + n) % 7;
                this.m_currentPanel = this.assurePanelAtPosition(this.m_currentPanel_Id);
            } while ((this.m_currentPanel == null || this.m_bPanelOutside[this.m_currentPanel_Id]) && ++n <= 7);
            if (this.m_currentPanel == null) {
                PsDebug.error("missing panel = " + m_panelName[this.m_currentPanel_Id], this);
                return;
            }
        }
        if (this.m_geometry != null) {
            this.m_geometry.fillMethodMenu(this.m_menuBar.m_mMethod);
        }
        this.addInspectorPanel(this.m_currentPanel_Id, this.m_currentPanel);
        this.m_crd.show(this.m_inspector, m_panelName[this.m_currentPanel_Id]);
        this.pack();
        this.setLocation(this.m_viewer.m_controlSize[0], this.m_viewer.m_controlSize[1]);
        ((Component)this).setSize(this.m_viewer.m_controlSize[2], this.m_viewer.m_controlSize[3]);
        super.setVisible(true);
    }

    private Panel assurePanelAtPosition(int n) {
        PsPanel psPanel = null;
        if (this.m_oldPanel[n] != null) {
            return this.m_oldPanel[n];
        }
        switch (n) {
            case 0: {
                if (this.m_project == null) {
                    return null;
                }
                psPanel = this.m_project.getInfoPanel();
                break;
            }
            case 1: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Info", "_IP");
                break;
            }
            case 2: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Material", "_MP");
                break;
            }
            case 3: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Texture", "_TP");
                break;
            }
            case 4: {
                if (this.m_geometry == null) {
                    return null;
                }
                psPanel = this.m_geometry.assureInspector("Control", "_CP");
                break;
            }
            case 5: {
                if (this.m_display == null) {
                    return null;
                }
                psPanel = this.m_display.getCameraPanel();
                break;
            }
            case 6: {
                if (this.m_display == null) {
                    return null;
                }
                psPanel = this.m_display.getInfoPanel();
                break;
            }
            default: {
                PsDebug.warning("index of panel = " + n + " not found");
                return null;
            }
        }
        if (psPanel == null) {
            return null;
        }
        return psPanel;
    }

    protected void removeProject(PjProject pjProject) {
        if (pjProject == null) {
            return;
        }
        if (this.m_project != pjProject) {
            PsDebug.warning("project = " + pjProject.getName() + " not registered");
            return;
        }
        this.removeInspectorPanel(1);
        this.removeInspectorPanel(2);
        this.removeInspectorPanel(3);
        this.removeInspectorPanel(4);
        this.removeInspectorPanel(0);
        this.m_oldPanel[1] = null;
        this.m_oldPanel[2] = null;
        this.m_oldPanel[3] = null;
        this.m_oldPanel[4] = null;
        this.m_oldPanel[0] = null;
        if (this.m_menuBar != null && this.m_menuBar.m_mMethod != null) {
            this.m_menuBar.m_mMethod.removeAll();
        }
        this.m_project = null;
        this.m_geometry = null;
    }

    private void setLanguage(String string) {
        PsConfig.setLanguage(string);
        this.m_menuBar = new PvControlMenu(this);
        if (this.m_geometry != null) {
            this.m_geometry.fillMethodMenu(this.m_menuBar.m_mMethod);
        }
        this.setMenuBar(this.m_menuBar);
        if (this.hasInspectorPanel(0)) {
            this.removeInspectorPanel(0);
        }
        if (this.hasInspectorPanel(1)) {
            this.removeInspectorPanel(1);
        }
        if (this.hasInspectorPanel(2)) {
            this.removeInspectorPanel(2);
        }
        if (this.hasInspectorPanel(3)) {
            this.removeInspectorPanel(3);
        }
        if (this.hasInspectorPanel(4)) {
            this.removeInspectorPanel(4);
        }
        if (this.hasInspectorPanel(5)) {
            this.removeInspectorPanel(5);
        }
        if (this.hasInspectorPanel(6)) {
            this.removeInspectorPanel(6);
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.m_currentPanel_Id == 0) {
            this.showPanel(10);
            return;
        }
        if (this.m_currentPanel_Id == 1) {
            this.showPanel(12);
            return;
        }
        if (this.m_currentPanel_Id == 2) {
            this.showPanel(13);
            return;
        }
        if (this.m_currentPanel_Id == 3) {
            this.showPanel(14);
            return;
        }
        if (this.m_currentPanel_Id == 4) {
            this.showPanel(15);
            return;
        }
        if (this.m_currentPanel_Id == 5) {
            this.showPanel(16);
            return;
        }
        if (this.m_currentPanel_Id == 6) {
            this.showPanel(17);
        }
    }

    public boolean update(Object object) {
        if (this.m_viewer != null) {
            return this.m_viewer.update(this);
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (this.m_menuBar == null) {
            return;
        }
        if (object == this.m_menuBar.m_mFile_New_Project) {
            this.m_viewer.showDialog(27);
            return;
        }
        if (object == this.m_menuBar.m_mFile_New_Geometry) {
            this.m_viewer.showDialog(29);
            return;
        }
        if (object == this.m_menuBar.m_mFile_New_Display) {
            this.m_viewer.newDisplay();
            return;
        }
        if (object == this.m_menuBar.m_mFile_Add_Project) {
            this.m_viewer.showDialog(28);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Add_Geometry) {
            this.m_viewer.showDialog(30);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Import_VGP) {
            this.m_viewer.showDialog(31);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Import_DISK) {
            this.m_viewer.showDialog(32);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Import_Deserialize) {
            this.m_viewer.deserialize();
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_BYU) {
            this.m_viewer.showDialog(33);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_FE) {
            this.m_viewer.showDialog(34);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_JVX) {
            this.m_viewer.showDialog(35);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_JVX_SMALL) {
            this.m_viewer.showDialog(351);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_MGS) {
            this.m_viewer.showDialog(36);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_MPL) {
            this.m_viewer.showDialog(37);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_OBJ) {
            this.m_viewer.showDialog(38);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_OFF) {
            this.m_viewer.showDialog(39);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_VRML) {
            this.m_viewer.showDialog(40);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_GIF) {
            this.m_viewer.showDialog(41);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_GIF_ANIM) {
            this.m_viewer.showDialog(42);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_PPM) {
            this.m_viewer.showDialog(43);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_PPM_ANIM) {
            this.m_viewer.showDialog(44);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_Serialize_Applet || object == this.m_menuBar.m_mFile_Export_Serialize_Display || object == this.m_menuBar.m_mFile_Export_Serialize_Geometry || object == this.m_menuBar.m_mFile_Export_Serialize_Project) {
            this.m_viewer.serialize(string);
            return;
        }
        if (object == this.m_menuBar.m_mFILE_PRINT_EPS) {
            this.m_viewer.showDialog(46);
            return;
        }
        if (object == this.m_menuBar.m_mFILE_PRINT_PS) {
            this.m_viewer.showDialog(47);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Export_JVD) {
            this.m_viewer.showDialog(48);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Submit) {
            this.m_viewer.submit();
            return;
        }
        if (object == this.m_menuBar.m_mFile_Close) {
            this.setVisible(false);
            return;
        }
        if (object == this.m_menuBar.m_mFile_Exit) {
            this.m_viewer.destroy();
            return;
        }
        if (object == this.m_menuBar.m_mInspector_Project) {
            this.showPanel(10);
            return;
        }
        if (object == this.m_menuBar.m_mInspector_Object_Info) {
            this.showPanel(12);
            return;
        }
        if (object == this.m_menuBar.m_mInspector_Object_Material) {
            this.showPanel(13);
            return;
        }
        if (object == this.m_menuBar.m_mInspector_Object_Texture) {
            this.showPanel(14);
            return;
        }
        if (object == this.m_menuBar.m_mInspector_Object_Config) {
            this.showPanel(15);
            return;
        }
        if (object == this.m_menuBar.m_mInspector_Camera) {
            this.showPanel(16);
            return;
        }
        if (object == this.m_menuBar.m_mInspector_Display) {
            this.showPanel(17);
            return;
        }
        if (object == this.m_menuBar.m_mWindow_Animation) {
            this.m_viewer.showDialog(23);
            return;
        }
        if (object == this.m_menuBar.m_mWindow_Console) {
            this.m_viewer.showDialog(25);
            return;
        }
        if (object == this.m_menuBar.m_mHelp_Garbage) {
            Runtime runtime = Runtime.getRuntime();
            PsDebug.message("free memory (before gc) = " + String.valueOf(runtime.freeMemory()));
            System.gc();
            PsDebug.message("free memory (after gc)  = " + String.valueOf(runtime.freeMemory()));
            return;
        }
        if (object == this.m_menuBar.m_mWindow_Network) {
            PsDebug.warning("network viewer not implemented yet.");
            return;
        }
        if (object == this.m_menuBar.m_mHelp_Rsrc) {
            this.m_viewer.showDialog(20);
            return;
        }
        if (object == this.m_menuBar.m_mHelp_About) {
            this.m_viewer.showDialog(21);
            return;
        }
        if (object == this.m_menuBar.m_mHelp_Applet) {
            this.m_viewer.showDialog(22);
            return;
        }
        if (object == this.m_menuBar.m_mHelp_Language_English) {
            this.setLanguage("en");
            return;
        }
        if (object == this.m_menuBar.m_mHelp_Language_German) {
            this.setLanguage("de");
            return;
        }
        if (object == this.m_menuBar.m_mHelp_Language_French) {
            this.setLanguage("fr");
            return;
        }
        if (object == this.m_menuBar.m_mHelp_Language_Portuguese) {
            this.setLanguage("pt");
            return;
        }
        if (object == this.m_menuBar.m_mHelp_Viewer) {
            this.m_viewer.showDialog(26);
            return;
        }
        if (object == this.m_menuBar.m_mHelp_Fonts) {
            if (!PsConfig.isApplication()) {
                try {
                    URL uRL = new URL(PsConfig.getCodeBase() + "jars/systemFonts.html");
                    uRL.openConnection();
                    uRL.openStream();
                    PsConfig.getApplet().getAppletContext().showDocument(uRL, "SystemFonts");
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    PsDebug.warning("MalformedURLException when accessing HTML font page.");
                    return;
                }
                catch (IOException iOException) {
                    PsDebug.warning("IOException, no connection to HTML font page.");
                    return;
                }
            }
            Component component = (Component)PsUtil.newInstance("jvx.thirdParty.fonts.SystemFonts");
            if (component == null) {
                PsDebug.warning("could not create font canvas.\n\t Probably, class is not contained in current archive.");
                return;
            }
            PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage("fontExample"), true);
            psDialog.setLayout(new BorderLayout());
            ((Component)psDialog).setSize(400, 700);
            psDialog.add("Center", component);
            psDialog.add("South", psDialog.getBottomButtons(2));
            ((Component)psDialog).setVisible(true);
            return;
        }
        if (object == this.m_menuBar.m_mHelp_SystemProp) {
            PsDialog psDialog = new PsDialog(PsConfig.getFrame(), "System Properties and Applet Parameters", true);
            Panel panel = new Panel();
            ((Component)panel).setFont(PsConfig.getFont(1));
            panel.setLayout(new BorderLayout());
            Hashtable hashtable = PsConfig.getProperties();
            Panel panel2 = new Panel();
            panel2.setLayout(new GridLayout(hashtable.size(), 1));
            Panel panel3 = new Panel();
            panel3.setLayout(new GridLayout(hashtable.size(), 1));
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                TextField textField = string2.equals("line.separator") ? new TextField("\\n\n") : new TextField(String.valueOf(hashtable.get(string2)) + "\n");
                panel2.add(new Label(string2));
                panel3.add(textField);
            }
            panel.add("West", panel2);
            panel.add("Center", panel3);
            psDialog.setLayout(new BorderLayout());
            psDialog.add("Center", panel);
            psDialog.add("South", psDialog.getBottomButtons(2));
            ((Component)psDialog).setSize(500, 600);
            ((Component)psDialog).setVisible(true);
            return;
        }
    }

    protected Panel releasePanel(int n) {
        Panel panel = this.assurePanelAtPosition(PvControl.getPanelPosition(n));
        if (panel == null) {
            return null;
        }
        this.enablePanel(n, true);
        this.m_bPanelOutside[PvControl.getPanelPosition((int)n)] = false;
        return panel;
    }

    protected void setGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            this.enableMenu(22, false);
            this.removeInspectorPanel(1);
            this.removeInspectorPanel(2);
            this.removeInspectorPanel(3);
            this.removeInspectorPanel(4);
            if (this.isShowing()) {
                if (this.m_currentPanel_Id == 1 || this.m_currentPanel_Id == 2 || this.m_currentPanel_Id == 3 || this.m_currentPanel_Id == 4) {
                    this.showPanel(16);
                }
                if (this.m_menuBar.m_mMethod != null) {
                    this.m_menuBar.m_mMethod.removeAll();
                }
            }
            this.m_geometry = null;
            return;
        }
        if (this.m_geometry == pgGeometryIf) {
            return;
        }
        this.enableMenu(22, true);
        this.m_geometry = pgGeometryIf;
        if (this.m_menuBar.m_mMethod != null) {
            this.m_menuBar.m_mMethod.removeAll();
            this.m_geometry.fillMethodMenu(this.m_menuBar.m_mMethod);
        }
        this.removeInspectorPanel(1);
        this.removeInspectorPanel(2);
        this.removeInspectorPanel(3);
        this.removeInspectorPanel(4);
        this.enableMenu(223, this.m_geometry.isConfigurable(7));
        this.enableMenu(220, this.m_geometry.isConfigurable(4));
        this.enableMenu(221, this.m_geometry.isConfigurable(5));
        this.enableMenu(222, this.m_geometry.isConfigurable(6));
        if (this.isShowing()) {
            boolean bl = false;
            if (this.m_currentPanel_Id == 1) {
                bl = this.showPanel(12);
            } else if (this.m_currentPanel_Id == 2) {
                bl = this.showPanel(13);
            } else if (this.m_currentPanel_Id == 3) {
                bl = this.showPanel(14);
            } else if (this.m_currentPanel_Id == 4) {
                bl = this.showPanel(15);
            } else if (this.m_project != null && this.m_currentPanel_Id == 0) {
                bl = this.showPanel(10);
            } else if (this.m_display != null && this.m_currentPanel_Id == 5) {
                bl = this.showPanel(16);
            } else if (this.m_display != null && this.m_currentPanel_Id == 6) {
                bl = this.showPanel(17);
            } else {
                PsDebug.warning("missing panel[" + this.m_currentPanel_Id + "] in geom = " + pgGeometryIf.getName());
            }
            if (!bl) {
                bl = this.showPanel(16);
            }
        }
    }

    protected void enableMenu(int n, boolean bl) {
        if (this.m_menuBar != null) {
            this.m_menuBar.enableMenu(n, bl);
        }
    }

    public void init() {
        ((Component)this).setFont(PsConfig.getFont(0));
        int n = 0;
        do {
            this.m_bPanelOutside[n] = false;
        } while (++n < 7);
        this.m_inspector = new Panel();
        this.m_inspector.addKeyListener(this.m_viewer);
        this.add("Center", this.m_inspector);
        this.m_crd = new CardLayout();
        this.m_inspector.setLayout(this.m_crd);
        this.m_menuBar = new PvControlMenu(this);
        this.setMenuBar(this.m_menuBar);
    }

    public Panel getPanel(int n) {
        Panel panel = this.assurePanelAtPosition(PvControl.getPanelPosition(n));
        if (panel == null) {
            return null;
        }
        this.enablePanel(n, false);
        this.m_bPanelOutside[PvControl.getPanelPosition((int)n)] = true;
        return panel;
    }

    protected boolean enablePanel(int n, boolean bl) {
        switch (n) {
            case 10: {
                this.enableMenu(21, bl);
                break;
            }
            case 12: {
                this.enableMenu(220, bl);
                break;
            }
            case 13: {
                this.enableMenu(221, bl);
                break;
            }
            case 14: {
                this.enableMenu(222, bl);
                break;
            }
            case 15: {
                this.enableMenu(223, bl);
                break;
            }
            case 16: {
                this.enableMenu(23, bl);
                break;
            }
            case 17: {
                this.enableMenu(24, bl);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean showPanel(int n) {
        if (this.m_bPanelOutside[PvControl.getPanelPosition(n)]) {
            return false;
        }
        this.m_currentPanel_Id = PvControl.getPanelPosition(n);
        if (this.isShowing()) {
            this.m_currentPanel = this.assurePanelAtPosition(this.m_currentPanel_Id);
            if (this.m_currentPanel == null) {
                return false;
            }
            boolean bl = true;
            Container container = this.m_currentPanel.getParent();
            if (this.m_currentPanel.isShowing() && this.m_inspector != container) {
                bl = false;
                this.enablePanel(n, true);
                PsDebug.warning("Requested panel is not associated to control window", this.m_currentPanel);
            }
            this.addInspectorPanel(this.m_currentPanel_Id, this.m_currentPanel);
            this.m_crd.show(this.m_inspector, m_panelName[this.m_currentPanel_Id]);
            if (!bl) {
                ((Component)container).validate();
            }
            ((PsPanel)this.m_currentPanel).update(((PsPanel)this.m_currentPanel).getFather());
        }
        return true;
    }

    private void removeInspectorPanel(int n) {
        if (this.m_oldPanel[n] == null) {
            return;
        }
        this.m_inspector.remove(this.m_oldPanel[n]);
        this.m_oldPanel[n] = null;
    }

    private boolean hasInspectorPanel(int n) {
        return this.m_oldPanel[n] != null;
    }

    private static int getPanelPosition(int n) {
        if (n == 10) {
            return 0;
        }
        if (n == 12) {
            return 1;
        }
        if (n == 13) {
            return 2;
        }
        if (n == 14) {
            return 3;
        }
        if (n == 15) {
            return 4;
        }
        if (n == 16) {
            return 5;
        }
        if (n == 17) {
            return 6;
        }
        return -1;
    }
}

