/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuComplex;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass
extends PgElementSet {
    protected PgWeierstrassDescr m_descr;
    protected String m_surfaceName;
    private PgWeierstrass[] part;
    protected PgPointSet m_reSet;
    protected PgPointSet m_imSet;
    protected PiVector indexNumber;
    protected PiVector startInd;
    protected int m_sumVertices;
    protected int m_sumPartVertices;
    protected int m_sumPartElements;
    protected int m_numParts;
    protected int m_vertDim;
    protected int m_numBnd;
    private PiVector[][] bndIsConnectedTo;
    private boolean[][] pointIsCopy;
    private PiVector[] partIsReflection;
    protected PiVector m_bndReflectType;
    protected PiVector m_bndBelongsToPart;
    protected PiVector m_partBndNr;
    protected boolean m_bGenerateSurfaceNew = false;
    private static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass;

    public void computeSurface(PgWeierstrassDescr pgWeierstrassDescr, PiVector piVector) {
        pgWeierstrassDescr.setVertDim(this.m_vertDim);
        pgWeierstrassDescr.setConnections(this.bndIsConnectedTo);
        PuComplex[] puComplexArray = new PuComplex[this.m_vertDim];
        int n = 0;
        while (n < this.m_numParts) {
            int n2;
            if (this.partIsReflection[n].m_data[0] == -1) {
                if (pgWeierstrassDescr.getStartU(piVector, n) == 0 && pgWeierstrassDescr.getStartV(piVector, n) == 0) {
                    puComplexArray = pgWeierstrassDescr.getFStart(piVector, n);
                } else {
                    n2 = 0;
                    while (n2 < this.m_vertDim) {
                        puComplexArray[n2] = new PuComplex(this.m_reSet.getVertex((int)this.indexNumber.m_data[this.startInd.m_data[n]]).m_data[n2], this.m_imSet.getVertex((int)this.indexNumber.m_data[this.startInd.m_data[n]]).m_data[n2]);
                        ++n2;
                    }
                }
                this.part[n].computePart(pgWeierstrassDescr, piVector, n, puComplexArray);
            } else {
                this.computePartReflection(n);
            }
            n2 = this.part[n].getNumVertices();
            int n3 = 0;
            while (n3 < n2) {
                if (!this.pointIsCopy[n][n3]) {
                    this.m_reSet.setVertex(this.indexNumber.m_data[this.startInd.m_data[n] + n3], this.part[n].m_reSet.getVertex(n3));
                    this.m_imSet.setVertex(this.indexNumber.m_data[this.startInd.m_data[n] + n3], this.part[n].m_imSet.getVertex(n3));
                }
                ++n3;
            }
            ++n;
        }
        if (piVector == null) {
            this.computeVertices(pgWeierstrassDescr);
        }
    }

    public void computeVertices(PgWeierstrassDescr pgWeierstrassDescr) {
        double d = this.m_descr.getConjugationAngle();
        double d2 = Math.sin(d);
        d = Math.cos(d);
        PdVector pdVector = new PdVector();
        pdVector.setSize(this.m_vertDim);
        int n = this.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            pdVector.blend(d, this.m_reSet.getVertex(n2), d2, this.m_imSet.getVertex(n2));
            this.setVertex(n2, pdVector);
            ++n2;
        }
        this.makeVertexNormals();
        this.showMarkedBnd();
    }

    public void generatePartReflection(int n) {
        int n2 = this.partIsReflection[n].m_data[0];
        this.part[n].copy((PgGeometry)this.part[n2]);
        this.part[n].m_reSet = new PgPointSet(this.m_vertDim);
        this.part[n].m_imSet = new PgPointSet(this.m_vertDim);
        this.part[n].m_reSet.setNumVertices(this.part[n2].m_reSet.getNumVertices());
        this.part[n].m_imSet.setNumVertices(this.part[n2].m_imSet.getNumVertices());
        this.part[n].m_numBnd = this.part[n2].m_numBnd;
        this.part[n].flipOrientation();
        this.part[n].m_bndReflectType = new PiVector(this.part[n2].m_bndReflectType.m_data.length);
        int n3 = 0;
        while (n3 < this.part[n].m_numBnd) {
            int n4 = this.part[n2].m_bndList[n3].getVertexInd().m_data.length;
            int n5 = 0;
            while (n5 < n4) {
                this.part[n].m_bndList[n3].getVertexInd().m_data[n5] = this.part[n2].m_bndList[n3].getVertexInd().m_data[n4 - n5 - 1];
                ++n5;
            }
            this.part[n].m_bndReflectType.m_data[n3] = this.part[n2].m_bndReflectType.m_data[n3];
            ++n3;
        }
    }

    public boolean close() {
        this.m_bGenerateSurfaceNew = true;
        return super.close();
    }

    public boolean showMarkedBnd() {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < this.m_numBnd) {
            n2 = this.m_bndList[n3].getVertexInd().m_data.length;
            n = 0;
            while (n < n2) {
                this.getVertex(this.m_bndList[n3].getVertexInd().m_data[n]).clearTag(1);
                ++n;
            }
            ++n3;
        }
        n3 = this.m_descr.getMarkedBndNr();
        if (n3 > -1 && n3 < this.m_numBnd) {
            n2 = this.m_bndList[n3].getVertexInd().m_data.length;
            n = 0;
            while (n < n2) {
                this.getVertex(this.m_bndList[n3].getVertexInd().m_data[n]).setTag(1);
                ++n;
            }
        }
        return this.update(null);
    }

    public void markBnd(int n) {
        this.m_descr.setMarkedBndNr(-1);
        int n2 = 0;
        while (n2 < this.m_numBnd) {
            int n3 = this.m_bndList[n2].getElementInd().m_data.length;
            int n4 = 0;
            while (n4 < n3) {
                if (n == this.m_bndList[n2].getElementInd().m_data[n4] && this.m_bndReflectType.m_data[n2] != -1) {
                    this.m_descr.setMarkedBndNr(n2);
                    this.m_descr.setReflectType(this.m_bndReflectType.m_data[n2]);
                    this.m_descr.setReflectPartNr(this.m_bndBelongsToPart.m_data[n2]);
                    this.m_descr.setPartBndNr(this.m_partBndNr.m_data[n2]);
                }
                ++n4;
            }
            ++n2;
        }
        this.showMarkedBnd();
    }

    public PgWeierstrass(int n) {
        super(n);
        if (n != 3) {
            PsDebug.warning((String)("PgWeierstrass called with VertexDimension = " + n));
        }
        this.m_vertDim = n;
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass != null ? class$vgp$minimal$weier$PgWeierstrass : (class$vgp$minimal$weier$PgWeierstrass = PgWeierstrass.class$("vgp.minimal.weier.PgWeierstrass")))) {
            this.init();
        }
    }

    public void computePart(PgWeierstrassDescr pgWeierstrassDescr, PiVector piVector, int n, PuComplex[] puComplexArray) {
        int n2;
        if (pgWeierstrassDescr.partIsSubdivided(piVector, n)) {
            PiVector piVector2;
            if (piVector == null) {
                piVector2 = new PiVector(1);
                piVector2.setEntry(0, n);
            } else {
                int n3 = piVector.m_data.length;
                piVector2 = new PiVector(n3 + 1);
                int n4 = 0;
                while (n4 < n3) {
                    piVector2.setEntry(n4, piVector.getEntry(n4));
                    ++n4;
                }
                piVector2.setEntry(n3, n);
            }
            this.computeSurface(pgWeierstrassDescr, piVector2);
            return;
        }
        this.m_descr = pgWeierstrassDescr;
        int n5 = pgWeierstrassDescr.getNumULines(piVector, n);
        int n6 = pgWeierstrassDescr.getNumVLines(piVector, n);
        double d = (pgWeierstrassDescr.getUMax(piVector, n) - pgWeierstrassDescr.getUMin(piVector, n)) / (double)(n5 - 1);
        double d2 = (pgWeierstrassDescr.getVMax(piVector, n) - pgWeierstrassDescr.getVMin(piVector, n)) / (double)(n6 - 1);
        PuComplex[] puComplexArray2 = new PuComplex[this.m_vertDim];
        PuComplex[] puComplexArray3 = new PuComplex[this.m_vertDim];
        PuComplex puComplex = new PuComplex(pgWeierstrassDescr.getUMin(piVector, n), pgWeierstrassDescr.getVMin(piVector, n));
        PuComplex puComplex2 = new PuComplex();
        PuComplex puComplex3 = new PuComplex(puComplex);
        PuComplex puComplex4 = new PuComplex();
        int n7 = this.m_descr.m_intDiscr.getValue();
        if (n7 < 1) {
            n7 = 1;
        }
        int n8 = 0;
        while (n8 < this.m_vertDim) {
            this.m_reSet.getVertex((int)0).m_data[n8] = PuComplex.re((PuComplex)puComplexArray[n8]);
            this.m_imSet.getVertex((int)0).m_data[n8] = PuComplex.im((PuComplex)puComplexArray[n8]);
            puComplexArray2[n8] = new PuComplex(puComplexArray[n8]);
            ++n8;
        }
        puComplex2 = new PuComplex(pgWeierstrassDescr.transform(piVector, n, puComplex));
        n8 = 1;
        while (n8 < n6) {
            puComplex3.add(PuComplex.mult((PuComplex)PuComplex.I, (double)d2));
            puComplex4 = new PuComplex(pgWeierstrassDescr.transform(piVector, n, puComplex3));
            puComplexArray3 = this.cIntegrate(piVector, n, puComplex2, puComplex4, puComplexArray2, n7);
            n2 = 0;
            while (n2 < this.m_vertDim) {
                this.m_reSet.getVertex((int)n8).m_data[n2] = PuComplex.re((PuComplex)puComplexArray3[n2]);
                this.m_imSet.getVertex((int)n8).m_data[n2] = PuComplex.im((PuComplex)puComplexArray3[n2]);
                puComplexArray2[n2] = new PuComplex(puComplexArray3[n2]);
                ++n2;
            }
            puComplex2 = new PuComplex(puComplex4);
            ++n8;
        }
        PuComplex[] puComplexArray4 = new PuComplex[this.m_vertDim];
        n2 = 0;
        while (n2 < this.m_vertDim) {
            puComplexArray4[n2] = new PuComplex(puComplexArray[n2]);
            ++n2;
        }
        PuComplex puComplex5 = new PuComplex(pgWeierstrassDescr.getUMin(piVector, n), pgWeierstrassDescr.getVMin(piVector, n));
        PuComplex puComplex6 = new PuComplex(puComplex5);
        int n9 = 1;
        while (n9 < n5) {
            puComplex6.add(PuComplex.mult((PuComplex)PuComplex.ONE, (double)d));
            puComplex2 = new PuComplex(pgWeierstrassDescr.transform(piVector, n, puComplex5));
            puComplex4 = new PuComplex(pgWeierstrassDescr.transform(piVector, n, puComplex6));
            puComplexArray2 = this.cIntegrate(piVector, n, puComplex2, puComplex4, puComplexArray4, n7);
            puComplex = new PuComplex(puComplex6);
            puComplex3 = new PuComplex(puComplex);
            puComplex2 = new PuComplex(puComplex4);
            int n10 = 0;
            while (n10 < this.m_vertDim) {
                puComplexArray4[n10] = new PuComplex(puComplexArray2[n10]);
                this.m_reSet.getVertex((int)(n9 * n6)).m_data[n10] = PuComplex.re((PuComplex)puComplexArray2[n10]);
                this.m_imSet.getVertex((int)(n9 * n6)).m_data[n10] = PuComplex.im((PuComplex)puComplexArray2[n10]);
                ++n10;
            }
            puComplex5 = new PuComplex(puComplex6);
            n10 = 1;
            while (n10 < n6) {
                PuComplex puComplex7 = PuComplex.mult((PuComplex)PuComplex.I, (double)d2);
                puComplex3.add(puComplex7);
                puComplex4 = new PuComplex(pgWeierstrassDescr.transform(piVector, n, puComplex3));
                puComplexArray3 = this.cIntegrate(piVector, n, puComplex2, puComplex4, puComplexArray2, n7);
                int n11 = 0;
                while (n11 < this.m_vertDim) {
                    this.m_reSet.getVertex((int)(n10 + n6 * n9)).m_data[n11] = PuComplex.re((PuComplex)puComplexArray3[n11]);
                    this.m_imSet.getVertex((int)(n10 + n6 * n9)).m_data[n11] = PuComplex.im((PuComplex)puComplexArray3[n11]);
                    puComplexArray2[n11] = new PuComplex(puComplexArray3[n11]);
                    ++n11;
                }
                puComplex2 = new PuComplex(puComplex4);
                ++n10;
            }
            ++n9;
        }
    }

    public PuComplex[] cIntegrate(PiVector piVector, int n, PuComplex puComplex, PuComplex puComplex2, PuComplex[] puComplexArray, int n2) {
        PuComplex[] puComplexArray2 = new PuComplex[this.m_vertDim];
        PuComplex[] puComplexArray3 = new PuComplex[this.m_vertDim];
        PuComplex puComplex3 = new PuComplex(puComplex);
        PuComplex puComplex4 = PuComplex.div((PuComplex)PuComplex.sub((PuComplex)puComplex2, (PuComplex)puComplex), (double)n2);
        puComplexArray2 = this.m_descr.fun(piVector, n, puComplex);
        puComplexArray3 = this.m_descr.fun(piVector, n, puComplex2);
        int n3 = 0;
        while (n3 < this.m_vertDim) {
            puComplexArray2[n3].add(puComplexArray3[n3]);
            puComplexArray2[n3].div(2.0);
            puComplexArray2[n3].mult(puComplex4);
            ++n3;
        }
        n3 = 1;
        while (n3 < n2) {
            puComplex3.add(puComplex4);
            puComplexArray3 = this.m_descr.fun(piVector, n, puComplex3);
            int n4 = 0;
            while (n4 < this.m_vertDim) {
                puComplexArray2[n4].add(PuComplex.mult((PuComplex)puComplexArray3[n4], (PuComplex)puComplex4));
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_vertDim) {
            puComplexArray2[n3].add(puComplexArray[n3]);
            ++n3;
        }
        return puComplexArray2;
    }

    public boolean setSurfaceName(String string, String string2) {
        this.m_surfaceName = string;
        String string3 = string2 + this.m_surfaceName;
        this.m_descr = (PgWeierstrassDescr)((Object)PsUtil.newInstance((String)string3));
        if (this.m_descr == null) {
            return false;
        }
        this.setDescr(this.m_descr);
        this.setName(this.m_surfaceName);
        return true;
    }

    public void generateSurface(PgWeierstrassDescr pgWeierstrassDescr) {
        this.generateSurface(pgWeierstrassDescr, null);
    }

    public void generateSurface(PgWeierstrassDescr pgWeierstrassDescr, PiVector piVector) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        this.m_numParts = pgWeierstrassDescr.getNumParts(piVector);
        this.partIsReflection = new PiVector[this.m_numParts];
        int n10 = 0;
        while (n10 < this.m_numParts) {
            this.partIsReflection[n10] = new PiVector();
            this.partIsReflection[n10].setSize(3);
            this.partIsReflection[n10].m_data[0] = -1;
            ++n10;
        }
        PiVector[] piVectorArray = pgWeierstrassDescr.getReflections(piVector, this.m_numParts);
        int n11 = 0;
        while (n11 < this.m_numParts) {
            this.partIsReflection[n11].copy(piVectorArray[n11]);
            ++n11;
        }
        this.part = new PgWeierstrass[this.m_numParts];
        this.m_sumVertices = 0;
        this.m_sumPartElements = 0;
        this.m_sumPartVertices = 0;
        n11 = 0;
        while (n11 < this.m_numParts) {
            this.part[n11] = new PgWeierstrass(this.m_vertDim);
            if (this.partIsReflection[n11].m_data[0] == -1) {
                this.part[n11].generatePart(pgWeierstrassDescr, piVector, n11);
            } else {
                this.generatePartReflection(n11);
            }
            this.m_sumPartElements += this.part[n11].getNumElements();
            this.m_sumVertices += this.part[n11].getNumVertices();
            ++n11;
        }
        this.bndIsConnectedTo = new PiVector[this.m_numParts][];
        n11 = 0;
        while (n11 < this.m_numParts) {
            this.bndIsConnectedTo[n11] = new PiVector[this.part[n11].m_numBnd];
            n9 = 0;
            while (n9 < this.part[n11].m_numBnd) {
                this.bndIsConnectedTo[n11][n9] = new PiVector();
                this.bndIsConnectedTo[n11][n9].setSize(2);
                this.bndIsConnectedTo[n11][n9].m_data[0] = -1;
                ++n9;
            }
            ++n11;
        }
        pgWeierstrassDescr.setReflection(this.partIsReflection);
        PiVector[][] piVectorArray2 = pgWeierstrassDescr.getConnections(piVector, this.bndIsConnectedTo, this.m_numParts);
        n9 = 0;
        while (n9 < this.m_numParts) {
            n8 = 0;
            while (n8 < this.part[n9].m_numBnd) {
                this.bndIsConnectedTo[n9][n8].copy(piVectorArray2[n9][n8]);
                ++n8;
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < this.m_numParts) {
            if (this.partIsReflection[n9].m_data[0] != -1 && pgWeierstrassDescr.connectReflection(piVector, n9)) {
                n8 = this.partIsReflection[n9].m_data[0];
                n7 = this.partIsReflection[n9].m_data[1];
                this.bndIsConnectedTo[n9][n7].m_data[0] = n8;
                this.bndIsConnectedTo[n8][n7].m_data[0] = n9;
                this.bndIsConnectedTo[n9][n7].m_data[1] = n7;
                this.bndIsConnectedTo[n8][n7].m_data[1] = n7;
            }
            ++n9;
        }
        this.m_numBnd = 0;
        n9 = 0;
        while (n9 < this.m_numParts) {
            n8 = 0;
            while (n8 < this.part[n9].m_numBnd) {
                if (this.bndIsConnectedTo[n9][n8].m_data[0] == -1) {
                    ++this.m_numBnd;
                }
                ++n8;
            }
            ++n9;
        }
        this.indexNumber = new PiVector();
        this.indexNumber.setSize(this.m_sumVertices);
        this.startInd = new PiVector();
        this.startInd.setSize(this.m_numParts);
        this.assureBoundary(this.m_numBnd);
        this.m_bndReflectType = new PiVector(this.m_numBnd);
        this.m_bndBelongsToPart = new PiVector(this.m_numBnd);
        this.m_partBndNr = new PiVector(this.m_numBnd);
        this.pointIsCopy = new boolean[this.m_numParts][];
        n9 = 0;
        while (n9 < this.m_numParts) {
            n8 = this.part[n9].getNumVertices();
            this.pointIsCopy[n9] = new boolean[n8];
            n7 = 0;
            while (n7 < n8) {
                this.pointIsCopy[n9][n7] = false;
                ++n7;
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < this.m_numParts) {
            n8 = 0;
            while (n8 < this.part[n9].m_numBnd) {
                if (this.bndIsConnectedTo[n9][n8].m_data[0] > -1) {
                    if (this.bndIsConnectedTo[n9][n8].m_data[0] < n9) {
                        n7 = this.part[n9].m_bndList[n8].getVertexInd().m_data.length;
                        n6 = 0;
                        while (n6 < n7) {
                            this.pointIsCopy[n9][this.part[n9].m_bndList[n8].getVertexInd().m_data[n6]] = true;
                            ++n6;
                        }
                    } else if (this.bndIsConnectedTo[n9][n8].m_data[0] == n9 && this.bndIsConnectedTo[n9][n8].m_data[1] < n8) {
                        n7 = this.part[n9].m_bndList[n8].getVertexInd().m_data.length;
                        n6 = 0;
                        while (n6 < n7) {
                            this.pointIsCopy[n9][this.part[n9].m_bndList[n8].getVertexInd().m_data[n6]] = true;
                            ++n6;
                        }
                    }
                }
                ++n8;
            }
            ++n9;
        }
        n9 = 0;
        n8 = 0;
        n7 = 0;
        n6 = 0;
        while (n6 < this.m_numParts) {
            this.startInd.m_data[n6] = n9;
            n5 = this.part[n6].getNumVertices();
            n4 = 0;
            while (n4 < n5) {
                if (!this.pointIsCopy[n6][n4]) {
                    this.indexNumber.m_data[this.startInd.m_data[n6] + n4] = n7++;
                    ++this.m_sumPartVertices;
                }
                ++n8;
                ++n4;
            }
            n9 = n8;
            ++n6;
        }
        this.setNumVertices(this.m_sumPartVertices);
        this.setNumElements(this.m_sumPartElements);
        this.m_reSet = new PgPointSet(this.m_vertDim);
        this.m_imSet = new PgPointSet(this.m_vertDim);
        this.m_reSet.setNumVertices(this.m_sumPartVertices);
        this.m_imSet.setNumVertices(this.m_sumPartVertices);
        n6 = 0;
        while (n6 < this.m_numParts) {
            n5 = 0;
            while (n5 < this.part[n6].m_numBnd) {
                if (this.bndIsConnectedTo[n6][n5].m_data[0] > -1) {
                    if (this.bndIsConnectedTo[n6][n5].m_data[0] < n6) {
                        n4 = this.bndIsConnectedTo[n6][n5].m_data[0];
                        n3 = this.bndIsConnectedTo[n6][n5].m_data[1];
                        n2 = this.part[n6].m_bndList[n5].getVertexInd().m_data.length;
                        n = 0;
                        while (n < n2) {
                            this.indexNumber.m_data[this.startInd.m_data[n6] + this.part[n6].m_bndList[n5].getVertexInd().m_data[n]] = this.indexNumber.m_data[this.startInd.m_data[n4] + this.part[n4].m_bndList[n3].getVertexInd().m_data[n2 - n - 1]];
                            ++n;
                        }
                    } else if (this.bndIsConnectedTo[n6][n5].m_data[0] == n6 && this.bndIsConnectedTo[n6][n5].m_data[1] < n5) {
                        n4 = this.bndIsConnectedTo[n6][n5].m_data[1];
                        n3 = this.part[n6].m_bndList[n5].getVertexInd().m_data.length;
                        n2 = 0;
                        while (n2 < n3) {
                            this.indexNumber.m_data[this.startInd.m_data[n6] + this.part[n6].m_bndList[n5].getVertexInd().m_data[n2]] = this.indexNumber.m_data[this.startInd.m_data[n6] + this.part[n6].m_bndList[n4].getVertexInd().m_data[n3 - n2 - 1]];
                            ++n2;
                        }
                    }
                }
                ++n5;
            }
            ++n6;
        }
        n6 = 0;
        n5 = 0;
        while (n5 < this.m_numParts) {
            n4 = 0;
            while (n4 < this.part[n5].m_numBnd) {
                if (this.bndIsConnectedTo[n5][n4].m_data[0] == -1) {
                    n3 = this.part[n5].m_bndList[n4].getVertexInd().m_data.length;
                    this.m_bndList[n6].setNumVertices(n3);
                    this.m_bndList[n6].getVertexInd().setSize(n3);
                    this.m_bndList[n6].getElementInd().setSize(n3 - 1);
                    n2 = 0;
                    while (n2 < n3) {
                        this.m_bndList[n6].getVertexInd().m_data[n2] = this.indexNumber.m_data[this.startInd.m_data[n5] + this.part[n5].m_bndList[n4].getVertexInd().m_data[n2]];
                        ++n2;
                    }
                    this.m_bndReflectType.m_data[n6] = this.part[n5].m_bndReflectType.m_data[n4];
                    this.m_bndBelongsToPart.m_data[n6] = n5;
                    this.m_partBndNr.m_data[n6] = n4;
                    ++n6;
                }
                ++n4;
            }
            ++n5;
        }
        this.setDimOfElements(pgWeierstrassDescr.getDimOfElements());
        n5 = 0;
        n4 = 0;
        while (n4 < this.m_numParts) {
            n3 = this.part[n4].getNumElements();
            n2 = 0;
            while (n2 < n3) {
                if (this.m_dimOfElements == -1) {
                    this.m_element[n5].setSize(this.part[n4].getElement((int)n2).m_data.length);
                }
                n = this.part[n4].getElement((int)n2).m_data.length;
                int n12 = 0;
                while (n12 < n) {
                    this.m_element[n5].m_data[n12] = this.indexNumber.m_data[this.startInd.m_data[n4] + this.part[n4].m_element[n2].m_data[n12]];
                    ++n12;
                }
                ++n5;
                ++n2;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numBnd) {
            this.m_bndList[n4].makeElementInd();
            ++n4;
        }
        if (piVector == null) {
            this.makeNeighbour();
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_descr) {
            this.generateSurface(this.m_descr);
            this.computeSurface(this.m_descr);
            this.markBnd(-1);
            return super.update((Object)this);
        }
        if (object == this.m_descr.m_intDiscr) {
            if (this.m_bGenerateSurfaceNew) {
                this.generateSurface(this.m_descr);
                this.m_bGenerateSurfaceNew = false;
            }
            this.computeSurface(this.m_descr);
            return super.update((Object)this);
        }
        if (object == this.m_descr.m_conjugation) {
            if (this.m_bGenerateSurfaceNew) {
                this.generateSurface(this.m_descr);
                this.computeSurface(this.m_descr);
                this.m_bGenerateSurfaceNew = false;
            } else {
                this.computeVertices(this.m_descr);
            }
            return super.update((Object)this);
        }
        if (object == this) {
            this.m_bGenerateSurfaceNew = true;
        }
        return super.update(object);
    }

    public void setDescr(PgWeierstrassDescr pgWeierstrassDescr) {
        this.m_descr = pgWeierstrassDescr;
        this.m_descr.setParent((PsUpdateIf)this);
    }

    public PgWeierstrassDescr getDescr() {
        return this.m_descr;
    }

    public void generatePart(PgWeierstrassDescr pgWeierstrassDescr, PiVector piVector, int n) {
        if (pgWeierstrassDescr.partIsSubdivided(piVector, n)) {
            PiVector piVector2;
            if (piVector == null) {
                piVector2 = new PiVector(1);
                piVector2.setEntry(0, n);
            } else {
                int n2 = piVector.m_data.length;
                piVector2 = new PiVector(n2 + 1);
                int n3 = 0;
                while (n3 < n2) {
                    piVector2.setEntry(n3, piVector.getEntry(n3));
                    ++n3;
                }
                piVector2.setEntry(n2, n);
            }
            this.generateSurface(pgWeierstrassDescr, piVector2);
            return;
        }
        int n4 = pgWeierstrassDescr.getNumULines(piVector, n);
        int n5 = pgWeierstrassDescr.getNumVLines(piVector, n);
        this.setDimOfElements(pgWeierstrassDescr.getDimOfElements());
        this.setNumVertices(n4 * n5);
        this.makeQuadrConn(n4, n5);
        this.makeQuadrBnd(n4, n5);
        this.m_reSet = new PgPointSet(this.m_vertDim);
        this.m_imSet = new PgPointSet(this.m_vertDim);
        this.m_reSet.setNumVertices(n4 * n5);
        this.m_imSet.setNumVertices(n4 * n5);
        this.m_numBnd = 4;
        this.m_bndReflectType = new PiVector(4);
        this.m_bndReflectType.setConstant(-1);
        pgWeierstrassDescr.getBndReflectType(piVector, n, this.m_bndReflectType);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void computePartReflection(int n) {
        int n2;
        int n3;
        int n4;
        PdVector pdVector;
        PdVector pdVector2;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        PdVector pdVector3;
        PdMatrix pdMatrix;
        PdMatrix pdMatrix2;
        if (this.partIsReflection[n].m_data[2] == 0) {
            pdMatrix2 = new PdMatrix();
            pdMatrix = new PdMatrix();
            pdVector3 = new PdVector(3);
            n9 = this.partIsReflection[n].m_data[0];
            n8 = this.partIsReflection[n].m_data[1];
            n7 = this.part[n9].m_bndList[n8].getVertexInd().m_data.length;
            n6 = this.part[n9].m_bndList[n8].getVertexInd().m_data[0];
            n5 = this.part[n9].m_bndList[n8].getVertexInd().m_data[n7 - 1];
            pdVector3.sub(this.part[n9].m_imSet.getVertex(n5), this.part[n9].m_imSet.getVertex(n6));
            pdMatrix2 = PuReflect.rotateLine((PdVector)this.part[n9].m_imSet.getVertex(n6), (PdVector)pdVector3);
            pdMatrix = PuReflect.planeReflect((PdVector)this.part[n9].m_reSet.getVertex(n6), (PdVector)pdVector3);
            pdVector2 = new PdVector(4);
            pdVector = new PdVector(4);
            pdVector2.m_data[3] = 1.0;
            pdVector.m_data[3] = 1.0;
            n4 = this.part[n].getNumVertices();
            n3 = 0;
            while (n3 < n4) {
                n2 = 0;
                do {
                    pdVector.m_data[n2] = this.part[n9].m_reSet.getVertex((int)n3).m_data[n2];
                    pdVector2.m_data[n2] = this.part[n9].m_imSet.getVertex((int)n3).m_data[n2];
                } while (++n2 < 3);
                pdVector2.leftMultMatrix(pdMatrix2);
                pdVector.leftMultMatrix(pdMatrix);
                n2 = 0;
                do {
                    this.part[n].m_imSet.getVertex((int)n3).m_data[n2] = pdVector2.m_data[n2];
                    this.part[n].m_reSet.getVertex((int)n3).m_data[n2] = pdVector.m_data[n2];
                } while (++n2 < 3);
                ++n3;
            }
        }
        if (this.partIsReflection[n].m_data[2] == 1) {
            pdMatrix2 = new PdMatrix();
            pdMatrix = new PdMatrix();
            pdVector3 = new PdVector(3);
            n9 = this.partIsReflection[n].m_data[0];
            n8 = this.partIsReflection[n].m_data[1];
            n7 = this.part[n9].m_bndList[n8].getVertexInd().m_data.length;
            n6 = this.part[n9].m_bndList[n8].getVertexInd().m_data[0];
            n5 = this.part[n9].m_bndList[n8].getVertexInd().m_data[n7 - 1];
            pdVector3.sub(this.part[n9].m_reSet.getVertex(n5), this.part[n9].m_reSet.getVertex(n6));
            pdMatrix2 = PuReflect.rotateLine((PdVector)this.part[n9].m_reSet.getVertex(n6), (PdVector)pdVector3);
            pdMatrix = PuReflect.planeReflect((PdVector)this.part[n9].m_imSet.getVertex(n6), (PdVector)pdVector3);
            pdVector2 = new PdVector(4);
            pdVector = new PdVector(4);
            pdVector2.m_data[3] = 1.0;
            pdVector.m_data[3] = 1.0;
            n4 = this.part[n].getNumVertices();
            n3 = 0;
            while (n3 < n4) {
                n2 = 0;
                do {
                    pdVector.m_data[n2] = this.part[n9].m_reSet.getVertex((int)n3).m_data[n2];
                    pdVector2.m_data[n2] = this.part[n9].m_imSet.getVertex((int)n3).m_data[n2];
                } while (++n2 < 3);
                pdVector2.leftMultMatrix(pdMatrix);
                pdVector.leftMultMatrix(pdMatrix2);
                n2 = 0;
                do {
                    this.part[n].m_imSet.getVertex((int)n3).m_data[n2] = pdVector2.m_data[n2];
                    this.part[n].m_reSet.getVertex((int)n3).m_data[n2] = pdVector.m_data[n2];
                } while (++n2 < 3);
                ++n3;
            }
        }
    }

    public void init() {
        super.init();
    }

    public void computeSurface(PgWeierstrassDescr pgWeierstrassDescr) {
        this.computeSurface(pgWeierstrassDescr, null);
    }
}

