/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.fractal;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;
import vgp.tutor.fractal.PjFractalImage;

public class PaFractalImage
extends Applet
implements Runnable {
    public Frame m_frame = null;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";
    protected String[][] m_parm = new String[][]{{"Console", "String", "Hide", "Show/Hide VGP-console for debugging"}, {"Control", "String", "Show", "Show/Hide control panel"}, {"Frame", "String", "Hide", "Show/Hide frame around applet"}, {"Panel", "String", "Project", "Name of initial panel if control panel is showing"}};

    public void stop() {
        this.m_viewer.stop();
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public String[][] getParameterInfo() {
        return this.m_parm;
    }

    public void destroy() {
        this.m_viewer.destroy();
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaFractalImage paFractalImage = new PaFractalImage();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paFractalImage, stringArray);
        psMainFrame.pack();
        paFractalImage.m_frame = psMainFrame;
        paFractalImage.init();
        psMainFrame.setBounds(new Rectangle(420, 5, 300, 300));
        psMainFrame.setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier" + "\r\n" + "Version: " + "1.00" + "\r\n" + "Applet shows usage of texture" + "\r\n";
    }

    public void run() {
        this.drawMessage("Loading display ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.drawMessage("Loading geometry ...");
        PjFractalImage pjFractalImage = new PjFractalImage();
        this.m_viewer.addProject((PjProject)pjFractalImage);
        this.m_viewer.selectProject(pjFractalImage.getName());
        this.setLayout(new BorderLayout());
        PvDisplayIf pvDisplayIf = this.m_viewer.getDisplay();
        this.add("Center", (Component)pvDisplayIf);
        this.validate();
        this.startFromThread();
    }

    public void init() {
        this.drawMessage("Loading viewer ...");
        PsConfig.init((Applet)this, null, (Frame)this.m_frame);
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

