/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.fractal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import jv.number.PuComplex;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjFractalImage
extends PjProject {
    protected Image m_image;
    private MemoryImageSource mis;
    private PiVector m_pix = new PiVector();
    protected int m_imageHeight;
    protected int m_imageWidth;
    protected PuInteger m_maxNumIter;
    protected PdVector m_bounds = new PdVector(4);
    protected PuInteger m_coarseness;
    private static /* synthetic */ Class class$vgp$tutor$fractal$PjFractalImage;

    public void markVertices(PvPickEvent pvPickEvent) {
        PiVector piVector = pvPickEvent.getMarkBox();
        int[] nArray = piVector.m_data;
        double d = this.m_bounds.m_data[2] - this.m_bounds.m_data[0];
        double d2 = this.m_bounds.m_data[3] - this.m_bounds.m_data[1];
        double d3 = this.m_bounds.m_data[0] + d * (double)nArray[0] / ((double)this.m_imageWidth - 1.0);
        double d4 = this.m_bounds.m_data[0] + d * (double)nArray[2] / ((double)this.m_imageWidth - 1.0);
        double d5 = this.m_bounds.m_data[1] + d2 * (double)nArray[1] / ((double)this.m_imageHeight - 1.0);
        double d6 = this.m_bounds.m_data[1] + d2 * (double)nArray[3] / ((double)this.m_imageHeight - 1.0);
        this.computeImage(d3, d5, d4, d6);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.update(null);
    }

    public PjFractalImage() {
        super("Mandelbrot Set");
        this.m_maxNumIter = new PuInteger("Number of Iterations", (PsUpdateIf)this);
        this.m_coarseness = new PuInteger("Coarseness", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$fractal$PjFractalImage != null ? class$vgp$tutor$fractal$PjFractalImage : (class$vgp$tutor$fractal$PjFractalImage = PjFractalImage.class$("vgp.tutor.fractal.PjFractalImage")))) {
            this.init();
        }
    }

    public void computeImage(double d, double d2, double d3, double d4) {
        this.m_bounds.set(d, d2, d3, d4);
        Dimension dimension = this.getDisplay().getSize();
        if (dimension.height == -1 || dimension.width == -1) {
            dimension.height = 200;
            dimension.width = 200;
        }
        if (this.mis == null || this.m_imageHeight != dimension.height || this.m_imageWidth != dimension.width) {
            this.m_imageHeight = dimension.height;
            this.m_imageWidth = dimension.width;
            this.m_pix.setSize(this.m_imageWidth * this.m_imageHeight);
            this.drawImage(this.m_pix.m_data, this.m_imageWidth, this.m_imageHeight, d, d2, d3, d4);
            this.mis = new MemoryImageSource(this.m_imageWidth, this.m_imageHeight, this.m_pix.m_data, 0, this.m_imageWidth);
            this.mis.setAnimated(true);
            this.m_image = ((Component)this.m_display).createImage(this.mis);
            return;
        }
        this.drawImage(this.m_pix.m_data, this.m_imageWidth, this.m_imageHeight, d, d2, d3, d4);
        this.mis.newPixels(0, 0, this.m_imageWidth, this.m_imageHeight);
    }

    public boolean update(Object object) {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (object == this.getInspector("Info")) {
            if (this.m_image != null) {
                pvDisplayIf.setBackgroundImage(this.m_image);
            } else {
                pvDisplayIf.setBackgroundImage(null);
            }
            pvDisplayIf.update(null);
            return true;
        }
        if (object == this.m_maxNumIter) {
            this.computeImage(this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            pvDisplayIf.update(null);
            return true;
        }
        if (object == this.m_coarseness) {
            this.computeImage(this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            pvDisplayIf.update(null);
            return true;
        }
        return super.update(object);
    }

    public void start() {
        this.computeImage(-2.5, -2.0, 1.5, 2.0);
        this.update(this.getInspector("Info"));
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            // empty if block
        }
        pvDisplayIf.showBackImage(true);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void drawImage(int[] nArray, int n, int n2, double d, double d2, double d3, double d4) {
        boolean bl = false;
        PuComplex puComplex = new PuComplex();
        PuComplex puComplex2 = new PuComplex();
        int n3 = this.m_maxNumIter.getValue();
        int n4 = this.m_coarseness.getValue();
        double d5 = (double)n4 * (d3 - d) / ((double)n - 1.0);
        double d6 = (double)n4 * (d4 - d2) / ((double)n2 - 1.0);
        double d7 = d2;
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            double d8 = d;
            int n7 = n5 * n;
            int n8 = 0;
            while (n8 < n) {
                puComplex2.set(d8, d7);
                puComplex.set(0.0, 0.0);
                bl = false;
                n6 = 0;
                while (n6 < n3) {
                    puComplex.sqr().add(puComplex2);
                    if (puComplex.sqrAbs() > 5.0) {
                        bl = true;
                        break;
                    }
                    ++n6;
                }
                int n9 = !bl ? -16777216 : 0xFF000000 | (50 + 205 * n6 / n3) % 255 << 16;
                n6 = 0;
                while (n6 < Math.min(n4, n - n8)) {
                    nArray[n7++] = n9;
                    ++n6;
                }
                d8 += d5;
                n8 += n4;
            }
            int n10 = n7 - n;
            n6 = 0;
            while (n6 < Math.min(n4, n2 - n5 - 1)) {
                n8 = 0;
                while (n8 < n) {
                    nArray[n7++] = nArray[n10++];
                    ++n8;
                }
                ++n6;
            }
            d7 += d6;
            n5 += n4;
        }
    }

    public void init() {
        super.init();
        this.m_image = null;
        this.m_pix.setSize(0);
        this.m_imageHeight = 0;
        this.m_imageWidth = 0;
        this.m_maxNumIter.setDefValue(25);
        this.m_maxNumIter.setDefBounds(2, 200, 1, 5);
        this.m_maxNumIter.init();
        this.m_coarseness.setDefValue(2);
        this.m_coarseness.setDefBounds(1, 10, 1, 2);
        this.m_coarseness.init();
    }
}

