/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.catenoid;

import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnRootFinder;

public class PgCatenoid
extends PgElementSet {
    protected boolean m_bAlternate;
    protected boolean m_bTrueInterpolant;
    protected boolean m_bFixedHeight;
    protected boolean m_bSymmetric;
    protected double m_height;
    protected boolean m_bClosed;
    protected PuDouble m_delta;
    protected PuDouble m_bottomHeight;
    protected PuDouble m_radius;
    protected PuInteger m_k;
    protected PuInteger m_n;
    private double m_defDelta = 1.0;
    private double m_defBottomHeight = -1.0;
    private double m_defRadius = 1.0;
    private int m_defK = 5;
    private int m_defN = 5;
    private PnRootFinder m_rf;
    private PuFunction m_fx;
    private double[][] m_truePairs = new double[][]{{3.0, 4.354638}, {4.0, 2.98287}, {5.0, 2.30279}, {6.0, 1.88461}, {7.0, 1.59848}, {8.0, 1.38935}, {9.0, 1.22941}, {10.0, 1.10293}, {11.0, 1.00032}, {12.0, 0.91532}, {13.0, 0.843745}, {14.0, 0.782625}, {15.0, 0.729824}, {16.0, 0.683702}, {17.0, 0.643103}, {18.0, 0.60709}, {19.0, 0.57488}, {20.0, 0.545941}, {21.0, 0.519791}, {22.0, 0.496058}, {23.0, 0.474455}, {24.0, 0.45449}, {25.0, 0.436233}, {26.0, 0.419393}, {27.0, 0.403813}, {28.0, 0.389366}, {29.0, 0.375943}, {30.0, 0.363455}, {31.0, 0.35154}, {32.0, 0.340527}, {33.0, 0.330185}, {34.0, 0.320456}, {35.0, 0.311288}, {36.0, 0.302638}, {37.0, 0.294466}, {38.0, 0.286738}, {39.0, 0.279423}, {40.0, 0.272497}, {41.0, 0.266155}, {42.0, 0.259316}, {43.0, 0.25329}, {44.0, 0.247551}, {45.0, 0.242087}, {46.0, 0.236886}, {47.0, 0.23194}, {48.0, 0.22724}, {49.0, 0.222776}, {50.0, 0.218541}, {51.0, 0.214526}, {52.0, 0.209407}, {53.0, 0.205466}, {54.0, 0.201677}, {55.0, 0.198033}, {56.0, 0.194529}, {57.0, 0.191159}, {58.0, 0.187918}, {59.0, 0.184801}, {60.0, 0.181804}, {61.0, 0.178924}, {62.0, 0.176155}, {63.0, 0.173495}, {64.0, 0.170939}, {65.0, 0.168483}, {66.0, 0.166125}, {67.0, 0.16386}, {68.0, 0.161685}, {69.0, 0.159598}, {70.0, 0.157593}, {71.0, 0.153486}, {72.0, 0.151445}, {73.0, 0.149487}, {74.0, 0.14761}, {75.0, 0.145813}, {76.0, 0.144094}, {77.0, 0.14245}, {78.0, 0.140879}, {79.0, 0.139378}, {80.0, 0.137943}, {81.0, 0.136572}, {82.0, 0.135263}, {83.0, 0.134012}, {84.0, 0.132817}, {85.0, 0.131674}, {86.0, 0.130581}, {87.0, 0.129536}, {88.0, 0.128536}, {89.0, 0.12758}, {90.0, 0.126663}, {91.0, 0.120289}, {92.0, 0.119091}, {93.0, 0.117931}, {94.0, 0.116805}, {95.0, 0.115715}, {96.0, 0.114657}, {97.0, 0.113633}, {98.0, 0.11264}, {99.0, 0.111678}, {100.0, 0.110746}};
    private static /* synthetic */ Class class$vgp$discrete$catenoid$PgCatenoid;

    protected void computeSurface() {
        double d;
        double d2 = this.m_delta.getValue();
        int n = this.m_k.getValue();
        int n2 = this.m_n.getValue();
        int n3 = n + 1;
        int n4 = n2;
        this.setNumVertices(n3 * n4);
        double d3 = Math.PI * 2 / (double)n;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        int n5 = 0;
        while (n5 < n3) {
            d = d3 * (double)n5;
            dArray[n5] = Math.cos(d);
            dArray2[n5] = Math.sin(d);
            ++n5;
        }
        double d4 = Math.PI / (double)n;
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        n5 = 0;
        while (n5 < n3) {
            d = d3 * (double)n5 + d4;
            dArray3[n5] = Math.cos(d);
            dArray4[n5] = Math.sin(d);
            ++n5;
        }
        double[] dArray5 = new double[n4];
        double[] dArray6 = new double[n4];
        double d5 = this.m_bottomHeight.getValue();
        double d6 = Math.cos(Math.PI * 2 / (double)n);
        double d7 = this.m_radius.getValue();
        double d8 = 1.0 + d6;
        d8 = d2 * d2 / d8;
        d8 = PuMath.acosh((double)d8);
        double d9 = d7 * PuMath.acosh((double)(1.0 + d2 * d2 / (d7 * d7 * (1.0 + d6)))) / d2;
        int n6 = 0;
        while (n6 < n4) {
            dArray6[n6] = d5 + d2 * (double)n6;
            dArray5[n6] = d7 * PuMath.cosh((double)(1.0 / d7 * d9 * dArray6[n6]));
            ++n6;
        }
        int n7 = 0;
        n5 = 0;
        while (n5 < n3) {
            n6 = 0;
            while (n6 < n4) {
                if (!this.m_bAlternate || n6 % 2 == 0) {
                    ((PgPointSet)this).m_vertex[n7].m_data[0] = dArray[n5] * dArray5[n6];
                    ((PgPointSet)this).m_vertex[n7].m_data[1] = dArray2[n5] * dArray5[n6];
                    ((PgPointSet)this).m_vertex[n7].m_data[2] = dArray6[n6];
                } else {
                    ((PgPointSet)this).m_vertex[n7].m_data[0] = dArray3[n5] * dArray5[n6];
                    ((PgPointSet)this).m_vertex[n7].m_data[1] = dArray4[n5] * dArray5[n6];
                    ((PgPointSet)this).m_vertex[n7].m_data[2] = dArray6[n6];
                }
                ++n7;
                ++n6;
            }
            ++n5;
        }
        if (this.m_bAlternate) {
            this.makeAlternatingQuadrConn(n3, n4, false);
        } else {
            this.makeQuadrConn(n3, n4);
        }
        this.makeQuadrBnd(n3, n4);
        if (this.m_bClosed) {
            this.close();
        }
        this.fixBoundaries();
        this.makeVertexNormals();
    }

    public PgCatenoid() {
        super(3);
        this.m_delta = new PuDouble("Height Delta", (PsUpdateIf)this);
        this.m_bottomHeight = new PuDouble("Bottom Height", (PsUpdateIf)this);
        this.m_radius = new PuDouble("Waist Radius", (PsUpdateIf)this);
        this.m_k = new PuInteger("Waist Discr", (PsUpdateIf)this);
        this.m_n = new PuInteger("Profile Discr", (PsUpdateIf)this);
        this.m_rf = new PnRootFinder();
        if (this.m_fx == null) {
            this.m_fx = new PuFunction(1, 1);
            this.m_fx.addParameter("k", 4.0);
            this.m_fx.setExpression("1+u*u/(1+cos(2*pi/k))-cosh(u)", 0);
        }
        if (((Object)((Object)this)).getClass() == (class$vgp$discrete$catenoid$PgCatenoid != null ? class$vgp$discrete$catenoid$PgCatenoid : (class$vgp$discrete$catenoid$PgCatenoid = PgCatenoid.class$("vgp.discrete.catenoid.PgCatenoid")))) {
            this.init();
        }
    }

    public int getProfileDiscr() {
        return this.m_n.getValue();
    }

    public void setProfileDiscr(int n) {
        this.m_n.setValue(n);
        if (this.m_bFixedHeight) {
            this.m_delta.setValue(this.m_height / ((double)n - 1.0));
            return;
        }
        this.updateHeight();
    }

    protected void updateHeight() {
        this.m_height = this.m_delta.getValue() * (double)(this.m_n.getValue() - 1);
        if (this.m_bSymmetric) {
            this.m_bottomHeight.setValue(-this.m_height / 2.0);
        }
    }

    public double getDelta() {
        return this.m_delta.getValue();
    }

    public void setDelta(double d) {
        this.m_delta.setValue(d);
    }

    public void optimalInterpolant() {
        this.m_fx.setParameter("k", (double)this.m_k.getValue());
        PdVector pdVector = PnRootFinder.findRoots((PuFunction)this.m_fx, (double)0.001, (double)4.5, (int)1);
        double d = pdVector.getEntry(0);
        double d2 = this.m_delta.getValue() * (double)(this.m_n.getValue() - 1);
        this.m_n.setValue(1 + (int)(d2 / d));
        double d3 = d2 / (double)(this.m_n.getValue() - 1);
        this.m_delta.setValue(d3);
        if (this.m_bSymmetric) {
            this.m_bottomHeight.setValue(-this.m_height / 2.0);
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_delta) {
            this.updateHeight();
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_bottomHeight) {
            this.updateHeight();
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_radius) {
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_k) {
            if (this.m_bTrueInterpolant) {
                if (this.m_bFixedHeight) {
                    this.optimalInterpolant();
                } else {
                    this.trueInterpolant();
                }
            }
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_n) {
            if (this.m_bFixedHeight) {
                this.m_delta.setValue(this.m_height / ((double)this.m_n.getValue() - 1.0));
            } else {
                this.updateHeight();
            }
            this.computeSurface();
            return super.update(null);
        }
        if (this.getInspector("Control") == object) {
            this.computeSurface();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public int getWaistDiscr() {
        return this.m_k.getValue();
    }

    public void setWaistDiscr(int n) {
        this.m_k.setValue(n);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public double getRadius() {
        return this.m_radius.getValue();
    }

    public void setRadius(double d) {
        this.m_radius.setValue(d);
    }

    public void init() {
        super.init();
        this.setDimOfElements(3);
        this.m_bFixedHeight = true;
        this.m_bSymmetric = true;
        this.m_bTrueInterpolant = false;
        this.m_bAlternate = false;
        this.m_bClosed = true;
        this.m_delta.setDefBounds(0.001, 4.5, 0.01, 0.1);
        this.m_delta.setDefValue(this.m_defDelta);
        this.m_delta.init();
        this.m_bottomHeight.setDefBounds(-10.0, 10.0, 0.01, 0.1);
        this.m_bottomHeight.setDefValue(this.m_defBottomHeight);
        this.m_bottomHeight.init();
        this.m_bottomHeight.setEnabled(!this.m_bSymmetric);
        this.m_radius.setDefBounds(0.001, 5.0, 0.01, 0.1);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        this.m_k.setDefBounds(3, 30, 1, 1);
        this.m_k.setDefValue(this.m_defK);
        this.m_k.init();
        this.m_n.setDefBounds(2, 30, 1, 1);
        this.m_n.setDefValue(this.m_defN);
        this.m_n.init();
        this.updateHeight();
    }

    public void trueInterpolant() {
        this.m_fx.setParameter("k", (double)this.m_k.getValue());
        PdVector pdVector = PnRootFinder.findRoots((PuFunction)this.m_fx, (double)0.001, (double)4.5, (int)1);
        this.m_delta.setValue(pdVector.getEntry(0));
        this.updateHeight();
    }

    public void computeSurface(int n, int n2) {
        this.setProfileDiscr(n);
        this.setWaistDiscr(n2);
        this.computeSurface();
    }
}

