/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.function.PuFunction;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_MoebiusStrip
extends PgSurfaceDescr {
    private double m_defTwist = 1.0;
    protected PuDouble m_twist;
    private static /* synthetic */ Class class$vgp$surface$common$PgSurface_MoebiusStrip;

    protected PdVector calc_ddf_dUdU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(-2.0 * Math.sin(d) - d2 * (-Math.sin(d) * Math.sin(d / 2.0) * 5.0 / 4.0 + Math.cos(d) * Math.cos(d / 2.0)), -2.0 * Math.cos(d) - d2 * (-Math.cos(d) * Math.sin(d / 2.0) * 5.0 / 4.0 - Math.sin(d) * Math.cos(d / 2.0)), -d2 * Math.cos(d / 2.0) / 4.0);
        return pdVector;
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 2 && this.getVMax() == -this.getVMin();
    }

    public PgSurface_MoebiusStrip() {
        this.setName("MoebiusStrip");
        this.m_twist = new PuDouble("Twist", (PsUpdateIf)this);
        this.m_function = new PuFunction(2, 3);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_MoebiusStrip != null ? class$vgp$surface$common$PgSurface_MoebiusStrip : (class$vgp$surface$common$PgSurface_MoebiusStrip = PgSurface_MoebiusStrip.class$("vgp.surface.common.PgSurface_MoebiusStrip")))) {
            this.init();
        }
    }

    protected PdVector calc_df_dU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(2.0 * Math.cos(d) - d2 * (Math.cos(d) * Math.sin(d / 2.0) + Math.sin(d) * Math.cos(d / 2.0) / 2.0), -2.0 * Math.sin(d) - d2 * (-Math.sin(d) * Math.sin(d / 2.0) + Math.cos(d) * Math.cos(d / 2.0) / 2.0), -d2 * Math.sin(d / 2.0) / 2.0);
        return pdVector;
    }

    protected PdVector calc_ddf_dVdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(0.0, 0.0, 0.0);
        return pdVector;
    }

    protected PdVector calc_ddf_dUdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(-Math.cos(d) * Math.sin(d / 2.0) + Math.sin(d) * Math.cos(d / 2.0) / 2.0, Math.sin(d) * Math.sin(d / 2.0) - Math.cos(d) * Math.cos(d / 2.0) / 2.0, -Math.sin(d / 2.0) / 2.0);
        return pdVector;
    }

    public boolean update(Object object) {
        if (object == this.m_twist) {
            this.m_function.setParameter("t", this.m_twist.getValue());
            return super.update(null);
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PdVector calc_df_dV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(-Math.sin(d) * Math.sin(d / 2.0), -Math.cos(d) * Math.sin(d / 2.0), Math.cos(d / 2.0));
        return pdVector;
    }

    public void init() {
        super.init();
        this.setMaxSize(0.0, -0.8, Math.PI * 4, 0.8);
        this.setSize(0.0, -0.8, Math.PI * 2, 0.8);
        this.setDiscr(31, 5);
        this.m_twist.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_twist.setDefValue(this.m_defTwist);
        this.m_twist.init();
        this.addParameter((PsObject)this.m_twist);
        this.m_function.setName("Coordinate Functions");
        this.m_function.setExpression("sin(u)*(2.-v*sin(t*u/2.))", 0);
        this.m_function.setExpression("cos(u)*(2.-v*sin(t*u/2.))", 1);
        this.m_function.setExpression("v*cos(t*u/2.)", 2);
        this.m_function.addParameter("t", this.m_twist.getValue());
        this.setFunction(this.m_function);
        this.useFunctionExpression(false);
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        double d3 = this.m_twist.getValue();
        pdVector.set(Math.sin(d) * (2.0 - d2 * Math.sin(d3 * d / 2.0)), Math.cos(d) * (2.0 - d2 * Math.sin(d3 * d / 2.0)), d2 * Math.cos(d3 * d / 2.0));
        return true;
    }
}

