/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.key;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.project.PjProject;
import jv.viewer.PvViewer;
import vgp.tutor.key.PjKeyframe;

public class PaKeyframe
extends Applet
implements Runnable {
    public Frame m_frame = null;
    protected PvViewer m_viewer;
    protected String[][] m_parm = new String[][]{{"Console", "String", "Hide", "Show/Hide VGP-console for debugging"}, {"Control", "String", "Hide", "Show/Hide control panel"}, {"Frame", "String", "Hide", "Show/Hide frame around applet"}, {"Panel", "String", "Project", "Name of initial panel if control panel is showing"}};
    private long m_initTime = new Date().getTime();
    private String m_drawString = "Initializing ...";

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public String[][] getParameterInfo() {
        return this.m_parm;
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaKeyframe paKeyframe = new PaKeyframe();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paKeyframe, stringArray);
        psMainFrame.pack();
        paKeyframe.m_frame = psMainFrame;
        paKeyframe.init();
        paKeyframe.start();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        psMainFrame.setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier" + "\r\n" + "Version: " + "1.10" + "\r\n" + "Demo applet showing a keyframe animation." + "\r\n";
    }

    public void run() {
        this.drawMessage("Loading viewer ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.drawMessage("Loading geometry ...");
        String string = this.m_viewer.getParameter("Model");
        if (string != null) {
            string = PsConfig.getCodeBase() + string;
        }
        String string2 = this.m_viewer.getParameter("Number");
        int n = 0;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("error parsing number of keys = " + string2));
                return;
            }
        }
        PjKeyframe pjKeyframe = new PjKeyframe();
        pjKeyframe.setFileName(string, n);
        this.m_viewer.addProject((PjProject)pjKeyframe);
        this.m_viewer.selectProject(pjKeyframe.getName());
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.m_viewer.getDisplay());
        this.validate();
        this.m_viewer.showPanel(13);
        this.startFromThread();
        System.out.println("Applet loading completed after " + (new Date().getTime() - this.m_initTime) + "ms");
    }

    public void init() {
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

