/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.transform;

import jv.geom.PgPolygonSet;
import jv.loader.PgLoader;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PjTransform
extends PjProject {
    protected PgGeometry m_base;
    protected PgPolygonSet m_surface;
    protected PuDouble m_angleXW = new PuDouble("angleXW", (PsUpdateIf)this);
    protected PuDouble m_angleYW = new PuDouble("angleYW", (PsUpdateIf)this);
    protected PuDouble m_angleZW = new PuDouble("angleZW", (PsUpdateIf)this);
    protected PdMatrix m_modelMat = new PdMatrix(4);
    protected double m_angleXWPrev;
    protected double m_angleYWPrev;
    protected double m_angleZWPrev;
    private static /* synthetic */ Class class$vgp$tutor$transform$PjTransform;

    public void rotateXW(double d) {
        this.m_modelMat.setIdentity();
        this.m_modelMat.m_data[0][0] = Math.cos(d);
        this.m_modelMat.m_data[0][3] = -Math.sin(d);
        this.m_modelMat.m_data[3][0] = Math.sin(d);
        this.m_modelMat.m_data[3][3] = Math.cos(d);
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n = 0;
        while (n < pdVectorArray.length) {
            pdVectorArray[n].leftMultMatrix(this.m_modelMat);
            ++n;
        }
    }

    public PjTransform() {
        super("Transform");
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$transform$PjTransform != null ? class$vgp$tutor$transform$PjTransform : (class$vgp$tutor$transform$PjTransform = PjTransform.class$("vgp.tutor.transform.PjTransform")))) {
            this.init();
        }
    }

    public void rotateYW(double d) {
        this.m_modelMat.setIdentity();
        this.m_modelMat.m_data[1][1] = Math.cos(d);
        this.m_modelMat.m_data[1][3] = -Math.sin(d);
        this.m_modelMat.m_data[3][1] = Math.sin(d);
        this.m_modelMat.m_data[3][3] = Math.cos(d);
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n = 0;
        while (n < pdVectorArray.length) {
            pdVectorArray[n].leftMultMatrix(this.m_modelMat);
            ++n;
        }
    }

    public boolean update(Object object) {
        if (object == this.m_angleXW) {
            double d = this.m_angleXW.getValue() - this.m_angleXWPrev;
            this.m_angleXWPrev = this.m_angleXW.getValue();
            this.rotateXW(d);
            this.m_surface.update((Object)this.m_surface);
            return true;
        }
        if (object == this.m_angleYW) {
            double d = this.m_angleYW.getValue() - this.m_angleYWPrev;
            this.m_angleYWPrev = this.m_angleYW.getValue();
            this.rotateYW(d);
            this.m_surface.update((Object)this.m_surface);
            return true;
        }
        if (object == this.m_angleZW) {
            double d = this.m_angleZW.getValue() - this.m_angleZWPrev;
            this.m_angleZWPrev = this.m_angleZW.getValue();
            this.rotateZW(d);
            this.m_surface.update((Object)this.m_surface);
            return true;
        }
        return false;
    }

    public void start() {
        PgGeometry[] pgGeometryArray = PgLoader.load((PgGeometry[])new PgGeometry[]{this.m_surface}, (String)(PsConfig.getCodeBase() + "models/polytope/Cube4d.jvx"));
        if (pgGeometryArray == null || pgGeometryArray.length == 0 || pgGeometryArray[0] == null) {
            PsDebug.warning((String)"loading failed.");
            return;
        }
        this.m_surface = (PgPolygonSet)pgGeometryArray[0];
        this.m_surface.setName("Exhibited Surface");
        this.m_surface.projectToSphere(new PdVector(4), 1.0);
        this.m_surface.setAmbientSpace(7);
        this.m_surface.setAmbientProjection(1);
        this.m_base = pgGeometryArray[0];
        this.m_base.setName("Base Block");
        this.addGeometry((PgGeometryIf)this.m_surface);
        this.selectGeometry((PgGeometryIf)this.m_surface);
        this.m_base.update((Object)this.m_base);
        this.m_surface.update((Object)this.m_surface);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_angleXW.setDefValue(0.0);
        this.m_angleXW.setDefBounds(-Math.PI, Math.PI, 0.01, 0.1);
        this.m_angleXW.init();
        this.m_angleXWPrev = 0.0;
        this.m_angleYW.setDefValue(0.0);
        this.m_angleYW.setDefBounds(-Math.PI, Math.PI, 0.01, 0.1);
        this.m_angleYW.init();
        this.m_angleYWPrev = 0.0;
        this.m_angleZW.setDefValue(0.0);
        this.m_angleZW.setDefBounds(-Math.PI, Math.PI, 0.01, 0.1);
        this.m_angleZW.init();
        this.m_angleZWPrev = 0.0;
    }

    public void rotateZW(double d) {
        this.m_modelMat.setIdentity();
        this.m_modelMat.m_data[2][2] = Math.cos(d);
        this.m_modelMat.m_data[2][3] = -Math.sin(d);
        this.m_modelMat.m_data[3][2] = Math.sin(d);
        this.m_modelMat.m_data[3][3] = Math.cos(d);
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n = 0;
        while (n < pdVectorArray.length) {
            pdVectorArray[n].leftMultMatrix(this.m_modelMat);
            ++n;
        }
    }
}

