/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.Bucket;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import java.util.Enumeration;
import java.util.Hashtable;

class InstanceCollection {
    private Hashtable table = new Hashtable(541);

    InstanceCollection() {
    }

    Object get(long l) {
        if (l == 0L) {
            return null;
        }
        int n = (int)(l >> 16);
        Bucket bucket = (Bucket)this.table.get(new Integer(n));
        short s = (short)(l & 0xFFFFL);
        return bucket.get(s);
    }

    long keyOf(Object object) {
        int n = Math.abs(object.hashCode());
        Bucket bucket = (Bucket)this.table.get(new Integer(n));
        if (bucket == null) {
            return 0L;
        }
        short s = bucket.keyOf(object);
        return s == 0 ? 0L : (long)n << 16 | (long)s;
    }

    Enumeration keys() {
        return new InstanceCollectionKeyEnumerator(this.table);
    }

    void peekObjects(KernelLink kernelLink) throws MathLinkException {
        boolean bl = false;
        kernelLink.putFunction("List", this.size());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            Object object = this.get(l);
            kernelLink.putReference(object);
        }
        kernelLink.endPacket();
    }

    long put(Object object) {
        int n = Math.abs(object.hashCode());
        Integer n2 = new Integer(n);
        Bucket bucket = (Bucket)this.table.get(n2);
        if (bucket == null) {
            bucket = new Bucket();
            this.table.put(n2, bucket);
        }
        short s = bucket.put(object);
        return (long)n << 16 | (long)s;
    }

    void remove(long l) {
        Integer n = new Integer((int)(l >> 16));
        Bucket bucket = (Bucket)this.table.get(n);
        if (bucket != null) {
            if (bucket.size() == 1) {
                this.table.remove(n);
            } else {
                short s = (short)(l & 0xFFFFL);
                bucket.remove(s);
            }
        }
    }

    int size() {
        Enumeration enumeration = this.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        return n;
    }

    class InstanceCollectionKeyEnumerator
    implements Enumeration {
        Hashtable table;
        Enumeration hashKeys;
        Integer currHashKey;
        Bucket currBucket;
        short currIndexInBucket;

        InstanceCollectionKeyEnumerator(Hashtable hashtable) {
            this.table = hashtable;
            this.hashKeys = hashtable.keys();
            this.currHashKey = null;
            this.currBucket = null;
            this.currIndexInBucket = 0;
        }

        public boolean hasMoreElements() {
            return this.currBucket != null && this.currIndexInBucket < this.currBucket.size() || this.hashKeys.hasMoreElements();
        }

        public Object nextElement() {
            if (this.currBucket == null || this.currIndexInBucket >= this.currBucket.size()) {
                if (!this.hashKeys.hasMoreElements()) {
                    return null;
                }
                this.currHashKey = (Integer)this.hashKeys.nextElement();
                this.currBucket = (Bucket)this.table.get(this.currHashKey);
                this.currIndexInBucket = 0;
            }
            short s = this.currBucket.elementAt((short)this.currIndexInBucket).i;
            this.currIndexInBucket = (short)(this.currIndexInBucket + 1);
            return new Long(this.currHashKey.longValue() << 16 | (long)s);
        }
    }
}

