/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JLinkClassLoader
extends ClassLoader {
    private static JLinkClassLoader singleton;
    private String[] extraDirs = new String[0];
    private Hashtable classes = new Hashtable();

    private JLinkClassLoader() {
    }

    public static synchronized Class classFromName(String string) throws ClassNotFoundException {
        if (singleton == null) {
            singleton = new JLinkClassLoader();
        }
        if (Utils.isJava2OrLater()) {
            return Class.forName(string, true, singleton);
        }
        return Class.forName(string);
    }

    protected synchronized Class findClass(String string) throws ClassNotFoundException {
        String string2 = String.valueOf(string.replace('.', '/')) + ".class";
        String string3 = String.valueOf(string.replace('.', File.separatorChar)) + ".class";
        int n = 0;
        while (n < this.extraDirs.length) {
            Class clazz = this.findClassGuts(this.extraDirs[n], string, string2, string3);
            if (clazz != null) {
                return clazz;
            }
            ++n;
        }
        throw new ClassNotFoundException(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClassGuts(String string, String string2, String string3, String string4) {
        Object object;
        boolean bl;
        block19: {
            FileInputStream fileInputStream;
            block17: {
                Class<?> clazz;
                char c = File.separatorChar;
                fileInputStream = null;
                boolean bl2 = bl = string.toLowerCase().endsWith(".zip") || string.toLowerCase().endsWith(".jar");
                if (bl) break block19;
                object = String.valueOf(string) + string4;
                try {
                    try {
                        String string5;
                        File file = new File((String)object);
                        fileInputStream = new FileInputStream(file);
                        int n = (int)file.length();
                        byte[] byArray = new byte[n];
                        fileInputStream.read(byArray, 0, n);
                        if (Utils.isJava2OrLater() && string2.indexOf(".") != -1 && this.getPackage(string5 = string2.substring(0, string2.lastIndexOf("."))) == null) {
                            this.definePackage(string5, null, null, null, null, null, null, null);
                        }
                        clazz = this.defineClass(string2, byArray, 0, n);
                        Object var11_17 = null;
                        if (fileInputStream == null) return clazz;
                    }
                    catch (Exception exception) {
                        break block17;
                    }
                    catch (Error error) {
                        System.err.println(error.toString());
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    fileInputStream = null;
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                fileInputStream.close();
                fileInputStream = null;
                return clazz;
            }
            Object var11_18 = null;
            if (fileInputStream == null) break block19;
            try {}
            catch (IOException iOException) {}
            fileInputStream.close();
            fileInputStream = null;
        }
        try {
            File file = new File(string);
            if (bl) {
                object = JLinkClassLoader.readFromZip(file, string3);
                if (object == null) return null;
                return this.defineClass(string2, (byte[])object, 0, ((Object)object).length);
            }
            String[] stringArray = file.list();
            if (stringArray == null) return null;
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return null;
                }
                String string6 = stringArray[n].toLowerCase();
                if ((string6.endsWith(".jar") || string6.endsWith(".zip")) && (object = (Object)JLinkClassLoader.readFromZip(file = new File(string, stringArray[n]), string3)) != null) {
                    return this.defineClass(string2, (byte[])object, 0, ((Object)object).length);
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected String findLibrary(String string) {
        String string2 = System.mapLibraryName(string);
        int n = 0;
        while (n < this.extraDirs.length) {
            File file;
            boolean bl;
            boolean bl2 = bl = this.extraDirs[n].toLowerCase().endsWith(".zip") || this.extraDirs[n].toLowerCase().endsWith(".jar");
            if (!bl && (file = new File(this.extraDirs[n], string2)).exists()) {
                return file.getPath();
            }
            ++n;
        }
        return null;
    }

    protected URL findResource(String string) {
        String string2 = string.replace('/', File.separatorChar);
        int n = 0;
        while (n < this.extraDirs.length) {
            String string3;
            File file;
            boolean bl;
            boolean bl2 = bl = this.extraDirs[n].toLowerCase().endsWith(".zip") || this.extraDirs[n].toLowerCase().endsWith(".jar");
            if (!bl && (file = new File(string3 = String.valueOf(this.extraDirs[n]) + string2)).exists()) {
                try {
                    return new URL("file:" + string3);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++n;
        }
        return null;
    }

    protected Enumeration findResources(String string) throws IOException {
        return new SingleEnum(this.findResource(string));
    }

    public static JLinkClassLoader getInstance() {
        if (singleton == null) {
            singleton = new JLinkClassLoader();
        }
        return singleton;
    }

    public static synchronized Class load(String string) throws ClassNotFoundException {
        if (singleton == null) {
            singleton = new JLinkClassLoader();
        }
        return singleton.loadClass(string, true);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz;
        block5: {
            if (Utils.isJava2OrLater()) {
                return super.loadClass(string, bl);
            }
            clazz = this.findLoadedClass(string);
            if (clazz == null) {
                try {
                    return this.findSystemClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = (Class)this.classes.get(string);
                    if (clazz != null) break block5;
                    clazz = this.findClass(string);
                    this.classes.put(string, clazz);
                }
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private static byte[] readFromZip(File file, String string) throws IOException {
        byte[] byArray = null;
        ZipFile zipFile = new ZipFile(file);
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry != null) {
            int n;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            int n2 = (int)zipEntry.getSize();
            if (n2 == -1) {
                n2 = 0;
                byte[] byArray2 = new byte[4000];
                while ((n = inputStream.read(byArray2)) != -1) {
                    n2 += n;
                }
                inputStream.close();
                inputStream = zipFile.getInputStream(zipEntry);
            }
            byArray = new byte[n2];
            int n3 = 0;
            while ((n = inputStream.read(byArray, n3, n2 - n3)) > 0) {
                n3 += n;
            }
            inputStream.close();
        }
        return byArray;
    }

    public static synchronized void setExtraDirs(String[] stringArray) {
        if (singleton == null) {
            singleton = new JLinkClassLoader();
        }
        if (stringArray == null) {
            JLinkClassLoader.singleton.extraDirs = new String[0];
        } else {
            JLinkClassLoader.singleton.extraDirs = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                JLinkClassLoader.singleton.extraDirs[n] = !stringArray[n].toLowerCase().endsWith(".jar") && !stringArray[n].toLowerCase().endsWith(".zip") && !stringArray[n].endsWith(File.separator) ? String.valueOf(JLinkClassLoader.toURLForm(stringArray[n])) + File.separator : JLinkClassLoader.toURLForm(stringArray[n]);
                ++n;
            }
        }
    }

    private static String toURLForm(String string) {
        if (Utils.isMacintosh()) {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 3 + 1);
            stringBuffer.append('/');
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == ':') {
                    stringBuffer.append('/');
                } else {
                    stringBuffer.append('%');
                    stringBuffer.append(Integer.toHexString(string.charAt(n)));
                }
                ++n;
            }
            return new String(stringBuffer);
        }
        return string;
    }

    private class SingleEnum
    implements Enumeration {
        Object element;

        SingleEnum(Object object) {
            this.element = object;
        }

        public boolean hasMoreElements() {
            return this.element != null;
        }

        public Object nextElement() {
            if (this.element == null) {
                throw new NoSuchElementException();
            }
            Object object = this.element;
            this.element = null;
            return object;
        }
    }
}

