/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkOffscreenImage;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;

public class MathCanvas
extends Canvas
implements Serializable {
    private boolean useFE;
    private boolean useTradForm;
    private int imageType = 0;
    private String mathCommand;
    private Image im;
    private transient KernelLink ml;
    public static final int GRAPHICS = 0;
    public static final int TYPESET = 1;

    public MathCanvas() {
        this.ml = StdLink.getLink();
    }

    public MathCanvas(KernelLink kernelLink) {
        this.ml = kernelLink;
    }

    public Image createImage(int n, int n2) {
        Image image = super.createImage(n, n2);
        if (!Utils.isJava2OrLater() && !Utils.isMicrosoftVM() && StdLink.getLink() != null) {
            return new JLinkOffscreenImage(image);
        }
        return image;
    }

    public Image getImage() {
        return this.im;
    }

    public String getMathCommand() {
        return this.mathCommand;
    }

    public void paint(Graphics graphics) {
        if (this.im != null) {
            int n = this.im.getHeight(this);
            int n2 = this.im.getWidth(this);
            int n3 = this.getSize().width;
            int n4 = this.getSize().height;
            if (n2 != -1 && n != -1) {
                int n5 = (n3 - n2) / 2;
                int n6 = (n4 - n) / 2;
                graphics.drawImage(this.im, n5, n6, this);
                graphics.clearRect(0, 0, n3, n6);
                graphics.clearRect(0, n6, n5, n);
                graphics.clearRect(n5 + n2, n6, n3 - n2 - n5, n);
                graphics.clearRect(0, n6 + n, n3, n4 - n - n6);
            }
        } else {
            super.paint(graphics);
        }
    }

    public void recompute() {
        if (this.mathCommand != null) {
            this.setMathCommand(this.mathCommand);
        }
    }

    public void repaintNow() {
        this.update(this.getGraphics());
        this.repaint();
    }

    public void setImage(Image image) {
        this.im = image != null && image.getClass().getName().equals("com.wolfram.jlink.JLinkOffscreenImage") ? ((JLinkOffscreenImage)image).getWrappedImage() : image;
        this.mathCommand = null;
        this.repaint();
    }

    public void setImageType(int n) {
        this.imageType = n;
    }

    public void setLink(KernelLink kernelLink) {
        this.ml = kernelLink;
    }

    public void setMathCommand(String string) {
        this.mathCommand = string;
        byte[] byArray = null;
        if (this.ml != null) {
            byArray = this.imageType == 0 ? this.ml.evaluateToImage(this.mathCommand, this.getSize().width - 4, this.getSize().height - 4, 0, this.useFE) : this.ml.evaluateToTypeset(this.mathCommand, this.getSize().width, this.useTradForm ^ true);
        }
        this.im = byArray != null ? this.getToolkit().createImage(byArray) : null;
        this.repaint();
    }

    public void setUsesFE(boolean bl) {
        this.useFE = bl;
    }

    public void setUsesTraditionalForm(boolean bl) {
        this.useTradForm = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

