/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

public class MathLinkException
extends Exception {
    String msg;
    int code;
    Throwable wrappedException;

    public MathLinkException(int n) {
        this.code = n;
        this.msg = MathLinkException.lookupMessageText(n);
    }

    public MathLinkException(int n, String string) {
        this.code = n;
        this.msg = string;
    }

    public MathLinkException(Throwable throwable) {
        this(throwable, "");
    }

    public MathLinkException(Throwable throwable, String string) {
        this.code = 1005;
        this.wrappedException = throwable;
        String string2 = "";
        if (string.endsWith(".")) {
            string2 = " ";
        } else if (string.length() > 0) {
            string2 = ". ";
        }
        this.msg = String.valueOf(string) + string2 + "Was a wrapped exception. Original exception was: " + throwable.toString();
    }

    public int getErrCode() {
        return this.code;
    }

    public String getMessage() {
        return this.msg;
    }

    public Throwable getWrappedException() {
        return this.wrappedException;
    }

    static String lookupMessageText(int n) {
        String string = null;
        switch (n) {
            case 1002: {
                string = "Array is not as deep as requested.";
                break;
            }
            case 1003: {
                string = "Expression could not be read as a complex number.";
                break;
            }
            default: {
                string = "Extended error message not available.";
            }
        }
        return string;
    }

    public String toString() {
        return "MathLinkException: " + String.valueOf(this.code) + ": " + this.msg;
    }
}

