/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkClassLoader;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.LoopbackLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.NativeLink;
import com.wolfram.jlink.NativeLoopbackLink;
import com.wolfram.jlink.WrappedKernelLink;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;

public class MathLinkFactory {
    static /* synthetic */ Class class$java$lang$String;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static KernelLink createKernelLink(MathLink mathLink) throws MathLinkException {
        return new WrappedKernelLink(mathLink);
    }

    public static KernelLink createKernelLink(String string) throws MathLinkException {
        return MathLinkFactory.createKernelLinkGuts(string, null);
    }

    public static KernelLink createKernelLink(String[] stringArray) throws MathLinkException {
        return MathLinkFactory.createKernelLinkGuts(null, stringArray);
    }

    private static KernelLink createKernelLinkGuts(String string, String[] stringArray) throws MathLinkException {
        String string2;
        if (string == null && stringArray == null) {
            throw new MathLinkException(1004, "Null argument to KernelLink constructor");
        }
        boolean bl = string != null;
        String string3 = string2 = bl ? MathLinkFactory.determineProtocol(string) : MathLinkFactory.determineProtocol(stringArray);
        if (!string2.equals("NATIVE")) {
            String string4 = "KernelLink_" + string2;
            String string5 = "com.wolfram.jlink.ext.KernelLink_" + string2;
            Class clazz = null;
            try {
                clazz = JLinkClassLoader.load(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = JLinkClassLoader.load(string5);
                }
                catch (ClassNotFoundException classNotFoundException2) {}
            }
            if (clazz != null) {
                try {
                    Object[] objectArray;
                    Class clazz2 = bl ? (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MathLinkFactory.class$("java.lang.String"))) : Class.forName("[Ljava.lang.String;");
                    Constructor constructor = clazz.getConstructor(clazz2);
                    if (bl) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = string;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = stringArray;
                    }
                    return (KernelLink)constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    if (exception instanceof InvocationTargetException) {
                        throw new MathLinkException(((InvocationTargetException)exception).getTargetException(), "Error instantiating link object of class " + clazz.getName());
                    }
                    throw new MathLinkException(exception, "Error instantiating link object of class " + clazz.getName());
                }
            }
        }
        return new WrappedKernelLink(bl ? MathLinkFactory.createMathLink(string) : MathLinkFactory.createMathLink(stringArray));
    }

    public static LoopbackLink createLoopbackLink() throws MathLinkException {
        return new NativeLoopbackLink();
    }

    public static MathLink createMathLink(String string) throws MathLinkException {
        return MathLinkFactory.createMathLinkGuts(string, null);
    }

    public static MathLink createMathLink(String[] stringArray) throws MathLinkException {
        return MathLinkFactory.createMathLinkGuts(null, stringArray);
    }

    private static MathLink createMathLinkGuts(String string, String[] stringArray) throws MathLinkException {
        String string2;
        if (string == null && stringArray == null) {
            throw new MathLinkException(1004, "Null argument to MathLink constructor");
        }
        boolean bl = string != null;
        String string3 = string2 = bl ? MathLinkFactory.determineProtocol(string) : MathLinkFactory.determineProtocol(stringArray);
        if (!string2.equals("NATIVE")) {
            String string4 = "MathLink_" + string2;
            String string5 = "com.wolfram.jlink.ext.MathLink_" + string2;
            Class clazz = null;
            try {
                clazz = JLinkClassLoader.load(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = JLinkClassLoader.load(string5);
                }
                catch (ClassNotFoundException classNotFoundException2) {}
            }
            if (clazz != null) {
                try {
                    Object[] objectArray;
                    Class clazz2 = bl ? (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MathLinkFactory.class$("java.lang.String"))) : Class.forName("[Ljava.lang.String;");
                    Constructor constructor = clazz.getConstructor(clazz2);
                    if (bl) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = string;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = stringArray;
                    }
                    return (MathLink)constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    throw new MathLinkException(1004, "Error instantiating link of class " + clazz.getName());
                }
            }
            System.err.println("J/Link Warning: could not find any Java class that implements the requested " + string2 + " protocol. This protocol name will be passed to the MathLink library to " + "see if it has a native implementation.");
        }
        return bl ? new NativeLink(string) : new NativeLink(stringArray);
    }

    private static String determineProtocol(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "NATIVE";
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().toLowerCase().equals("-linkprotocol") || !stringTokenizer.hasMoreTokens()) continue;
            string2 = stringTokenizer.nextToken().toUpperCase();
            break;
        }
        return MathLinkFactory.isNative(string2) ? "NATIVE" : string2;
    }

    private static String determineProtocol(String[] stringArray) {
        String string = "NATIVE";
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length - 1) {
                if (stringArray[n].toLowerCase().equals("-linkprotocol")) {
                    string = stringArray[n + 1].toUpperCase();
                    break;
                }
                ++n;
            }
        }
        return MathLinkFactory.isNative(string) ? "NATIVE" : string;
    }

    private static boolean isNative(String string) {
        return string.equals("NATIVE") || string.equals("LOCAL") || string.equals("FILEMAP") || string.equals("FM") || string.equals("PPC") || string.equals("TCP") || string.equals("PIPES") || string.equals("SHAREDMEMORY") || string.equals("");
    }
}

